/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URL;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.Normalizer;

final class RewriteSystem
extends BaseEntry {
    String systemIdStartString;
    URL rewritePrefix;

    public RewriteSystem(String base, String systemIdStartString, String rewritePrefix) {
        super(BaseEntry.CatalogEntryType.REWRITESYSTEM, base);
        this.setSystemIdStartString(systemIdStartString);
        this.setRewritePrefix(rewritePrefix);
    }

    public void setSystemIdStartString(String systemIdStartString) {
        CatalogMessages.reportNPEOnNull("systemIdStartString", systemIdStartString);
        this.systemIdStartString = Normalizer.normalizeURI(systemIdStartString);
    }

    public void setRewritePrefix(String rewritePrefix) {
        this.rewritePrefix = this.verifyURI("setRewritePrefix", this.baseURI, rewritePrefix);
    }

    public String getSystemIdStartString() {
        return this.systemIdStartString;
    }

    public URL getRewritePrefix() {
        return this.rewritePrefix;
    }

    @Override
    public String match(String systemId, int currentMatch) {
        if (this.systemIdStartString.length() < systemId.length() && this.systemIdStartString.equals(systemId.substring(0, this.systemIdStartString.length())) && currentMatch < this.systemIdStartString.length()) {
            String prefix = this.rewritePrefix.toExternalForm();
            String sysId = this.systemIdStartString.endsWith("/") ? systemId.substring(this.systemIdStartString.length()) : systemId.substring(this.systemIdStartString.length() + 1);
            if (prefix.endsWith("/")) {
                return prefix + sysId;
            }
            return prefix + "/" + sysId;
        }
        return null;
    }

    @Override
    public String match(String systemId) {
        return this.match(systemId, 0);
    }
}

