/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URL;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.Normalizer;

final class PublicEntry
extends BaseEntry {
    String publicId;
    URL uri;

    public PublicEntry(String base, String publicId, String uri) {
        super(BaseEntry.CatalogEntryType.PUBLIC, base);
        this.setPublicId(publicId);
        this.setURI(uri);
    }

    public void setPublicId(String publicId) {
        CatalogMessages.reportNPEOnNull("publicId", publicId);
        this.publicId = Normalizer.normalizePublicId(publicId);
    }

    public void setURI(String uri) {
        this.uri = this.verifyURI("uri", this.baseURI, uri);
    }

    public String getPublicId() {
        return this.publicId;
    }

    public URL getURI() {
        return this.uri;
    }

    @Override
    public String match(String publicId) {
        if (this.publicId.equals(publicId)) {
            return this.uri.toString();
        }
        return null;
    }
}

