/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.xml.catalog.CatalogMessages;

class Normalizer {
    Normalizer() {
    }

    static String normalizePublicId(String publicId) {
        if (publicId == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(publicId.length());
        int last = 97;
        for (int n : publicId.toCharArray()) {
            if (n == 32 && (sb.length() == 0 || last == 32)) continue;
            if (n == 9 || n == 13 || n == 10) {
                if (last == 32) continue;
                sb.append(' ');
                last = 32;
                continue;
            }
            sb.append((char)n);
            last = n;
        }
        if (last == 32) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    static String encodeURN(String publicId) {
        String urn = Normalizer.normalizePublicId(publicId);
        try {
            urn = URLEncoder.encode(urn, "UTF-8");
            urn = urn.replace("::", ";");
            urn = urn.replace("//", ":");
        }
        catch (UnsupportedEncodingException ex) {
            CatalogMessages.reportRunTimeError("OtherError", ex);
        }
        return "urn:publicid:" + urn;
    }

    static String decodeURN(String urn) {
        if (urn == null || !urn.startsWith("urn:publicid:")) {
            return urn;
        }
        String publicId = urn.substring(13);
        try {
            publicId = publicId.replace(":", "//");
            publicId = publicId.replace(";", "::");
            publicId = URLDecoder.decode(publicId, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            CatalogMessages.reportRunTimeError("OtherError", ex);
        }
        return publicId;
    }

    static String normalizeURI(String uriref) {
        byte[] bytes;
        if (uriref == null) {
            return null;
        }
        uriref = uriref.trim();
        try {
            bytes = uriref.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return uriref;
        }
        StringBuilder newRef = new StringBuilder(bytes.length);
        for (int count = 0; count < bytes.length; ++count) {
            int ch = bytes[count] & 0xFF;
            if (ch <= 32 || ch > 127 || ch == 34 || ch == 60 || ch == 62 || ch == 92 || ch == 94 || ch == 96 || ch == 123 || ch == 124 || ch == 125 || ch == 127) {
                newRef.append("%").append(String.format("%02X", ch));
                continue;
            }
            newRef.append((char)bytes[count]);
        }
        return newRef.toString().trim();
    }
}

