/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.catalog.AltCatalog;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.Catalog;
import javax.xml.catalog.CatalogFeatures;
import javax.xml.catalog.CatalogImpl;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.DelegatePublic;
import javax.xml.catalog.DelegateSystem;
import javax.xml.catalog.DelegateUri;
import javax.xml.catalog.PublicEntry;
import javax.xml.catalog.RewriteSystem;
import javax.xml.catalog.RewriteUri;
import javax.xml.catalog.SystemEntry;
import javax.xml.catalog.SystemSuffix;
import javax.xml.catalog.UriEntry;
import javax.xml.catalog.UriSuffix;
import javax.xml.catalog.Util;

class GroupEntry
extends BaseEntry {
    static final int ATTRIBUTE_PREFER = 0;
    static final int ATTRIBUTE_DEFFER = 1;
    static final int ATTRIBUTE_RESOLUTION = 2;
    CatalogFeatures features;
    boolean isPreferPublic = true;
    CatalogImpl parent = null;
    CatalogImpl catalog;
    List<BaseEntry> entries = new ArrayList<BaseEntry>();
    Map<String, CatalogImpl> delegateCatalogs = new HashMap<String, CatalogImpl>();
    Map<String, CatalogImpl> loadedCatalogs = new HashMap<String, CatalogImpl>();
    List<String> catalogsSearched = new ArrayList<String>();
    boolean isInstantMatch = false;
    String rewriteMatch = null;
    int longestRewriteMatch = 0;
    String suffixMatch = null;
    int longestSuffixMatch = 0;
    boolean systemEntrySearched = false;

    public GroupEntry(BaseEntry.CatalogEntryType type, CatalogImpl parent) {
        super(type);
        this.parent = parent;
    }

    public GroupEntry(String base, String ... attributes) {
        this((CatalogImpl)null, base, attributes);
    }

    public void reset() {
        this.isInstantMatch = false;
        this.rewriteMatch = null;
        this.longestRewriteMatch = 0;
        this.suffixMatch = null;
        this.longestSuffixMatch = 0;
        this.systemEntrySearched = false;
    }

    public GroupEntry(CatalogImpl catalog, String base, String ... attributes) {
        super(BaseEntry.CatalogEntryType.GROUP, base);
        this.setPrefer(attributes[0]);
        this.catalog = catalog;
    }

    void setCatalog(CatalogImpl catalog) {
        this.catalog = catalog;
    }

    public void addEntry(BaseEntry entry) {
        this.entries.add(entry);
    }

    public final void setPrefer(String value) {
        this.isPreferPublic = PreferType.PUBLIC.prefer(value);
    }

    public boolean isPreferPublic() {
        return this.isPreferPublic;
    }

    public String matchSystem(String systemId) {
        this.systemEntrySearched = true;
        String match = null;
        for (BaseEntry entry : this.entries) {
            switch (entry.type) {
                case SYSTEM: {
                    match = ((SystemEntry)entry).match(systemId);
                    if (match == null) break;
                    this.isInstantMatch = true;
                    return match;
                }
                case REWRITESYSTEM: {
                    match = ((RewriteSystem)entry).match(systemId, this.longestRewriteMatch);
                    if (match == null) break;
                    this.rewriteMatch = match;
                    this.longestRewriteMatch = ((RewriteSystem)entry).getSystemIdStartString().length();
                    break;
                }
                case SYSTEMSUFFIX: {
                    match = ((SystemSuffix)entry).match(systemId, this.longestSuffixMatch);
                    if (match == null) break;
                    this.suffixMatch = match;
                    this.longestSuffixMatch = ((SystemSuffix)entry).getSystemIdSuffix().length();
                    break;
                }
                case GROUP: {
                    GroupEntry grpEntry = (GroupEntry)entry;
                    match = grpEntry.matchSystem(systemId);
                    if (grpEntry.isInstantMatch) {
                        return match;
                    }
                    if (grpEntry.longestRewriteMatch > this.longestRewriteMatch) {
                        this.longestRewriteMatch = grpEntry.longestRewriteMatch;
                        this.rewriteMatch = match;
                        break;
                    }
                    if (grpEntry.longestSuffixMatch <= this.longestSuffixMatch) break;
                    this.longestSuffixMatch = grpEntry.longestSuffixMatch;
                    this.suffixMatch = match;
                }
            }
        }
        if (this.longestRewriteMatch > 0) {
            return this.rewriteMatch;
        }
        if (this.longestSuffixMatch > 0) {
            return this.suffixMatch;
        }
        return this.matchDelegate(BaseEntry.CatalogEntryType.DELEGATESYSTEM, systemId);
    }

    public String matchPublic(String publicId) {
        if (!this.isPreferPublic && this.systemEntrySearched) {
            return null;
        }
        String match = null;
        for (BaseEntry entry : this.entries) {
            switch (entry.type) {
                case PUBLIC: {
                    match = ((PublicEntry)entry).match(publicId);
                    break;
                }
                case URI: {
                    match = ((UriEntry)entry).match(publicId);
                    break;
                }
                case GROUP: {
                    match = ((GroupEntry)entry).matchPublic(publicId);
                }
            }
            if (match == null) continue;
            return match;
        }
        return this.matchDelegate(BaseEntry.CatalogEntryType.DELEGATEPUBLIC, publicId);
    }

    public String matchURI(String uri) {
        String match = null;
        for (BaseEntry entry : this.entries) {
            switch (entry.type) {
                case URI: {
                    match = ((UriEntry)entry).match(uri);
                    if (match == null) break;
                    this.isInstantMatch = true;
                    return match;
                }
                case REWRITEURI: {
                    match = ((RewriteUri)entry).match(uri, this.longestRewriteMatch);
                    if (match == null) break;
                    this.rewriteMatch = match;
                    this.longestRewriteMatch = ((RewriteUri)entry).getURIStartString().length();
                    break;
                }
                case URISUFFIX: {
                    match = ((UriSuffix)entry).match(uri, this.longestSuffixMatch);
                    if (match == null) break;
                    this.suffixMatch = match;
                    this.longestSuffixMatch = ((UriSuffix)entry).getURISuffix().length();
                    break;
                }
                case GROUP: {
                    GroupEntry grpEntry = (GroupEntry)entry;
                    match = grpEntry.matchURI(uri);
                    if (grpEntry.isInstantMatch) {
                        return match;
                    }
                    if (grpEntry.longestRewriteMatch > this.longestRewriteMatch) {
                        this.rewriteMatch = match;
                        this.longestRewriteMatch = grpEntry.longestRewriteMatch;
                        break;
                    }
                    if (grpEntry.longestSuffixMatch <= this.longestSuffixMatch) break;
                    this.suffixMatch = match;
                    this.longestSuffixMatch = grpEntry.longestSuffixMatch;
                }
            }
        }
        if (this.longestRewriteMatch > 0) {
            return this.rewriteMatch;
        }
        if (this.longestSuffixMatch > 0) {
            return this.suffixMatch;
        }
        return this.matchDelegate(BaseEntry.CatalogEntryType.DELEGATEURI, uri);
    }

    private String matchDelegate(BaseEntry.CatalogEntryType type, String id) {
        Catalog delegateCatalog;
        String match = null;
        int longestMatch = 0;
        URI catalogId = null;
        for (BaseEntry entry : this.entries) {
            URI temp;
            if (entry.type != type || (temp = type == BaseEntry.CatalogEntryType.DELEGATESYSTEM ? ((DelegateSystem)entry).matchURI(id, longestMatch) : (type == BaseEntry.CatalogEntryType.DELEGATEPUBLIC ? ((DelegatePublic)entry).matchURI(id, longestMatch) : ((DelegateUri)entry).matchURI(id, longestMatch))) == null) continue;
            longestMatch = entry.getMatchId().length();
            catalogId = temp;
        }
        if (catalogId != null && (delegateCatalog = this.loadDelegateCatalog(this.catalog, catalogId)) != null) {
            match = type == BaseEntry.CatalogEntryType.DELEGATESYSTEM ? delegateCatalog.matchSystem(id) : (type == BaseEntry.CatalogEntryType.DELEGATEPUBLIC ? delegateCatalog.matchPublic(id) : delegateCatalog.matchURI(id));
        }
        return match;
    }

    void loadDelegateCatalogs(CatalogImpl parent) {
        this.entries.stream().filter(entry -> entry.type == BaseEntry.CatalogEntryType.DELEGATESYSTEM || entry.type == BaseEntry.CatalogEntryType.DELEGATEPUBLIC || entry.type == BaseEntry.CatalogEntryType.DELEGATEURI).map(entry -> (AltCatalog)entry).forEach(altCatalog -> this.loadDelegateCatalog(parent, altCatalog.getCatalogURI()));
    }

    Catalog loadDelegateCatalog(CatalogImpl parent, URI catalogURI) {
        CatalogImpl delegateCatalog = null;
        if (catalogURI != null) {
            String catalogId = catalogURI.toASCIIString();
            if (this.verifyCatalogFile(parent, catalogURI) && (delegateCatalog = this.getLoadedCatalog(catalogId)) == null) {
                delegateCatalog = new CatalogImpl(parent, this.features, catalogURI);
                delegateCatalog.load();
                this.delegateCatalogs.put(catalogId, delegateCatalog);
            }
        }
        return delegateCatalog;
    }

    CatalogImpl getLoadedCatalog(String catalogId) {
        CatalogImpl c = null;
        c = this.delegateCatalogs.get(catalogId);
        if (c == null) {
            c = this.loadedCatalogs.get(catalogId);
        }
        return c;
    }

    final boolean verifyCatalogFile(CatalogImpl parent, URI catalogURI) {
        if (catalogURI == null) {
            return false;
        }
        if (Util.isFileUri(catalogURI) && !Util.isFileUriExist(catalogURI, false)) {
            return false;
        }
        String catalogId = catalogURI.toASCIIString();
        if (this.catalogsSearched.contains(catalogId) || this.isCircular(parent, catalogId)) {
            CatalogMessages.reportRunTimeError("CircularReference", new Object[]{CatalogMessages.sanitize(catalogId)});
        }
        return true;
    }

    boolean isCircular(CatalogImpl parent, String systemId) {
        if (parent == null) {
            return false;
        }
        if (parent.systemId.equals(systemId)) {
            return true;
        }
        return parent.isCircular(parent.parent, systemId);
    }

    public static enum PreferType {
        PUBLIC("public"),
        SYSTEM("system");

        final String literal;

        private PreferType(String literal) {
            this.literal = literal;
        }

        public boolean prefer(String prefer) {
            return this.literal.equals(prefer);
        }
    }

    public static enum ResolveType {
        STRICT("strict"),
        CONTINUE("continue"),
        IGNORE("ignore");

        final String literal;

        private ResolveType(String literal) {
            this.literal = literal;
        }

        public static ResolveType getType(String resolveType) {
            for (ResolveType type : ResolveType.values()) {
                if (!type.isType(resolveType)) continue;
                return type;
            }
            return null;
        }

        public boolean isType(String type) {
            return this.literal.equals(type);
        }
    }
}

