/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URI;
import javax.xml.catalog.AltCatalog;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.Normalizer;

final class DelegateUri
extends AltCatalog {
    String uriStartString;

    public DelegateUri(String base, String uriStartString, String catalog) {
        super(BaseEntry.CatalogEntryType.DELEGATEURI, base);
        this.setURIStartString(uriStartString);
        this.setCatalog(catalog);
    }

    public void setURIStartString(String uriStartString) {
        CatalogMessages.reportNPEOnNull("uriStartString", uriStartString);
        this.uriStartString = Normalizer.normalizeURI(uriStartString);
        this.setMatchId(this.uriStartString);
    }

    public String getURIStartString() {
        return this.uriStartString;
    }

    @Override
    public String match(String systemId) {
        return this.match(systemId, 0);
    }

    @Override
    public URI matchURI(String systemId, int currentMatch) {
        if (this.uriStartString.length() <= systemId.length() && this.uriStartString.equals(systemId.substring(0, this.uriStartString.length())) && currentMatch < this.uriStartString.length()) {
            return this.catalogURI;
        }
        return null;
    }
}

