/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URI;
import javax.xml.catalog.AltCatalog;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.Normalizer;

final class DelegatePublic
extends AltCatalog {
    String publicIdStartString;

    public DelegatePublic(String base, String startString, String catalog) {
        super(BaseEntry.CatalogEntryType.DELEGATEPUBLIC, base);
        this.setPublicIdStartString(startString);
        this.setCatalog(catalog);
    }

    public void setPublicIdStartString(String startString) {
        CatalogMessages.reportNPEOnNull("publicIdStartString", startString);
        this.publicIdStartString = Normalizer.normalizePublicId(startString);
        this.setMatchId(this.publicIdStartString);
    }

    public String getPublicIdStartString() {
        return this.publicIdStartString;
    }

    @Override
    public String match(String publicId) {
        return this.match(publicId, 0);
    }

    @Override
    public URI matchURI(String publicId, int currentMatch) {
        if (this.publicIdStartString.length() <= publicId.length() && this.publicIdStartString.equals(publicId.substring(0, this.publicIdStartString.length())) && currentMatch < this.publicIdStartString.length()) {
            return this.catalogURI;
        }
        return null;
    }
}

