/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.catalog.Catalog;
import javax.xml.catalog.CatalogImpl;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.CatalogResolver;
import javax.xml.catalog.GroupEntry;
import javax.xml.catalog.Normalizer;
import javax.xml.catalog.Util;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class CatalogResolverImpl
implements CatalogResolver {
    Catalog catalog;
    CatalogResolverImpl entityResolver;

    public CatalogResolverImpl(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        CatalogImpl c;
        String resolvedSystemId;
        CatalogMessages.reportNPEOnNull("systemId", systemId);
        systemId = Normalizer.normalizeURI(Util.getNotNullOrEmpty(systemId));
        publicId = Normalizer.normalizePublicId(Normalizer.decodeURN(Util.getNotNullOrEmpty(publicId)));
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = Normalizer.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        if ((resolvedSystemId = Util.resolve(c = (CatalogImpl)this.catalog, publicId, systemId)) != null) {
            return new InputSource(resolvedSystemId);
        }
        GroupEntry.ResolveType resolveType = ((CatalogImpl)this.catalog).getResolve();
        switch (resolveType) {
            case IGNORE: {
                return new InputSource(new StringReader(""));
            }
            case STRICT: {
                CatalogMessages.reportError("NoMatchFound", new Object[]{publicId, systemId});
            }
        }
        return null;
    }

    @Override
    public Source resolve(String href, String base) {
        String publicId;
        CatalogMessages.reportNPEOnNull("href", href);
        href = Util.getNotNullOrEmpty(href);
        base = Util.getNotNullOrEmpty(base);
        String result = null;
        CatalogImpl c = (CatalogImpl)this.catalog;
        String uri = Normalizer.normalizeURI(href);
        if (uri == null) {
            return null;
        }
        if (uri != null && uri.startsWith("urn:publicid:") && (publicId = Normalizer.decodeURN(uri)) != null) {
            result = Util.resolve(c, publicId, null);
        }
        if (result == null) {
            int hashPos = uri.indexOf("#");
            if (hashPos >= 0) {
                uri = uri.substring(0, hashPos);
            }
            result = Util.resolve(c, null, uri);
        }
        if (result == null) {
            GroupEntry.ResolveType resolveType = c.getResolve();
            switch (resolveType) {
                case IGNORE: {
                    return new SAXSource(new InputSource(new StringReader("")));
                }
                case STRICT: {
                    CatalogMessages.reportError("NoMatchURIFound", new Object[]{href, base});
                }
            }
            try {
                URL url = null;
                if (base == null) {
                    url = new URL(uri);
                    result = url.toString();
                } else {
                    URL baseURL = new URL(base);
                    url = href.length() == 0 ? baseURL : new URL(baseURL, uri);
                    result = url.toString();
                }
            }
            catch (MalformedURLException mue) {
                CatalogMessages.reportError("FailedCreatingURI", new Object[]{href, base});
            }
        }
        SAXSource source = new SAXSource();
        source.setInputSource(new InputSource(result));
        this.setEntityResolver(source);
        return source;
    }

    private void setEntityResolver(SAXSource source) {
        XMLReader reader = source.getXMLReader();
        if (reader == null) {
            SAXParserFactoryImpl spFactory = new SAXParserFactoryImpl();
            ((SAXParserFactory)spFactory).setNamespaceAware(true);
            try {
                reader = ((SAXParserFactory)spFactory).newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException | SAXException ex) {
                CatalogMessages.reportRunTimeError("ParserConf", ex);
            }
        }
        if (this.entityResolver != null) {
            this.entityResolver = new CatalogResolverImpl(this.catalog);
        }
        reader.setEntityResolver(this.entityResolver);
        source.setXMLReader(reader);
    }

    @Override
    public InputStream resolveEntity(String publicId, String systemId, String baseUri, String namespace) {
        InputSource is = this.resolveEntity(publicId, systemId);
        if (is != null && !is.isEmpty()) {
            try {
                return new URL(is.getSystemId()).openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        GroupEntry.ResolveType resolveType = ((CatalogImpl)this.catalog).getResolve();
        switch (resolveType) {
            case IGNORE: {
                return null;
            }
            case STRICT: {
                CatalogMessages.reportError("NoMatchFound", new Object[]{publicId, systemId});
            }
        }
        return null;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputSource is = this.resolveEntity(publicId, systemId);
        if (is != null && !is.isEmpty()) {
            return new LSInputImpl(is.getSystemId());
        }
        GroupEntry.ResolveType resolveType = ((CatalogImpl)this.catalog).getResolve();
        switch (resolveType) {
            case IGNORE: {
                return null;
            }
            case STRICT: {
                CatalogMessages.reportError("NoMatchFound", new Object[]{publicId, systemId});
            }
        }
        return null;
    }

    class LSInputImpl
    implements LSInput {
        private String systemId;

        public LSInputImpl(String systemId) {
            this.systemId = systemId;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }
}

