/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.io.StringReader;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.Catalog;
import javax.xml.catalog.CatalogEntry;
import javax.xml.catalog.CatalogImpl;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.DelegatePublic;
import javax.xml.catalog.DelegateSystem;
import javax.xml.catalog.DelegateUri;
import javax.xml.catalog.GroupEntry;
import javax.xml.catalog.NextCatalog;
import javax.xml.catalog.Normalizer;
import javax.xml.catalog.PublicEntry;
import javax.xml.catalog.RewriteSystem;
import javax.xml.catalog.RewriteUri;
import javax.xml.catalog.SystemEntry;
import javax.xml.catalog.SystemSuffix;
import javax.xml.catalog.UriEntry;
import javax.xml.catalog.UriSuffix;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CatalogReader
extends DefaultHandler
implements EntityResolver,
URIResolver {
    public static final String xmlCatalogXSD = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.xsd";
    public static final String xmlCatalogPubId = "-//OASIS//DTD XML Catalogs V1.0//EN";
    public static final String NAMESPACE_OASIS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    boolean seenRoot;
    boolean inGroup;
    CatalogImpl catalog;
    SAXParser parser;
    CatalogEntry catalogEntry;
    GroupEntry group;
    BaseEntry entry;
    boolean ignoreTheCatalog = false;

    public CatalogReader(Catalog catalog, SAXParser parser) {
        this.catalog = (CatalogImpl)catalog;
        this.parser = parser;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String base;
        if (this.ignoreTheCatalog) {
            return;
        }
        if (!NAMESPACE_OASIS.equals(namespaceURI)) {
            this.ignoreTheCatalog = true;
            return;
        }
        BaseEntry.CatalogEntryType type = BaseEntry.CatalogEntryType.getType(localName);
        if (type == null) {
            CatalogMessages.reportError("InvalidEntryType", new Object[]{localName});
        }
        if (type != BaseEntry.CatalogEntryType.CATALOGENTRY && !this.seenRoot) {
            CatalogMessages.reportError("InvalidCatalog");
        }
        base = (base = atts.getValue("xml:base")) == null ? (this.inGroup ? this.group.getBaseURI().toString() : (type == BaseEntry.CatalogEntryType.CATALOGENTRY ? this.catalog.getBaseURI().toString() : this.catalogEntry.getBaseURI().toString())) : Normalizer.normalizeURI(base);
        if (type == BaseEntry.CatalogEntryType.CATALOGENTRY || type == BaseEntry.CatalogEntryType.GROUP) {
            String prefer = atts.getValue("prefer");
            if (prefer == null) {
                if (type == BaseEntry.CatalogEntryType.CATALOGENTRY) {
                    prefer = this.catalog.isPreferPublic() ? "public" : "system";
                } else {
                    String string = prefer = this.catalogEntry.isPreferPublic() ? "public" : "system";
                }
            }
            if (type == BaseEntry.CatalogEntryType.CATALOGENTRY) {
                this.seenRoot = true;
                if (this.catalog.isTop()) {
                    String defer = atts.getValue("defer");
                    String resolve = atts.getValue("resolve");
                    if (defer == null) {
                        String string = defer = this.catalog.isDeferred() ? "true" : "false";
                    }
                    if (resolve == null) {
                        resolve = this.catalog.getResolve().literal;
                    }
                    this.catalog.setResolve(resolve);
                    this.catalog.setDeferred(defer);
                    this.catalogEntry = new CatalogEntry(base, prefer, defer, resolve);
                } else {
                    this.catalogEntry = new CatalogEntry(base, prefer);
                }
                this.catalog.setPrefer(prefer);
                return;
            }
            this.inGroup = true;
            this.group = new GroupEntry(this.catalog, base, prefer);
            this.catalog.addEntry(this.group);
            return;
        }
        switch (type) {
            case PUBLIC: {
                this.entry = new PublicEntry(base, atts.getValue("publicId"), atts.getValue("uri"));
                break;
            }
            case SYSTEM: {
                this.entry = new SystemEntry(base, atts.getValue("systemId"), atts.getValue("uri"));
                break;
            }
            case REWRITESYSTEM: {
                this.entry = new RewriteSystem(base, atts.getValue("systemIdStartString"), atts.getValue("rewritePrefix"));
                break;
            }
            case SYSTEMSUFFIX: {
                this.entry = new SystemSuffix(base, atts.getValue("systemIdSuffix"), atts.getValue("uri"));
                break;
            }
            case DELEGATEPUBLIC: {
                this.entry = new DelegatePublic(base, atts.getValue("publicIdStartString"), atts.getValue("catalog"));
                break;
            }
            case DELEGATESYSTEM: {
                this.entry = new DelegateSystem(base, atts.getValue("systemIdStartString"), atts.getValue("catalog"));
                break;
            }
            case URI: {
                this.entry = new UriEntry(base, atts.getValue("name"), atts.getValue("uri"));
                break;
            }
            case REWRITEURI: {
                this.entry = new RewriteUri(base, atts.getValue("uriStartString"), atts.getValue("rewritePrefix"));
                break;
            }
            case URISUFFIX: {
                this.entry = new UriSuffix(base, atts.getValue("uriSuffix"), atts.getValue("uri"));
                break;
            }
            case DELEGATEURI: {
                this.entry = new DelegateUri(base, atts.getValue("uriStartString"), atts.getValue("catalog"));
                break;
            }
            case NEXTCATALOG: {
                this.entry = new NextCatalog(base, atts.getValue("catalog"));
            }
        }
        if (type == BaseEntry.CatalogEntryType.NEXTCATALOG) {
            this.catalog.addNextCatalog((NextCatalog)this.entry);
        } else if (this.inGroup) {
            this.group.addEntry(this.entry);
        } else {
            this.catalog.addEntry(this.entry);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.ignoreTheCatalog) {
            return;
        }
        BaseEntry.CatalogEntryType type = BaseEntry.CatalogEntryType.getType(localName);
        if (type == BaseEntry.CatalogEntryType.GROUP) {
            this.inGroup = false;
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return new InputSource(new StringReader(""));
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        return new SAXSource(new InputSource(new StringReader("")));
    }
}

