/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.catalog.CatalogException;
import jdk.xml.internal.SecuritySupport;

final class CatalogMessages {
    public static final String ERR_INVALID_CATALOG = "InvalidCatalog";
    public static final String ERR_INVALID_ENTRY_TYPE = "InvalidEntryType";
    public static final String ERR_URI_NOTABSOLUTE = "UriNotAbsolute";
    public static final String ERR_URI_NOTVALIDURL = "UriNotValidUrl";
    public static final String ERR_INVALID_ARGUMENT = "InvalidArgument";
    public static final String ERR_NULL_ARGUMENT = "NullArgument";
    public static final String ERR_CIRCULAR_REFERENCE = "CircularReference";
    public static final String ERR_INVALID_PATH = "InvalidPath";
    public static final String ERR_PARSER_CONF = "ParserConf";
    public static final String ERR_PARSING_FAILED = "ParsingFailed";
    public static final String ERR_NO_CATALOG = "NoCatalogFound";
    public static final String ERR_NO_MATCH = "NoMatchFound";
    public static final String ERR_NO_URI_MATCH = "NoMatchURIFound";
    public static final String ERR_CREATING_URI = "FailedCreatingURI";
    public static final String ERR_OTHER = "OtherError";
    static final String bundleName = CatalogMessages.class.getPackageName() + ".CatalogMessages";
    static ResourceBundle resourceBundle;

    CatalogMessages() {
    }

    static void reportError(String key) {
        CatalogMessages.reportError(key, null);
    }

    static void reportError(String key, Object[] arguments) {
        throw new CatalogException(CatalogMessages.formatMessage(key, arguments));
    }

    static void reportRunTimeError(String key, Object[] arguments) {
        throw new CatalogException(CatalogMessages.formatMessage(key, arguments));
    }

    static void reportRunTimeError(String key, Throwable cause) {
        throw new CatalogException(CatalogMessages.formatMessage(key, null), cause);
    }

    static void reportRunTimeError(String key, Object[] arguments, Throwable cause) {
        throw new CatalogException(CatalogMessages.formatMessage(key, arguments), cause);
    }

    static void reportIAEOnNull(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException(CatalogMessages.formatMessage(ERR_INVALID_ARGUMENT, new Object[]{null, name}));
        }
    }

    static void reportNPEOnNull(String name, Object value) {
        if (value == null) {
            throw new NullPointerException(CatalogMessages.formatMessage(ERR_NULL_ARGUMENT, new Object[]{name}));
        }
    }

    static void reportIAE(String key, Object[] arguments, Throwable cause) {
        throw new IllegalArgumentException(CatalogMessages.formatMessage(key, arguments), cause);
    }

    static String formatMessage(String key, Object[] arguments) {
        return CatalogMessages.formatMessage(key, arguments, Locale.getDefault());
    }

    static String formatMessage(String key, Object[] arguments, Locale locale) {
        return SecuritySupport.getErrorMessage(locale, bundleName, key, arguments);
    }

    static String sanitize(String uri) {
        if (uri == null) {
            return null;
        }
        int p = uri.lastIndexOf("/");
        if (p > 0 && p < uri.length()) {
            return uri.substring(p + 1);
        }
        return uri;
    }
}

