/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URI;
import javax.xml.catalog.Catalog;
import javax.xml.catalog.CatalogFeatures;
import javax.xml.catalog.CatalogImpl;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.CatalogResolver;
import javax.xml.catalog.CatalogResolverImpl;
import javax.xml.catalog.Util;

public final class CatalogManager {
    private CatalogManager() {
    }

    public static Catalog catalog(CatalogFeatures features, URI ... uris) {
        Util.validateUrisSyntax(uris);
        CatalogImpl catalog = new CatalogImpl(features, uris);
        catalog.load();
        return catalog;
    }

    public static CatalogResolver catalogResolver(Catalog catalog) {
        if (catalog == null) {
            CatalogMessages.reportNPEOnNull("catalog", null);
        }
        return new CatalogResolverImpl(catalog);
    }

    public static CatalogResolver catalogResolver(CatalogFeatures features, URI ... uris) {
        Catalog catalog = CatalogManager.catalog(features, uris);
        return new CatalogResolverImpl(catalog);
    }
}

