/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.Catalog;
import javax.xml.catalog.CatalogException;
import javax.xml.catalog.CatalogFeatures;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.CatalogReader;
import javax.xml.catalog.GroupEntry;
import javax.xml.catalog.NextCatalog;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CatalogImpl
extends GroupEntry
implements Catalog {
    int level = 0;
    boolean isDeferred = true;
    GroupEntry.ResolveType resolveType = GroupEntry.ResolveType.STRICT;
    boolean isEmpty;
    int current = 0;
    String systemId;
    List<String> inputFiles;
    List<NextCatalog> nextCatalogs;
    SAXParser parser;

    public CatalogImpl(CatalogFeatures f, URI ... uris) throws CatalogException {
        this(null, f, uris);
    }

    public CatalogImpl(CatalogImpl parent, CatalogFeatures f, URI ... uris) throws CatalogException {
        super(BaseEntry.CatalogEntryType.CATALOG, parent);
        if (f == null) {
            throw new NullPointerException(CatalogMessages.formatMessage("NullArgument", new Object[]{"CatalogFeatures"}));
        }
        this.init(f);
        String[] catalogFile = null;
        if (this.level == 0 && uris.length == 0) {
            String files = this.features.get(CatalogFeatures.Feature.FILES);
            if (files != null) {
                catalogFile = files.split(";");
            }
        } else {
            catalogFile = new String[uris.length];
            for (int i = 0; i < uris.length; ++i) {
                catalogFile[i] = uris[i].toASCIIString();
            }
        }
        if (catalogFile != null && catalogFile.length > 0) {
            int start = 0;
            URI uri = null;
            for (String temp : catalogFile) {
                uri = URI.create(temp);
                ++start;
                if (!this.verifyCatalogFile(null, uri)) continue;
                this.systemId = temp;
                try {
                    this.baseURI = new URL(this.systemId);
                }
                catch (MalformedURLException e) {
                    CatalogMessages.reportRunTimeError("InvalidPath", new Object[]{temp}, e);
                }
                break;
            }
            if (this.level == 0 && catalogFile.length > start) {
                this.inputFiles = new ArrayList<String>();
                for (int i = start; i < catalogFile.length; ++i) {
                    if (catalogFile[i] == null) continue;
                    this.inputFiles.add(catalogFile[i]);
                }
            }
        }
    }

    void load() {
        if (this.systemId != null) {
            this.parse(this.systemId);
        }
        this.setCatalog(this);
        this.loadedCatalogs.put(this.systemId, this);
        if (!this.isDeferred()) {
            this.loadDelegateCatalogs(this);
            this.loadNextCatalogs();
        }
    }

    private void init(CatalogFeatures f) {
        if (this.parent == null) {
            this.level = 0;
        } else {
            this.level = this.parent.level + 1;
            this.loadedCatalogs = this.parent.loadedCatalogs;
            this.catalogsSearched = this.parent.catalogsSearched;
        }
        this.features = f == null ? CatalogFeatures.defaults() : f;
        this.setPrefer(this.features.get(CatalogFeatures.Feature.PREFER));
        this.setDeferred(this.features.get(CatalogFeatures.Feature.DEFER));
        this.setResolve(this.features.get(CatalogFeatures.Feature.RESOLVE));
    }

    @Override
    public void reset() {
        super.reset();
        this.current = 0;
        if (this.level == 0) {
            this.catalogsSearched.clear();
        }
        this.entries.stream().filter(entry -> entry.type == BaseEntry.CatalogEntryType.GROUP).forEach(entry -> ((GroupEntry)entry).reset());
    }

    boolean isTop() {
        return this.level == 0;
    }

    public Catalog getParent() {
        return this.parent;
    }

    public boolean isDeferred() {
        return this.isDeferred;
    }

    public final void setDeferred(String value) {
        this.isDeferred = "true".equals(value);
    }

    public final GroupEntry.ResolveType getResolve() {
        return this.resolveType;
    }

    public final void setResolve(String value) {
        this.resolveType = GroupEntry.ResolveType.getType(value);
    }

    void markAsSearched() {
        this.catalogsSearched.add(this.systemId);
    }

    private void parse(String systemId) {
        if (this.parser == null) {
            this.parser = this.getParser();
        }
        try {
            CatalogReader reader = new CatalogReader(this, this.parser);
            this.parser.parse(systemId, (DefaultHandler)reader);
        }
        catch (IOException | SAXException ex) {
            CatalogMessages.reportRunTimeError("ParsingFailed", ex);
        }
    }

    private SAXParser getParser() {
        SAXParser p = null;
        try {
            SAXParserFactoryImpl spf = new SAXParserFactoryImpl();
            ((SAXParserFactory)spf).setNamespaceAware(true);
            ((SAXParserFactory)spf).setValidating(false);
            ((SAXParserFactory)spf).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            p = ((SAXParserFactory)spf).newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            CatalogMessages.reportRunTimeError("ParsingFailed", e);
        }
        return p;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public Stream<Catalog> catalogs() {
        Iterator<Catalog> iter = new Iterator<Catalog>(){
            Catalog nextCatalog = null;
            int inputFilesIndex = 0;
            int nextCatalogIndex = 0;

            @Override
            public boolean hasNext() {
                if (this.nextCatalog != null) {
                    return true;
                }
                this.nextCatalog = this.nextCatalog();
                return this.nextCatalog != null;
            }

            @Override
            public Catalog next() {
                if (this.nextCatalog != null || this.hasNext()) {
                    Catalog catalog = this.nextCatalog;
                    this.nextCatalog = null;
                    return catalog;
                }
                throw new NoSuchElementException();
            }

            private Catalog nextCatalog() {
                Catalog c = null;
                if (CatalogImpl.this.nextCatalogs != null) {
                    while (c == null && this.nextCatalogIndex < CatalogImpl.this.nextCatalogs.size()) {
                        c = CatalogImpl.this.getCatalog(CatalogImpl.this.catalog, CatalogImpl.this.nextCatalogs.get(this.nextCatalogIndex++).getCatalogURI());
                    }
                }
                if (c == null && CatalogImpl.this.inputFiles != null) {
                    while (c == null && this.inputFilesIndex < CatalogImpl.this.inputFiles.size()) {
                        c = CatalogImpl.this.getCatalog(null, URI.create(CatalogImpl.this.inputFiles.get(this.inputFilesIndex++)));
                    }
                }
                return c;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 272), false);
    }

    void addNextCatalog(NextCatalog catalog) {
        if (catalog == null) {
            return;
        }
        if (this.nextCatalogs == null) {
            this.nextCatalogs = new ArrayList<NextCatalog>();
        }
        this.nextCatalogs.add(catalog);
    }

    void loadNextCatalogs() {
        if (this.nextCatalogs != null) {
            this.nextCatalogs.stream().forEach(next -> this.getCatalog(this, next.getCatalogURI()));
        }
        if (this.inputFiles != null) {
            this.inputFiles.stream().forEach(uri -> this.getCatalog(null, URI.create(uri)));
        }
    }

    Catalog getCatalog(CatalogImpl parent, URI uri) {
        if (uri == null) {
            return null;
        }
        CatalogImpl c = null;
        if (this.verifyCatalogFile(parent, uri) && (c = this.getLoadedCatalog(uri.toASCIIString())) == null) {
            c = new CatalogImpl(this, this.features, uri);
            c.load();
        }
        return c;
    }

    void saveLoadedCatalog(String catalogId, CatalogImpl c) {
        this.loadedCatalogs.put(catalogId, c);
    }

    int loadedCatalogCount() {
        return this.loadedCatalogs.size();
    }
}

