/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.util.HashMap;
import java.util.Map;
import javax.xml.catalog.Util;
import jdk.xml.internal.SecuritySupport;

public class CatalogFeatures {
    static final String CATALOG_FILES = "javax.xml.catalog.files";
    static final String CATALOG_PREFER = "javax.xml.catalog.prefer";
    static final String CATALOG_DEFER = "javax.xml.catalog.defer";
    static final String CATALOG_RESOLVE = "javax.xml.catalog.resolve";
    static final String PREFER_SYSTEM = "system";
    static final String PREFER_PUBLIC = "public";
    static final String DEFER_TRUE = "true";
    static final String DEFER_FALSE = "false";
    static final String RESOLVE_STRICT = "strict";
    static final String RESOLVE_CONTINUE = "continue";
    static final String RESOLVE_IGNORE = "ignore";
    private String[] values;
    private State[] states;

    private CatalogFeatures() {
    }

    CatalogFeatures(Builder builder) {
        this.init();
        this.setProperties(builder);
    }

    public static CatalogFeatures defaults() {
        return CatalogFeatures.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String get(Feature cf) {
        return this.values[cf.ordinal()];
    }

    private void init() {
        this.values = new String[Feature.values().length];
        this.states = new State[Feature.values().length];
        for (Feature cf : Feature.values()) {
            this.setProperty(cf, State.DEFAULT, cf.defaultValue());
        }
        this.readSystemProperties();
    }

    private void setProperties(Builder builder) {
        builder.values.entrySet().stream().forEach(entry -> this.setProperty((Feature)((Object)((Object)entry.getKey())), State.APIPROPERTY, (String)entry.getValue()));
    }

    private void setProperty(Feature feature, State state, String value) {
        int index = feature.ordinal();
        if (value != null && value.length() != 0) {
            if (state != State.APIPROPERTY) {
                Util.validateFeatureInput(feature, value);
            }
            if (this.states[index] == null || state.compareTo(this.states[index]) >= 0) {
                this.values[index] = value;
                this.states[index] = state;
            }
        }
    }

    private void readSystemProperties() {
        for (Feature cf : Feature.values()) {
            this.getSystemProperty(cf, cf.getPropertyName());
        }
    }

    private boolean getSystemProperty(Feature cf, String sysPropertyName) {
        if (cf.hasSystemProperty()) {
            String value = SecuritySupport.getSystemProperty(sysPropertyName);
            if (value != null && !value.isEmpty()) {
                this.setProperty(cf, State.SYSTEMPROPERTY, value);
                return true;
            }
            value = SecuritySupport.readJAXPProperty(sysPropertyName);
            if (value != null && !value.isEmpty()) {
                this.setProperty(cf, State.JAXPDOTPROPERTIES, value);
                return true;
            }
        }
        return false;
    }

    public static class Builder {
        Map<Feature, String> values = new HashMap<Feature, String>();

        private Builder() {
        }

        public Builder with(Feature feature, String value) {
            Util.validateFeatureInput(feature, value);
            this.values.put(feature, value);
            return this;
        }

        public CatalogFeatures build() {
            return new CatalogFeatures(this);
        }
    }

    public static enum Feature {
        FILES("javax.xml.catalog.files", null, true),
        PREFER("javax.xml.catalog.prefer", "public", false),
        DEFER("javax.xml.catalog.defer", "true", true),
        RESOLVE("javax.xml.catalog.resolve", "strict", true);

        private final String name;
        private final String defaultValue;
        private final boolean hasSystem;
        private String value;

        private Feature(String name, String value, boolean hasSystem) {
            this.name = name;
            this.defaultValue = value;
            this.hasSystem = hasSystem;
        }

        boolean equalsPropertyName(String propertyName) {
            return this.name.equals(propertyName);
        }

        public String getPropertyName() {
            return this.name;
        }

        public String defaultValue() {
            return this.defaultValue;
        }

        String getValue() {
            return this.value;
        }

        boolean hasSystemProperty() {
            return this.hasSystem;
        }
    }

    static enum State {
        DEFAULT("default"),
        JAXPDOTPROPERTIES("jaxp.properties"),
        SYSTEMPROPERTY("system property"),
        APIPROPERTY("property"),
        CATALOGATTRIBUTE("catalog attribute");

        final String literal;

        private State(String literal) {
            this.literal = literal;
        }

        String literal() {
            return this.literal;
        }
    }
}

