/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.Normalizer;

abstract class BaseEntry {
    final String SLASH = "/";
    CatalogEntryType type;
    String id;
    String matchId;
    URL baseURI;
    boolean baseSpecified = false;

    public BaseEntry(CatalogEntryType type) {
        this.type = Objects.requireNonNull(type);
    }

    public BaseEntry(CatalogEntryType type, String base) {
        this.type = Objects.requireNonNull(type);
        this.setBaseURI(base);
    }

    public CatalogEntryType getType() {
        return this.type;
    }

    public void setType(CatalogEntryType type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public URL getBaseURI() {
        return this.baseURI;
    }

    public final void setBaseURI(String base) {
        this.baseURI = this.verifyURI("base", null, base);
    }

    public String getMatchId() {
        return this.matchId;
    }

    public void setMatchId(String matchId) {
        this.matchId = matchId;
    }

    public String match(String match) {
        return null;
    }

    public String match(String id, int currentMatch) {
        return null;
    }

    URL verifyURI(String arg, URL base, String uri) {
        CatalogMessages.reportNPEOnNull(arg, uri);
        URL url = null;
        uri = Normalizer.normalizeURI(uri);
        try {
            url = base != null ? new URL(base, uri) : new URL(uri);
        }
        catch (MalformedURLException e) {
            CatalogMessages.reportIAE("InvalidArgument", new Object[]{uri, arg}, e);
        }
        return url;
    }

    static enum CatalogEntryType {
        CATALOG("catalogfile"),
        CATALOGENTRY("catalog"),
        GROUP("group"),
        PUBLIC("public"),
        SYSTEM("system"),
        REWRITESYSTEM("rewriteSystem"),
        SYSTEMSUFFIX("systemSuffix"),
        DELEGATEPUBLIC("delegatePublic"),
        DELEGATESYSTEM("delegateSystem"),
        URI("uri"),
        REWRITEURI("rewriteURI"),
        URISUFFIX("uriSuffix"),
        DELEGATEURI("delegateURI"),
        NEXTCATALOG("nextCatalog");

        final String literal;

        private CatalogEntryType(String literal) {
            this.literal = literal;
        }

        public static CatalogEntryType getType(String entryType) {
            for (CatalogEntryType type : CatalogEntryType.values()) {
                if (!type.isType(entryType)) continue;
                return type;
            }
            return null;
        }

        public boolean isType(String type) {
            return this.literal.equals(type);
        }
    }
}

