/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.jaxp;

import com.sun.org.apache.xpath.internal.jaxp.XPathNodesImpl;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.util.Objects;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathEvaluationResult;
import javax.xml.xpath.XPathNodes;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

class XPathResultImpl<T>
implements XPathEvaluationResult<T> {
    XObject resultObject;
    int resultType;
    Class<T> type;
    XPathEvaluationResult.XPathResultType mapToType;
    NodeList nodeList = null;
    int currentIndex;
    Node currentNode;
    boolean boolValue = false;
    Node node = null;
    double numValue;
    String strValue;

    public XPathResultImpl(XObject resultObject, Class<T> type) throws TransformerException {
        this.resultObject = resultObject;
        this.resultType = resultObject.getType();
        this.type = type;
        this.getResult(resultObject);
    }

    @Override
    public XPathEvaluationResult.XPathResultType type() {
        return this.mapToType;
    }

    @Override
    public T value() {
        Objects.requireNonNull(this.type);
        try {
            return XPathResultImpl.getValue(this.resultObject, this.type);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void getResult(XObject resultObject) throws TransformerException {
        switch (this.resultType) {
            case 1: {
                this.boolValue = resultObject.bool();
                this.mapToType = XPathEvaluationResult.XPathResultType.BOOLEAN;
                break;
            }
            case 2: {
                this.numValue = resultObject.num();
                this.mapToType = XPathEvaluationResult.XPathResultType.NUMBER;
                break;
            }
            case 3: {
                this.strValue = resultObject.str();
                this.mapToType = XPathEvaluationResult.XPathResultType.STRING;
                break;
            }
            case 4: {
                this.mapToType = XPathEvaluationResult.XPathResultType.NODESET;
                this.nodeList = resultObject.nodelist();
                break;
            }
            case 5: {
                this.mapToType = XPathEvaluationResult.XPathResultType.NODE;
                NodeIterator ni = resultObject.nodeset();
                this.node = ni.nextNode();
            }
        }
    }

    static <T> T getValue(XObject resultObject, Class<T> type) throws TransformerException {
        Objects.requireNonNull(type);
        if (type.isAssignableFrom(XPathEvaluationResult.class)) {
            return type.cast(new XPathResultImpl<T>(resultObject, type));
        }
        int resultType = XPathResultImpl.classToInternalType(type);
        switch (resultType) {
            case 1: {
                return type.cast(resultObject.bool());
            }
            case 2: {
                if (Double.class.isAssignableFrom(type)) {
                    return type.cast(resultObject.num());
                }
                if (Integer.class.isAssignableFrom(type)) {
                    return type.cast((int)resultObject.num());
                }
                if (!Long.class.isAssignableFrom(type)) break;
                return type.cast((long)resultObject.num());
            }
            case 3: {
                return type.cast(resultObject.str());
            }
            case 4: {
                XPathNodesImpl nodeSet = new XPathNodesImpl(resultObject.nodelist(), Node.class);
                return type.cast(nodeSet);
            }
            case 5: {
                NodeIterator ni = resultObject.nodeset();
                try {
                    return type.cast(ni.nextNode());
                }
                catch (RuntimeException e) {
                    throw new TransformerException(e.getMessage(), e.getCause());
                }
            }
        }
        return null;
    }

    static <T> int classToInternalType(Class<T> type) {
        if (type.isAssignableFrom(Boolean.class)) {
            return 1;
        }
        if (Number.class.isAssignableFrom(type)) {
            return 2;
        }
        if (type.isAssignableFrom(String.class)) {
            return 3;
        }
        if (type.isAssignableFrom(XPathNodes.class)) {
            return 4;
        }
        if (type.isAssignableFrom(Node.class)) {
            return 5;
        }
        return -1;
    }
}

