/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.jaxp;

import java.util.Iterator;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathNodes;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathNodesImpl
implements XPathNodes {
    Class<Node> elementType;
    NodeList nodeList = null;

    public XPathNodesImpl(NodeList nodeList, Class<Node> elementType) {
        this.nodeList = nodeList;
        this.elementType = elementType;
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeSetIterator<Node>(this.elementType);
    }

    @Override
    public int size() {
        if (this.nodeList != null) {
            return this.nodeList.getLength();
        }
        return 0;
    }

    @Override
    public Node get(int index) throws XPathException {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
        }
        if (this.nodeList != null) {
            return this.nodeList.item(index);
        }
        return null;
    }

    class NodeSetIterator<E>
    implements Iterator<E> {
        int currentIndex;
        Class<E> elementType;

        NodeSetIterator(Class<E> elementType) {
            this.elementType = elementType;
        }

        @Override
        public boolean hasNext() {
            if (XPathNodesImpl.this.nodeList != null) {
                return this.currentIndex < XPathNodesImpl.this.nodeList.getLength();
            }
            return false;
        }

        @Override
        public E next() {
            if (XPathNodesImpl.this.nodeList != null && XPathNodesImpl.this.nodeList.getLength() > 0) {
                return this.elementType.cast(XPathNodesImpl.this.nodeList.item(this.currentIndex++));
            }
            return null;
        }
    }
}

