/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.jaxp;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.axes.LocPathIterator;
import com.sun.org.apache.xpath.internal.jaxp.JAXPExtensionsProvider;
import com.sun.org.apache.xpath.internal.jaxp.JAXPPrefixResolver;
import com.sun.org.apache.xpath.internal.jaxp.JAXPVariableStack;
import com.sun.org.apache.xpath.internal.jaxp.XPathResultImpl;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathEvaluationResult;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathNodes;
import javax.xml.xpath.XPathVariableResolver;
import jdk.xml.internal.JdkXmlFeatures;
import jdk.xml.internal.JdkXmlUtils;
import jdk.xml.internal.XMLSecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XPathImplUtil {
    XPathFunctionResolver functionResolver;
    XPathVariableResolver variableResolver;
    JAXPPrefixResolver prefixResolver;
    boolean overrideDefaultParser;
    boolean featureSecureProcessing = false;
    JdkXmlFeatures featureManager;
    XMLSecurityManager xmlSecMgr;

    XPathImplUtil() {
    }

    XObject eval(Object contextItem, XPath xpath) throws TransformerException {
        XPathContext xpathSupport;
        if (contextItem == null && xpath.getExpression() instanceof LocPathIterator) {
            throw new TransformerException(XSLMessages.createXPATHMessage("ER_CONTEXT_CAN_NOT_BE_NULL", new Object[0]));
        }
        if (this.functionResolver != null) {
            JAXPExtensionsProvider jep = new JAXPExtensionsProvider(this.functionResolver, this.featureSecureProcessing, this.featureManager);
            xpathSupport = new XPathContext(jep);
        } else {
            xpathSupport = new XPathContext();
        }
        xpathSupport.setVarStack(new JAXPVariableStack(this.variableResolver));
        Node contextNode = (Node)contextItem;
        XObject xobj = contextNode == null ? xpath.execute(xpathSupport, -1, (PrefixResolver)this.prefixResolver) : xpath.execute(xpathSupport, contextNode, (PrefixResolver)this.prefixResolver);
        return xobj;
    }

    Document getDocument(InputSource source) throws XPathExpressionException {
        this.requireNonNull(source, "Source");
        try {
            DocumentBuilderFactory dbf = JdkXmlUtils.getDOMFactory(this.overrideDefaultParser);
            return dbf.newDocumentBuilder().parse(source);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XPathExpressionException(e);
        }
    }

    Object getResultAsType(XObject resultObject, QName returnType) throws TransformerException {
        if (returnType.equals(XPathConstants.STRING)) {
            return resultObject.str();
        }
        if (returnType.equals(XPathConstants.NUMBER)) {
            return resultObject.num();
        }
        if (returnType.equals(XPathConstants.BOOLEAN)) {
            return resultObject.bool();
        }
        if (returnType.equals(XPathConstants.NODESET)) {
            return resultObject.nodelist();
        }
        if (returnType.equals(XPathConstants.NODE)) {
            NodeIterator ni = resultObject.nodeset();
            return ni.nextNode();
        }
        String fmsg = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{returnType.toString()});
        throw new IllegalArgumentException(fmsg);
    }

    <T> T getXPathResult(XObject resultObject, Class<T> type) throws TransformerException {
        int resultType = resultObject.getType();
        switch (resultType) {
            case 1: {
                return type.cast(new XPathResultImpl<Boolean>(resultObject, Boolean.class));
            }
            case 2: {
                return type.cast(new XPathResultImpl<Double>(resultObject, Double.class));
            }
            case 3: {
                return type.cast(new XPathResultImpl<String>(resultObject, String.class));
            }
            case 4: {
                return type.cast(new XPathResultImpl<XPathNodes>(resultObject, XPathNodes.class));
            }
            case 5: {
                return type.cast(new XPathResultImpl<Node>(resultObject, Node.class));
            }
        }
        return null;
    }

    <T> void isSupportedClassType(Class<T> type) {
        this.requireNonNull(type, "The class type");
        if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Double.class) || type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Long.class) || type.isAssignableFrom(String.class) || type.isAssignableFrom(XPathNodes.class) || type.isAssignableFrom(Node.class) || type.isAssignableFrom(XPathEvaluationResult.class)) {
            return;
        }
        String fmsg = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{type.toString()});
        throw new IllegalArgumentException(fmsg);
    }

    void isSupported(QName returnType) {
        this.requireNonNull(returnType, "returnType");
        if (returnType.equals(XPathConstants.STRING) || returnType.equals(XPathConstants.NUMBER) || returnType.equals(XPathConstants.BOOLEAN) || returnType.equals(XPathConstants.NODE) || returnType.equals(XPathConstants.NODESET)) {
            return;
        }
        String fmsg = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{returnType.toString()});
        throw new IllegalArgumentException(fmsg);
    }

    <T> void requireNonNull(T param, String paramName) {
        if (param == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{paramName});
            throw new NullPointerException(fmsg);
        }
    }
}

