/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.jaxp;

import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.jaxp.JAXPPrefixResolver;
import com.sun.org.apache.xpath.internal.jaxp.XPathExpressionImpl;
import com.sun.org.apache.xpath.internal.jaxp.XPathImplUtil;
import com.sun.org.apache.xpath.internal.jaxp.XPathResultImpl;
import com.sun.org.apache.xpath.internal.objects.XObject;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathEvaluationResult;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import jdk.xml.internal.JdkXmlFeatures;
import jdk.xml.internal.XMLSecurityManager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XPathImpl
extends XPathImplUtil
implements javax.xml.xpath.XPath {
    private XPathVariableResolver origVariableResolver;
    private XPathFunctionResolver origFunctionResolver;
    private NamespaceContext namespaceContext = null;

    XPathImpl(XPathVariableResolver vr, XPathFunctionResolver fr) {
        this(vr, fr, false, new JdkXmlFeatures(false), new XMLSecurityManager(true));
    }

    XPathImpl(XPathVariableResolver vr, XPathFunctionResolver fr, boolean featureSecureProcessing, JdkXmlFeatures featureManager, XMLSecurityManager xmlSecMgr) {
        this.origVariableResolver = this.variableResolver = vr;
        this.origFunctionResolver = this.functionResolver = fr;
        this.featureSecureProcessing = featureSecureProcessing;
        this.featureManager = featureManager;
        this.overrideDefaultParser = featureManager.getFeature(JdkXmlFeatures.XmlFeature.JDK_OVERRIDE_PARSER);
        this.xmlSecMgr = xmlSecMgr;
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver resolver) {
        this.requireNonNull(resolver, "XPathVariableResolver");
        this.variableResolver = resolver;
    }

    @Override
    public XPathVariableResolver getXPathVariableResolver() {
        return this.variableResolver;
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver resolver) {
        this.requireNonNull(resolver, "XPathFunctionResolver");
        this.functionResolver = resolver;
    }

    @Override
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.functionResolver;
    }

    @Override
    public void setNamespaceContext(NamespaceContext nsContext) {
        this.requireNonNull(nsContext, "NamespaceContext");
        this.namespaceContext = nsContext;
        this.prefixResolver = new JAXPPrefixResolver(nsContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    private XObject eval(String expression, Object contextItem) throws TransformerException {
        this.requireNonNull(expression, "XPath expression");
        XPath xpath = new XPath(expression, null, this.prefixResolver, 0, null, null, this.xmlSecMgr);
        return this.eval(contextItem, xpath);
    }

    @Override
    public Object evaluate(String expression, Object item, QName returnType) throws XPathExpressionException {
        this.requireNonNull(expression, "XPath expression");
        this.isSupported(returnType);
        try {
            XObject resultObject = this.eval(expression, item);
            return this.getResultAsType(resultObject, returnType);
        }
        catch (NullPointerException npe) {
            throw new XPathExpressionException(npe);
        }
        catch (TransformerException te) {
            Throwable nestedException = te.getException();
            if (nestedException instanceof XPathFunctionException) {
                throw (XPathFunctionException)nestedException;
            }
            throw new XPathExpressionException(te);
        }
    }

    @Override
    public String evaluate(String expression, Object item) throws XPathExpressionException {
        return (String)this.evaluate(expression, item, XPathConstants.STRING);
    }

    @Override
    public XPathExpression compile(String expression) throws XPathExpressionException {
        this.requireNonNull(expression, "XPath expression");
        try {
            XPath xpath = new XPath(expression, null, this.prefixResolver, 0, null, null, this.xmlSecMgr);
            XPathExpressionImpl ximpl = new XPathExpressionImpl(xpath, this.prefixResolver, this.functionResolver, this.variableResolver, this.featureSecureProcessing, this.featureManager);
            return ximpl;
        }
        catch (TransformerException te) {
            throw new XPathExpressionException(te);
        }
    }

    @Override
    public Object evaluate(String expression, InputSource source, QName returnType) throws XPathExpressionException {
        this.isSupported(returnType);
        try {
            Document document = this.getDocument(source);
            XObject resultObject = this.eval(expression, document);
            return this.getResultAsType(resultObject, returnType);
        }
        catch (TransformerException te) {
            Throwable nestedException = te.getException();
            if (nestedException instanceof XPathFunctionException) {
                throw (XPathFunctionException)nestedException;
            }
            throw new XPathExpressionException(te);
        }
    }

    @Override
    public String evaluate(String expression, InputSource source) throws XPathExpressionException {
        return (String)this.evaluate(expression, source, XPathConstants.STRING);
    }

    @Override
    public void reset() {
        this.variableResolver = this.origVariableResolver;
        this.functionResolver = this.origFunctionResolver;
        this.namespaceContext = null;
    }

    @Override
    public <T> T evaluateExpression(String expression, Object item, Class<T> type) throws XPathExpressionException {
        this.isSupportedClassType(type);
        try {
            XObject resultObject = this.eval(expression, item);
            if (type.isAssignableFrom(XPathEvaluationResult.class)) {
                return this.getXPathResult(resultObject, type);
            }
            return XPathResultImpl.getValue(resultObject, type);
        }
        catch (TransformerException te) {
            throw new XPathExpressionException(te);
        }
    }

    @Override
    public XPathEvaluationResult<?> evaluateExpression(String expression, Object item) throws XPathExpressionException {
        return this.evaluateExpression(expression, item, XPathEvaluationResult.class);
    }

    @Override
    public <T> T evaluateExpression(String expression, InputSource source, Class<T> type) throws XPathExpressionException {
        Document document = this.getDocument(source);
        return this.evaluateExpression(expression, document, type);
    }

    @Override
    public XPathEvaluationResult<?> evaluateExpression(String expression, InputSource source) throws XPathExpressionException {
        return this.evaluateExpression(expression, source, XPathEvaluationResult.class);
    }
}

