/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.jaxp;

import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.jaxp.JAXPPrefixResolver;
import com.sun.org.apache.xpath.internal.jaxp.XPathImplUtil;
import com.sun.org.apache.xpath.internal.jaxp.XPathResultImpl;
import com.sun.org.apache.xpath.internal.objects.XObject;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathEvaluationResult;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import jdk.xml.internal.JdkXmlFeatures;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XPathExpressionImpl
extends XPathImplUtil
implements XPathExpression {
    private XPath xpath;

    protected XPathExpressionImpl() {
        this(null, null, null, null, false, new JdkXmlFeatures(false));
    }

    protected XPathExpressionImpl(XPath xpath, JAXPPrefixResolver prefixResolver, XPathFunctionResolver functionResolver, XPathVariableResolver variableResolver) {
        this(xpath, prefixResolver, functionResolver, variableResolver, false, new JdkXmlFeatures(false));
    }

    protected XPathExpressionImpl(XPath xpath, JAXPPrefixResolver prefixResolver, XPathFunctionResolver functionResolver, XPathVariableResolver variableResolver, boolean featureSecureProcessing, JdkXmlFeatures featureManager) {
        this.xpath = xpath;
        this.prefixResolver = prefixResolver;
        this.functionResolver = functionResolver;
        this.variableResolver = variableResolver;
        this.featureSecureProcessing = featureSecureProcessing;
        this.overrideDefaultParser = featureManager.getFeature(JdkXmlFeatures.XmlFeature.JDK_OVERRIDE_PARSER);
        this.featureManager = featureManager;
    }

    public void setXPath(XPath xpath) {
        this.xpath = xpath;
    }

    public Object eval(Object item, QName returnType) throws TransformerException {
        XObject resultObject = this.eval(item, this.xpath);
        return this.getResultAsType(resultObject, returnType);
    }

    @Override
    public Object evaluate(Object item, QName returnType) throws XPathExpressionException {
        this.isSupported(returnType);
        try {
            return this.eval(item, returnType);
        }
        catch (NullPointerException npe) {
            throw new XPathExpressionException(npe);
        }
        catch (TransformerException te) {
            Throwable nestedException = te.getException();
            if (nestedException instanceof XPathFunctionException) {
                throw (XPathFunctionException)nestedException;
            }
            throw new XPathExpressionException(te);
        }
    }

    @Override
    public String evaluate(Object item) throws XPathExpressionException {
        return (String)this.evaluate(item, XPathConstants.STRING);
    }

    @Override
    public Object evaluate(InputSource source, QName returnType) throws XPathExpressionException {
        this.isSupported(returnType);
        try {
            Document document = this.getDocument(source);
            return this.eval((Object)document, returnType);
        }
        catch (TransformerException e) {
            throw new XPathExpressionException(e);
        }
    }

    @Override
    public String evaluate(InputSource source) throws XPathExpressionException {
        return (String)this.evaluate(source, XPathConstants.STRING);
    }

    @Override
    public <T> T evaluateExpression(Object item, Class<T> type) throws XPathExpressionException {
        this.isSupportedClassType(type);
        try {
            XObject resultObject = this.eval(item, this.xpath);
            if (type.isAssignableFrom(XPathEvaluationResult.class)) {
                return this.getXPathResult(resultObject, type);
            }
            return XPathResultImpl.getValue(resultObject, type);
        }
        catch (TransformerException te) {
            throw new XPathExpressionException(te);
        }
    }

    @Override
    public XPathEvaluationResult<?> evaluateExpression(Object item) throws XPathExpressionException {
        return this.evaluateExpression(item, XPathEvaluationResult.class);
    }

    @Override
    public <T> T evaluateExpression(InputSource source, Class<T> type) throws XPathExpressionException {
        Document document = this.getDocument(source);
        return this.evaluateExpression(document, type);
    }

    @Override
    public XPathEvaluationResult<?> evaluateExpression(InputSource source) throws XPathExpressionException {
        return this.evaluateExpression(source, XPathEvaluationResult.class);
    }
}

