/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.compiler;

import com.sun.org.apache.xpath.internal.functions.FuncBoolean;
import com.sun.org.apache.xpath.internal.functions.FuncCeiling;
import com.sun.org.apache.xpath.internal.functions.FuncConcat;
import com.sun.org.apache.xpath.internal.functions.FuncContains;
import com.sun.org.apache.xpath.internal.functions.FuncCount;
import com.sun.org.apache.xpath.internal.functions.FuncCurrent;
import com.sun.org.apache.xpath.internal.functions.FuncDoclocation;
import com.sun.org.apache.xpath.internal.functions.FuncExtElementAvailable;
import com.sun.org.apache.xpath.internal.functions.FuncExtFunctionAvailable;
import com.sun.org.apache.xpath.internal.functions.FuncFalse;
import com.sun.org.apache.xpath.internal.functions.FuncFloor;
import com.sun.org.apache.xpath.internal.functions.FuncGenerateId;
import com.sun.org.apache.xpath.internal.functions.FuncHere;
import com.sun.org.apache.xpath.internal.functions.FuncId;
import com.sun.org.apache.xpath.internal.functions.FuncLang;
import com.sun.org.apache.xpath.internal.functions.FuncLast;
import com.sun.org.apache.xpath.internal.functions.FuncLocalPart;
import com.sun.org.apache.xpath.internal.functions.FuncNamespace;
import com.sun.org.apache.xpath.internal.functions.FuncNormalizeSpace;
import com.sun.org.apache.xpath.internal.functions.FuncNot;
import com.sun.org.apache.xpath.internal.functions.FuncNumber;
import com.sun.org.apache.xpath.internal.functions.FuncPosition;
import com.sun.org.apache.xpath.internal.functions.FuncQname;
import com.sun.org.apache.xpath.internal.functions.FuncRound;
import com.sun.org.apache.xpath.internal.functions.FuncStartsWith;
import com.sun.org.apache.xpath.internal.functions.FuncString;
import com.sun.org.apache.xpath.internal.functions.FuncStringLength;
import com.sun.org.apache.xpath.internal.functions.FuncSubstring;
import com.sun.org.apache.xpath.internal.functions.FuncSubstringAfter;
import com.sun.org.apache.xpath.internal.functions.FuncSubstringBefore;
import com.sun.org.apache.xpath.internal.functions.FuncSum;
import com.sun.org.apache.xpath.internal.functions.FuncSystemProperty;
import com.sun.org.apache.xpath.internal.functions.FuncTranslate;
import com.sun.org.apache.xpath.internal.functions.FuncTrue;
import com.sun.org.apache.xpath.internal.functions.FuncUnparsedEntityURI;
import com.sun.org.apache.xpath.internal.functions.Function;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;

public class FunctionTable {
    public static final int FUNC_CURRENT = 0;
    public static final int FUNC_LAST = 1;
    public static final int FUNC_POSITION = 2;
    public static final int FUNC_COUNT = 3;
    public static final int FUNC_ID = 4;
    public static final int FUNC_KEY = 5;
    public static final int FUNC_LOCAL_PART = 7;
    public static final int FUNC_NAMESPACE = 8;
    public static final int FUNC_QNAME = 9;
    public static final int FUNC_GENERATE_ID = 10;
    public static final int FUNC_NOT = 11;
    public static final int FUNC_TRUE = 12;
    public static final int FUNC_FALSE = 13;
    public static final int FUNC_BOOLEAN = 14;
    public static final int FUNC_NUMBER = 15;
    public static final int FUNC_FLOOR = 16;
    public static final int FUNC_CEILING = 17;
    public static final int FUNC_ROUND = 18;
    public static final int FUNC_SUM = 19;
    public static final int FUNC_STRING = 20;
    public static final int FUNC_STARTS_WITH = 21;
    public static final int FUNC_CONTAINS = 22;
    public static final int FUNC_SUBSTRING_BEFORE = 23;
    public static final int FUNC_SUBSTRING_AFTER = 24;
    public static final int FUNC_NORMALIZE_SPACE = 25;
    public static final int FUNC_TRANSLATE = 26;
    public static final int FUNC_CONCAT = 27;
    public static final int FUNC_SUBSTRING = 29;
    public static final int FUNC_STRING_LENGTH = 30;
    public static final int FUNC_SYSTEM_PROPERTY = 31;
    public static final int FUNC_LANG = 32;
    public static final int FUNC_EXT_FUNCTION_AVAILABLE = 33;
    public static final int FUNC_EXT_ELEM_AVAILABLE = 34;
    public static final int FUNC_UNPARSED_ENTITY_URI = 36;
    public static final int FUNC_HERE = 37;
    public static final int FUNC_DOCLOCATION = 35;
    private static Class<?>[] m_functions;
    private static final Map<String, Integer> m_functionID;
    private Class<?>[] m_functions_customer = new Class[30];
    private Map<String, Integer> m_functionID_customer = new HashMap<String, Integer>();
    private static final int NUM_BUILT_IN_FUNCS = 38;
    private static final int NUM_ALLOWABLE_ADDINS = 30;
    private int m_funcNextFreeIndex = 38;

    String getFunctionName(int funcID) {
        if (funcID < 38) {
            return m_functions[funcID].getName();
        }
        return this.m_functions_customer[funcID - 38].getName();
    }

    Function getFunction(int which) throws TransformerException {
        try {
            if (which < 38) {
                return (Function)m_functions[which].getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Class<?> c = this.m_functions_customer[which - 38];
            return (Function)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new TransformerException(ex.getMessage());
        }
    }

    Integer getFunctionID(String key) {
        Integer id = this.m_functionID_customer.get(key);
        if (null == id) {
            id = m_functionID.get(key);
        }
        return id;
    }

    public int installFunction(String name, Class<?> func) {
        int funcIndex;
        Integer funcIndexObj = this.getFunctionID(name);
        if (func != null && !Function.class.isAssignableFrom(func)) {
            throw new ClassCastException(func.getName() + " cannot be cast to " + Function.class.getName());
        }
        if (null != funcIndexObj) {
            funcIndex = funcIndexObj;
            if (funcIndex < 38) {
                funcIndex = this.m_funcNextFreeIndex++;
                this.m_functionID_customer.put(name, funcIndex);
            }
            this.m_functions_customer[funcIndex - 38] = func;
        } else {
            funcIndex = this.m_funcNextFreeIndex++;
            this.m_functions_customer[funcIndex - 38] = func;
            this.m_functionID_customer.put(name, funcIndex);
        }
        return funcIndex;
    }

    public boolean functionAvailable(String methName) {
        Integer tblEntry = m_functionID.get(methName);
        if (null != tblEntry) {
            return true;
        }
        tblEntry = this.m_functionID_customer.get(methName);
        return null != tblEntry;
    }

    static {
        m_functionID = new HashMap<String, Integer>();
        m_functions = new Class[38];
        FunctionTable.m_functions[0] = FuncCurrent.class;
        FunctionTable.m_functions[1] = FuncLast.class;
        FunctionTable.m_functions[2] = FuncPosition.class;
        FunctionTable.m_functions[3] = FuncCount.class;
        FunctionTable.m_functions[4] = FuncId.class;
        FunctionTable.m_functions[7] = FuncLocalPart.class;
        FunctionTable.m_functions[8] = FuncNamespace.class;
        FunctionTable.m_functions[9] = FuncQname.class;
        FunctionTable.m_functions[10] = FuncGenerateId.class;
        FunctionTable.m_functions[11] = FuncNot.class;
        FunctionTable.m_functions[12] = FuncTrue.class;
        FunctionTable.m_functions[13] = FuncFalse.class;
        FunctionTable.m_functions[14] = FuncBoolean.class;
        FunctionTable.m_functions[32] = FuncLang.class;
        FunctionTable.m_functions[15] = FuncNumber.class;
        FunctionTable.m_functions[16] = FuncFloor.class;
        FunctionTable.m_functions[17] = FuncCeiling.class;
        FunctionTable.m_functions[18] = FuncRound.class;
        FunctionTable.m_functions[19] = FuncSum.class;
        FunctionTable.m_functions[20] = FuncString.class;
        FunctionTable.m_functions[21] = FuncStartsWith.class;
        FunctionTable.m_functions[22] = FuncContains.class;
        FunctionTable.m_functions[23] = FuncSubstringBefore.class;
        FunctionTable.m_functions[24] = FuncSubstringAfter.class;
        FunctionTable.m_functions[25] = FuncNormalizeSpace.class;
        FunctionTable.m_functions[26] = FuncTranslate.class;
        FunctionTable.m_functions[27] = FuncConcat.class;
        FunctionTable.m_functions[31] = FuncSystemProperty.class;
        FunctionTable.m_functions[33] = FuncExtFunctionAvailable.class;
        FunctionTable.m_functions[34] = FuncExtElementAvailable.class;
        FunctionTable.m_functions[29] = FuncSubstring.class;
        FunctionTable.m_functions[30] = FuncStringLength.class;
        FunctionTable.m_functions[35] = FuncDoclocation.class;
        FunctionTable.m_functions[36] = FuncUnparsedEntityURI.class;
        FunctionTable.m_functions[37] = FuncHere.class;
        m_functionID.put("current", 0);
        m_functionID.put("last", 1);
        m_functionID.put("position", 2);
        m_functionID.put("count", 3);
        m_functionID.put("id", 4);
        m_functionID.put("key", 5);
        m_functionID.put("local-name", 7);
        m_functionID.put("namespace-uri", 8);
        m_functionID.put("name", 9);
        m_functionID.put("generate-id", 10);
        m_functionID.put("not", 11);
        m_functionID.put("true", 12);
        m_functionID.put("false", 13);
        m_functionID.put("boolean", 14);
        m_functionID.put("lang", 32);
        m_functionID.put("number", 15);
        m_functionID.put("floor", 16);
        m_functionID.put("ceiling", 17);
        m_functionID.put("round", 18);
        m_functionID.put("sum", 19);
        m_functionID.put("string", 20);
        m_functionID.put("starts-with", 21);
        m_functionID.put("contains", 22);
        m_functionID.put("substring-before", 23);
        m_functionID.put("substring-after", 24);
        m_functionID.put("normalize-space", 25);
        m_functionID.put("translate", 26);
        m_functionID.put("concat", 27);
        m_functionID.put("system-property", 31);
        m_functionID.put("function-available", 33);
        m_functionID.put("element-available", 34);
        m_functionID.put("substring", 29);
        m_functionID.put("string-length", 30);
        m_functionID.put("unparsed-entity-uri", 36);
        m_functionID.put("document-location", 35);
        m_functionID.put("here", 37);
    }
}

