/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class IteratorPool
implements Serializable {
    static final long serialVersionUID = -460927331149566998L;
    private final DTMIterator m_orig;
    private final List<DTMIterator> m_freeStack;

    public IteratorPool(DTMIterator original) {
        this.m_orig = original;
        this.m_freeStack = new ArrayList<DTMIterator>();
    }

    public synchronized DTMIterator getInstanceOrThrow() throws CloneNotSupportedException {
        if (this.m_freeStack.isEmpty()) {
            return (DTMIterator)this.m_orig.clone();
        }
        DTMIterator result = this.m_freeStack.remove(this.m_freeStack.size() - 1);
        return result;
    }

    public synchronized DTMIterator getInstance() {
        if (this.m_freeStack.isEmpty()) {
            try {
                return (DTMIterator)this.m_orig.clone();
            }
            catch (Exception ex) {
                throw new WrappedRuntimeException(ex);
            }
        }
        DTMIterator result = this.m_freeStack.remove(this.m_freeStack.size() - 1);
        return result;
    }

    public synchronized void freeInstance(DTMIterator obj) {
        this.m_freeStack.add(obj);
    }
}

