/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import java.util.HashMap;
import javax.xml.catalog.CatalogFeatures;
import jdk.xml.internal.JdkXmlUtils;
import jdk.xml.internal.SecuritySupport;
import jdk.xml.internal.XMLSecurityManager;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLReaderManager {
    private static final XMLReaderManager m_singletonManager = new XMLReaderManager();
    private static final String property = "org.xml.sax.driver";
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private ThreadLocal<ReaderWrapper> m_readers;
    private HashMap<XMLReader, Boolean> m_inUse;
    private boolean m_overrideDefaultParser;
    private boolean _secureProcessing;
    private String _accessExternalDTD = "all";
    private XMLSecurityManager _xmlSecurityManager;
    private boolean _useCatalog;
    private CatalogFeatures _catalogFeatures;
    private int _cdataChunkSize;

    private XMLReaderManager() {
    }

    public static XMLReaderManager getInstance(boolean overrideDefaultParser) {
        m_singletonManager.setOverrideDefaultParser(overrideDefaultParser);
        return m_singletonManager;
    }

    public synchronized XMLReader getXMLReader() throws SAXException {
        ReaderWrapper rw;
        if (this.m_readers == null) {
            this.m_readers = new ThreadLocal();
        }
        if (this.m_inUse == null) {
            this.m_inUse = new HashMap();
        }
        boolean threadHasReader = (rw = this.m_readers.get()) != null;
        XMLReader reader = threadHasReader ? rw.reader : null;
        String factory = SecuritySupport.getSystemProperty(property);
        if (threadHasReader && this.m_inUse.get(reader) != Boolean.TRUE && rw.overrideDefaultParser == this.m_overrideDefaultParser && (factory == null || reader.getClass().getName().equals(factory))) {
            this.m_inUse.put(reader, Boolean.TRUE);
        } else {
            reader = JdkXmlUtils.getXMLReader(this.m_overrideDefaultParser, this._secureProcessing);
            if (!threadHasReader) {
                this.m_readers.set(new ReaderWrapper(reader, this.m_overrideDefaultParser));
                this.m_inUse.put(reader, Boolean.TRUE);
            }
        }
        JdkXmlUtils.setXMLReaderPropertyIfSupport(reader, "http://javax.xml.XMLConstants/property/accessExternalDTD", this._accessExternalDTD, true);
        JdkXmlUtils.setXMLReaderPropertyIfSupport(reader, "jdk.xml.cdataChunkSize", this._cdataChunkSize, false);
        String lastProperty = "";
        try {
            if (this._xmlSecurityManager != null) {
                for (XMLSecurityManager.Limit limit : XMLSecurityManager.Limit.values()) {
                    if (!limit.isSupported(XMLSecurityManager.Processor.PARSER)) continue;
                    lastProperty = limit.apiProperty();
                    reader.setProperty(lastProperty, this._xmlSecurityManager.getLimitValueAsString(limit));
                }
                if (this._xmlSecurityManager.printEntityCountInfo()) {
                    lastProperty = "jdk.xml.getEntityCountInfo";
                    reader.setProperty(lastProperty, "yes");
                }
            }
        }
        catch (SAXException se) {
            XMLSecurityManager.printWarning(reader.getClass().getName(), lastProperty, se);
        }
        boolean supportCatalog = true;
        try {
            reader.setFeature("http://javax.xml.XMLConstants/feature/useCatalog", this._useCatalog);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            supportCatalog = false;
        }
        if (supportCatalog && this._useCatalog && this._catalogFeatures != null) {
            try {
                for (CatalogFeatures.Feature f : CatalogFeatures.Feature.values()) {
                    reader.setProperty(f.getPropertyName(), this._catalogFeatures.get(f));
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
        return reader;
    }

    public synchronized void releaseXMLReader(XMLReader reader) {
        ReaderWrapper rw = this.m_readers.get();
        if (rw != null && rw.reader == reader && reader != null) {
            reader.setContentHandler(null);
            reader.setDTDHandler(null);
            reader.setEntityResolver(null);
            try {
                reader.setProperty(LEXICAL_HANDLER_PROPERTY, null);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
            this.m_inUse.remove(reader);
        }
    }

    public boolean overrideDefaultParser() {
        return this.m_overrideDefaultParser;
    }

    public void setOverrideDefaultParser(boolean flag) {
        this.m_overrideDefaultParser = flag;
    }

    public void setFeature(String name, boolean value) {
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this._secureProcessing = value;
        } else if ("http://javax.xml.XMLConstants/feature/useCatalog".equals(name)) {
            this._useCatalog = value;
        }
    }

    public Object getProperty(String name) {
        if (name.equals("http://javax.xml.XMLConstants/property/accessExternalDTD")) {
            return this._accessExternalDTD;
        }
        if (name.equals("http://apache.org/xml/properties/security-manager")) {
            return this._xmlSecurityManager;
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        if (name.equals("http://javax.xml.XMLConstants/property/accessExternalDTD")) {
            this._accessExternalDTD = (String)value;
        } else if (name.equals("http://apache.org/xml/properties/security-manager")) {
            this._xmlSecurityManager = (XMLSecurityManager)value;
        } else if ("javax.xml.catalog.catalogFeatures".equals(name)) {
            this._catalogFeatures = (CatalogFeatures)value;
        } else if ("jdk.xml.cdataChunkSize".equals(name)) {
            this._cdataChunkSize = JdkXmlUtils.getValue(value, this._cdataChunkSize);
        }
    }

    class ReaderWrapper {
        XMLReader reader;
        boolean overrideDefaultParser;

        public ReaderWrapper(XMLReader reader, boolean overrideDefaultParser) {
            this.reader = reader;
            this.overrideDefaultParser = overrideDefaultParser;
        }
    }
}

