/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import java.util.concurrent.atomic.AtomicInteger;

public class SafeThread
extends Thread {
    private volatile boolean ran = false;
    private static final AtomicInteger threadNumber = new AtomicInteger(1);

    private static String threadName() {
        return "SafeThread-" + threadNumber.getAndIncrement();
    }

    public SafeThread(Runnable target) {
        this(null, target, SafeThread.threadName());
    }

    public SafeThread(Runnable target, String name) {
        this(null, target, name);
    }

    public SafeThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (Thread.currentThread() != this) {
            throw new IllegalStateException("The run() method in a SafeThread cannot be called from another thread.");
        }
        SafeThread safeThread = this;
        synchronized (safeThread) {
            if (this.ran) {
                throw new IllegalStateException("The run() method in a SafeThread cannot be called more than once.");
            }
            this.ran = true;
        }
        super.run();
    }
}

