/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.Encodings;
import java.util.Properties;
import jdk.xml.internal.SecuritySupport;

public final class OutputPropertiesFactory {
    private static final String S_BUILTIN_EXTENSIONS_URL = "http://xml.apache.org/xalan";
    private static final String S_BUILTIN_OLD_EXTENSIONS_URL = "http://xml.apache.org/xslt";
    public static final String S_BUILTIN_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xalan}";
    public static final String S_KEY_INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    public static final String S_KEY_LINE_SEPARATOR = "{http://xml.apache.org/xalan}line-separator";
    public static final String S_KEY_CONTENT_HANDLER = "{http://xml.apache.org/xalan}content-handler";
    public static final String S_KEY_ENTITIES = "{http://xml.apache.org/xalan}entities";
    public static final String S_USE_URL_ESCAPING = "{http://xml.apache.org/xalan}use-url-escaping";
    public static final String S_OMIT_META_TAG = "{http://xml.apache.org/xalan}omit-meta-tag";
    public static final String S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xslt}";
    public static final int S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL_LEN = "{http://xml.apache.org/xslt}".length();
    private static final String[] PROP_XML = new String[]{"method", "version", "encoding", "indent", "omit-xml-declaration", "standalone", "media-type", "{http://xml.apache.org/xalan}indent-amount", "{http://xml.apache.org/xalan}content-handler", "{http://xml.apache.org/xalan}entities"};
    private static final String[] PROP_XML_VALUE = new String[]{"xml", "1.0", "UTF-8", "no", "no", "no", "text/xml", "0", "com.sun.org.apache.xml.internal.serializer.ToXMLStream", "com/sun/org/apache/xml/internal/serializer/XMLEntities"};
    private static final String[] PROP_HTML = new String[]{"method", "indent", "media-type", "version", "{http://xml.apache.org/xalan}indent-amount", "{http://xml.apache.org/xalan}content-handler", "{http://xml.apache.org/xalan}entities", "{http://xml.apache.org/xalan}use-url-escaping", "{http://xml.apache.org/xalan}omit-meta-tag"};
    private static final String[] PROP_HTML_VALUE = new String[]{"html", "yes", "text/html", "4.0", "4", "com.sun.org.apache.xml.internal.serializer.ToHTMLStream", "com/sun/org/apache/xml/internal/serializer/HTMLEntities", "yes", "no"};
    private static final String[] PROP_TEXT = new String[]{"method", "media-type", "{http://xml.apache.org/xalan}content-handler"};
    private static final String[] PROP_TEXT_VALUE = new String[]{"text", "text/plain", "com.sun.org.apache.xml.internal.serializer.ToTextStream"};
    private static final String[] PROP_UNKNOWN = new String[]{"method", "version", "encoding", "indent", "omit-xml-declaration", "standalone", "media-type", "{http://xml.apache.org/xalan}indent-amount", "{http://xml.apache.org/xalan}content-handler"};
    private static final String[] PROP_UNKNOWN_VALUE = new String[]{"xml", "1.0", "UTF-8", "no", "no", "no", "text/xml", "0", "com.sun.org.apache.xml.internal.serializer.ToUnknownStream"};
    private static Properties m_xml_properties = null;
    private static Properties m_html_properties = null;
    private static Properties m_text_properties = null;
    private static Properties m_unknown_properties = null;

    public static final Properties getDefaultMethodProperties(String method) {
        Properties defaultProperties = null;
        if (null == m_xml_properties) {
            m_xml_properties = OutputPropertiesFactory.initProperties(PROP_XML, PROP_XML_VALUE, null);
        }
        switch (method) {
            case "xml": {
                defaultProperties = m_xml_properties;
                break;
            }
            case "html": {
                if (null == m_html_properties) {
                    m_html_properties = OutputPropertiesFactory.initProperties(PROP_HTML, PROP_HTML_VALUE, m_xml_properties);
                }
                defaultProperties = m_html_properties;
                break;
            }
            case "text": {
                if (null == m_text_properties && null == (m_text_properties = OutputPropertiesFactory.initProperties(PROP_TEXT, PROP_TEXT_VALUE, m_xml_properties)).getProperty("encoding")) {
                    String mimeEncoding = Encodings.getMimeEncoding(null);
                    m_text_properties.put("encoding", mimeEncoding);
                }
                defaultProperties = m_text_properties;
                break;
            }
            case "": {
                if (null == m_unknown_properties) {
                    m_unknown_properties = OutputPropertiesFactory.initProperties(PROP_UNKNOWN, PROP_UNKNOWN_VALUE, m_xml_properties);
                }
                defaultProperties = m_unknown_properties;
                break;
            }
            default: {
                defaultProperties = m_xml_properties;
            }
        }
        return new Properties(defaultProperties);
    }

    private static Properties initProperties(String[] keys, String[] values, Properties defaults) {
        Properties props = new Properties(defaults);
        for (int i = 0; i < keys.length; ++i) {
            String sys = SecuritySupport.getSystemProperty(keys[i]);
            props.put(keys[i], sys == null ? values[i] : sys);
        }
        return props;
    }
}

