/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.util;

import com.sun.org.apache.xerces.internal.xs.XSObject;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class XSObjectListImpl
extends AbstractList<XSObject>
implements XSObjectList {
    public static final XSObjectListImpl EMPTY_LIST = new XSObjectListImpl(new XSObject[0], 0);
    private static final ListIterator<XSObject> EMPTY_ITERATOR = new EmptyIterator();
    private static final int DEFAULT_SIZE = 4;
    private XSObject[] fArray = null;
    private int fLength = 0;

    public XSObjectListImpl() {
        this.fArray = new XSObject[4];
        this.fLength = 0;
    }

    public XSObjectListImpl(XSObject[] array, int length) {
        this.fArray = array;
        this.fLength = length;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public XSObject item(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fArray[index];
    }

    public void clearXSObjectList() {
        for (int i = 0; i < this.fLength; ++i) {
            this.fArray[i] = null;
        }
        this.fArray = null;
        this.fLength = 0;
    }

    public void addXSObject(XSObject object) {
        if (this.fLength == this.fArray.length) {
            XSObject[] temp = new XSObject[this.fLength + 4];
            System.arraycopy(this.fArray, 0, temp, 0, this.fLength);
            this.fArray = temp;
        }
        this.fArray[this.fLength++] = object;
    }

    public void addXSObject(int index, XSObject object) {
        this.fArray[index] = object;
    }

    @Override
    public boolean contains(Object value) {
        return value == null ? this.containsNull() : this.containsObject(value);
    }

    @Override
    public XSObject get(int index) {
        if (index >= 0 && index < this.fLength) {
            return this.fArray[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public Iterator<XSObject> iterator() {
        return this.listIterator0(0);
    }

    @Override
    public ListIterator<XSObject> listIterator() {
        return this.listIterator0(0);
    }

    @Override
    public ListIterator<XSObject> listIterator(int index) {
        if (index >= 0 && index < this.fLength) {
            return this.listIterator0(index);
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    private ListIterator<XSObject> listIterator0(int index) {
        return this.fLength == 0 ? EMPTY_ITERATOR : new XSObjectListIterator(index);
    }

    private boolean containsObject(Object value) {
        for (int i = this.fLength - 1; i >= 0; --i) {
            if (!value.equals(this.fArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean containsNull() {
        for (int i = this.fLength - 1; i >= 0; --i) {
            if (this.fArray[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.fLength];
        this.toArray0(a);
        return a;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this.fLength) {
            Class<?> arrayClass = a.getClass();
            Class<?> componentType = arrayClass.getComponentType();
            a = (Object[])Array.newInstance(componentType, this.fLength);
        }
        this.toArray0(a);
        if (a.length > this.fLength) {
            a[this.fLength] = null;
        }
        return a;
    }

    private void toArray0(Object[] a) {
        if (this.fLength > 0) {
            System.arraycopy(this.fArray, 0, a, 0, this.fLength);
        }
    }

    private final class XSObjectListIterator
    implements ListIterator<XSObject> {
        private int index;

        public XSObjectListIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < XSObjectListImpl.this.fLength;
        }

        @Override
        public XSObject next() {
            if (this.index < XSObjectListImpl.this.fLength) {
                return XSObjectListImpl.this.fArray[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public XSObject previous() {
            if (this.index > 0) {
                return XSObjectListImpl.this.fArray[--this.index];
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(XSObject o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(XSObject o) {
            throw new UnsupportedOperationException();
        }
    }

    static class EmptyIterator
    implements ListIterator<XSObject> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public XSObject next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public XSObject previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(XSObject object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(XSObject object) {
            throw new UnsupportedOperationException();
        }
    }
}

