/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.util;

import com.sun.org.apache.xerces.internal.util.SymbolHash;
import com.sun.org.apache.xerces.internal.xs.XSNamedMap;
import com.sun.org.apache.xerces.internal.xs.XSObject;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;

public class XSNamedMapImpl
extends AbstractMap<QName, XSObject>
implements XSNamedMap {
    public static final XSNamedMapImpl EMPTY_MAP = new XSNamedMapImpl(new XSObject[0], 0);
    final String[] fNamespaces;
    final int fNSNum;
    final SymbolHash[] fMaps;
    XSObject[] fArray = null;
    int fLength = -1;
    private Set<Map.Entry<QName, XSObject>> fEntrySet = null;

    public XSNamedMapImpl(String namespace, SymbolHash map) {
        this.fNamespaces = new String[]{namespace};
        this.fMaps = new SymbolHash[]{map};
        this.fNSNum = 1;
    }

    public XSNamedMapImpl(String[] namespaces, SymbolHash[] maps, int num) {
        this.fNamespaces = namespaces;
        this.fMaps = maps;
        this.fNSNum = num;
    }

    public XSNamedMapImpl(XSObject[] array, int length) {
        if (length == 0) {
            this.fNamespaces = null;
            this.fMaps = null;
            this.fNSNum = 0;
            this.fArray = array;
            this.fLength = 0;
            return;
        }
        this.fNamespaces = new String[]{array[0].getNamespace()};
        this.fMaps = null;
        this.fNSNum = 1;
        this.fArray = array;
        this.fLength = length;
    }

    @Override
    public synchronized int getLength() {
        if (this.fLength == -1) {
            this.fLength = 0;
            for (int i = 0; i < this.fNSNum; ++i) {
                this.fLength += this.fMaps[i].getLength();
            }
        }
        return this.fLength;
    }

    @Override
    public XSObject itemByName(String namespace, String localName) {
        for (int i = 0; i < this.fNSNum; ++i) {
            if (!XSNamedMapImpl.isEqual(namespace, this.fNamespaces[i])) continue;
            if (this.fMaps != null) {
                return (XSObject)this.fMaps[i].get(localName);
            }
            for (int j = 0; j < this.fLength; ++j) {
                XSObject ret = this.fArray[j];
                if (!ret.getName().equals(localName)) continue;
                return ret;
            }
            return null;
        }
        return null;
    }

    @Override
    public synchronized XSObject item(int index) {
        if (this.fArray == null) {
            this.getLength();
            this.fArray = new XSObject[this.fLength];
            int pos = 0;
            for (int i = 0; i < this.fNSNum; ++i) {
                pos += this.fMaps[i].getValues(this.fArray, pos);
            }
        }
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fArray[index];
    }

    static boolean isEqual(String one, String two) {
        return one != null ? one.equals(two) : two == null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public XSObject get(Object key) {
        if (key instanceof QName) {
            QName name = (QName)key;
            String namespaceURI = name.getNamespaceURI();
            if ("".equals(namespaceURI)) {
                namespaceURI = null;
            }
            String localPart = name.getLocalPart();
            return this.itemByName(namespaceURI, localPart);
        }
        return null;
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public synchronized Set<Map.Entry<QName, XSObject>> entrySet() {
        if (this.fEntrySet == null) {
            final int length = this.getLength();
            final XSNamedMapEntry[] entries = new XSNamedMapEntry[length];
            for (int i = 0; i < length; ++i) {
                XSObject xso = this.item(i);
                entries[i] = new XSNamedMapEntry(new QName(xso.getNamespace(), xso.getName()), xso);
            }
            this.fEntrySet = new AbstractSet<Map.Entry<QName, XSObject>>(){

                @Override
                public Iterator<Map.Entry<QName, XSObject>> iterator() {
                    return new Iterator<Map.Entry<QName, XSObject>>(){
                        private int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < length;
                        }

                        @Override
                        public Map.Entry<QName, XSObject> next() {
                            if (this.index < length) {
                                return entries[this.index++];
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return length;
                }
            };
        }
        return this.fEntrySet;
    }

    private static final class XSNamedMapEntry
    implements Map.Entry<QName, XSObject> {
        private final QName key;
        private final XSObject value;

        public XSNamedMapEntry(QName key, XSObject value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public QName getKey() {
            return this.key;
        }

        @Override
        public XSObject getValue() {
            return this.value;
        }

        @Override
        public XSObject setValue(XSObject value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(XSNamedMapEntry o) {
            if (o instanceof Map.Entry) {
                XSNamedMapEntry e = o;
                QName otherKey = (QName)e.getKey();
                XSObject otherValue = (XSObject)e.getValue();
                return (this.key == null ? otherKey == null : this.key.equals(otherKey)) && (this.value == null ? otherValue == null : this.value.equals(otherValue));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(String.valueOf(this.key));
            buffer.append('=');
            buffer.append(String.valueOf(this.value));
            return buffer.toString();
        }
    }
}

