/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.traversers;

import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaSymbols;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.identity.IdentityConstraint;
import com.sun.org.apache.xerces.internal.impl.xs.identity.UniqueOrKey;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSAttributeChecker;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDAbstractIDConstraintTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDHandler;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDocumentInfo;
import com.sun.org.apache.xerces.internal.util.DOMUtil;
import org.w3c.dom.Element;

class XSDUniqueOrKeyTraverser
extends XSDAbstractIDConstraintTraverser {
    public XSDUniqueOrKeyTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    void traverse(Element uElem, XSElementDecl element, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(uElem, false, schemaDoc);
        String uName = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        if (uName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{DOMUtil.getLocalName(uElem), SchemaSymbols.ATT_NAME}, uElem);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        UniqueOrKey uniqueOrKey = DOMUtil.getLocalName(uElem).equals(SchemaSymbols.ELT_UNIQUE) ? new UniqueOrKey(schemaDoc.fTargetNamespace, uName, element.fName, 3) : new UniqueOrKey(schemaDoc.fTargetNamespace, uName, element.fName, 1);
        if (this.traverseIdentityConstraint(uniqueOrKey, uElem, schemaDoc, attrValues)) {
            if (grammar.getIDConstraintDecl(uniqueOrKey.getIdentityConstraintName()) == null) {
                grammar.addIDConstraintDecl(element, uniqueOrKey);
            }
            String loc = this.fSchemaHandler.schemaDocument2SystemId(schemaDoc);
            IdentityConstraint idc = grammar.getIDConstraintDecl(uniqueOrKey.getIdentityConstraintName(), loc);
            if (idc == null) {
                grammar.addIDConstraintDecl(element, uniqueOrKey, loc);
            }
            if (this.fSchemaHandler.fTolerateDuplicates) {
                if (idc != null && idc instanceof UniqueOrKey) {
                    uniqueOrKey = (UniqueOrKey)idc;
                }
                this.fSchemaHandler.addIDConstraintDecl(uniqueOrKey);
            }
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
    }
}

