/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs;

import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.impl.xs.XSComplexTypeDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDeclHelper;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;
import com.sun.org.apache.xerces.internal.xs.XSSimpleTypeDefinition;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SubstitutionGroupHandler {
    private static final XSElementDecl[] EMPTY_GROUP = new XSElementDecl[0];
    private final XSElementDeclHelper fXSElementDeclHelper;
    Map<XSElementDecl, Object> fSubGroupsB = new HashMap<XSElementDecl, Object>();
    private static final OneSubGroup[] EMPTY_VECTOR = new OneSubGroup[0];
    Map<XSElementDecl, XSElementDecl[]> fSubGroups = new HashMap<XSElementDecl, XSElementDecl[]>();

    public SubstitutionGroupHandler(XSElementDeclHelper elementDeclHelper) {
        this.fXSElementDeclHelper = elementDeclHelper;
    }

    public XSElementDecl getMatchingElemDecl(QName element, XSElementDecl exemplar) {
        if (Objects.equals(element.localpart, exemplar.fName) && Objects.equals(element.uri, exemplar.fTargetNamespace)) {
            return exemplar;
        }
        if (exemplar.fScope != 1) {
            return null;
        }
        if ((exemplar.fBlock & 4) != 0) {
            return null;
        }
        XSElementDecl eDecl = this.fXSElementDeclHelper.getGlobalElementDecl(element);
        if (eDecl == null) {
            return null;
        }
        if (this.substitutionGroupOK(eDecl, exemplar, exemplar.fBlock)) {
            return eDecl;
        }
        return null;
    }

    protected boolean substitutionGroupOK(XSElementDecl element, XSElementDecl exemplar, short blockingConstraint) {
        if (element == exemplar) {
            return true;
        }
        if ((blockingConstraint & 4) != 0) {
            return false;
        }
        XSElementDecl subGroup = element.fSubGroup;
        while (subGroup != null && subGroup != exemplar) {
            subGroup = subGroup.fSubGroup;
        }
        if (subGroup == null) {
            return false;
        }
        return this.typeDerivationOK(element.fType, exemplar.fType, blockingConstraint);
    }

    private boolean typeDerivationOK(XSTypeDefinition derived, XSTypeDefinition base, short blockingConstraint) {
        short devMethod = 0;
        short blockConstraint = blockingConstraint;
        XSTypeDefinition type = derived;
        while (type != base && type != SchemaGrammar.fAnyType) {
            devMethod = type.getTypeCategory() == 15 ? (short)(devMethod | ((XSComplexTypeDecl)type).fDerivedBy) : (short)(devMethod | 2);
            if ((type = type.getBaseType()) == null) {
                type = SchemaGrammar.fAnyType;
            }
            if (type.getTypeCategory() != 15) continue;
            blockConstraint = (short)(blockConstraint | ((XSComplexTypeDecl)type).fBlock);
        }
        if (type != base) {
            XSSimpleTypeDefinition st;
            if (base.getTypeCategory() == 16 && (st = (XSSimpleTypeDefinition)base).getVariety() == 3) {
                XSObjectList memberTypes = st.getMemberTypes();
                int length = memberTypes.getLength();
                for (int i = 0; i < length; ++i) {
                    if (!this.typeDerivationOK(derived, (XSTypeDefinition)memberTypes.item(i), blockingConstraint)) continue;
                    return true;
                }
            }
            return false;
        }
        return (devMethod & blockConstraint) == 0;
    }

    public boolean inSubstitutionGroup(XSElementDecl element, XSElementDecl exemplar) {
        return this.substitutionGroupOK(element, exemplar, exemplar.fBlock);
    }

    public void reset() {
        this.fSubGroupsB.clear();
        this.fSubGroups.clear();
    }

    public void addSubstitutionGroup(XSElementDecl[] elements) {
        for (int i = elements.length - 1; i >= 0; --i) {
            XSElementDecl element = elements[i];
            XSElementDecl subHead = element.fSubGroup;
            ArrayList<XSElementDecl> subGroup = (ArrayList<XSElementDecl>)this.fSubGroupsB.get(subHead);
            if (subGroup == null) {
                subGroup = new ArrayList<XSElementDecl>();
                this.fSubGroupsB.put(subHead, subGroup);
            }
            subGroup.add(element);
        }
    }

    public XSElementDecl[] getSubstitutionGroup(XSElementDecl element) {
        XSElementDecl[] subGroup = this.fSubGroups.get(element);
        if (subGroup != null) {
            return subGroup;
        }
        if ((element.fBlock & 4) != 0) {
            this.fSubGroups.put(element, EMPTY_GROUP);
            return EMPTY_GROUP;
        }
        OneSubGroup[] groupB = this.getSubGroupB(element, new OneSubGroup());
        int len = groupB.length;
        int rlen = 0;
        XSElementDecl[] ret = new XSElementDecl[len];
        for (int i = 0; i < len; ++i) {
            if ((element.fBlock & groupB[i].dMethod) != 0) continue;
            ret[rlen++] = groupB[i].sub;
        }
        if (rlen < len) {
            XSElementDecl[] ret1 = new XSElementDecl[rlen];
            System.arraycopy(ret, 0, ret1, 0, rlen);
            ret = ret1;
        }
        this.fSubGroups.put(element, ret);
        return ret;
    }

    private OneSubGroup[] getSubGroupB(XSElementDecl element, OneSubGroup methods) {
        Object subGroup = this.fSubGroupsB.get(element);
        if (subGroup == null) {
            this.fSubGroupsB.put(element, EMPTY_VECTOR);
            return EMPTY_VECTOR;
        }
        if (subGroup instanceof OneSubGroup[]) {
            return (OneSubGroup[])subGroup;
        }
        ArrayList group = (ArrayList)subGroup;
        ArrayList<OneSubGroup> newGroup = new ArrayList<OneSubGroup>();
        for (int i = group.size() - 1; i >= 0; --i) {
            XSElementDecl sub = (XSElementDecl)group.get(i);
            if (!this.getDBMethods(sub.fType, element.fType, methods)) continue;
            short dMethod = methods.dMethod;
            short bMethod = methods.bMethod;
            newGroup.add(new OneSubGroup(sub, methods.dMethod, methods.bMethod));
            OneSubGroup[] group1 = this.getSubGroupB(sub, methods);
            for (int j = group1.length - 1; j >= 0; --j) {
                short dSubMethod = (short)(dMethod | group1[j].dMethod);
                short bSubMethod = (short)(bMethod | group1[j].bMethod);
                if ((dSubMethod & bSubMethod) != 0) continue;
                newGroup.add(new OneSubGroup(group1[j].sub, dSubMethod, bSubMethod));
            }
        }
        OneSubGroup[] ret = new OneSubGroup[newGroup.size()];
        for (int i = newGroup.size() - 1; i >= 0; --i) {
            ret[i] = (OneSubGroup)newGroup.get(i);
        }
        this.fSubGroupsB.put(element, ret);
        return ret;
    }

    private boolean getDBMethods(XSTypeDefinition typed, XSTypeDefinition typeb, OneSubGroup methods) {
        int dMethod = 0;
        short bMethod = 0;
        while (typed != typeb && typed != SchemaGrammar.fAnyType) {
            dMethod = typed.getTypeCategory() == 15 ? (int)((short)(dMethod | ((XSComplexTypeDecl)typed).fDerivedBy)) : (int)((short)(dMethod | 2));
            if ((typed = typed.getBaseType()) == null) {
                typed = SchemaGrammar.fAnyType;
            }
            if (typed.getTypeCategory() != 15) continue;
            bMethod = (short)(bMethod | ((XSComplexTypeDecl)typed).fBlock);
        }
        if (typed != typeb || dMethod & bMethod) {
            return false;
        }
        methods.dMethod = (short)dMethod;
        methods.bMethod = bMethod;
        return true;
    }

    private static final class OneSubGroup {
        XSElementDecl sub;
        short dMethod;
        short bMethod;

        OneSubGroup() {
        }

        OneSubGroup(XSElementDecl sub, short dMethod, short bMethod) {
            this.sub = sub;
            this.dMethod = dMethod;
            this.bMethod = bMethod;
        }
    }
}

