/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xpath.regex;

final class CaseInsensitiveMap {
    private static final int CHUNK_SHIFT = 10;
    private static final int CHUNK_SIZE = 1024;
    private static final int CHUNK_MASK = 1023;
    private static final int INITIAL_CHUNK_COUNT = 64;
    private static final int LOWER_CASE_MATCH = 1;
    private static final int UPPER_CASE_MATCH = 2;
    private static int[][][] caseInsensitiveMap;

    CaseInsensitiveMap() {
    }

    public static int[] get(int codePoint) {
        return codePoint < 65536 ? CaseInsensitiveMap.getMapping(codePoint) : null;
    }

    private static int[] getMapping(int codePoint) {
        int chunk = codePoint >>> 10;
        int offset = codePoint & 0x3FF;
        return caseInsensitiveMap[chunk][offset];
    }

    private static void buildCaseInsensitiveMap() {
        caseInsensitiveMap = new int[64][1024][];
        for (int i = 0; i < 65536; ++i) {
            int uc;
            int lc = Character.toLowerCase(i);
            if (lc == (uc = Character.toUpperCase(i)) && lc == i) continue;
            int[] map = new int[2];
            int index = 0;
            if (lc != i) {
                map[index++] = lc;
                map[index++] = 1;
                int[] lcMap = CaseInsensitiveMap.getMapping(lc);
                if (lcMap != null) {
                    map = CaseInsensitiveMap.updateMap(i, map, lc, lcMap, 1);
                }
            }
            if (uc != i) {
                if (index == map.length) {
                    map = CaseInsensitiveMap.expandMap(map, 2);
                }
                map[index++] = uc;
                map[index++] = 2;
                int[] ucMap = CaseInsensitiveMap.getMapping(uc);
                if (ucMap != null) {
                    map = CaseInsensitiveMap.updateMap(i, map, uc, ucMap, 2);
                }
            }
            CaseInsensitiveMap.set(i, map);
        }
    }

    private static int[] expandMap(int[] srcMap, int expandBy) {
        int oldLen = srcMap.length;
        int[] newMap = new int[oldLen + expandBy];
        System.arraycopy(srcMap, 0, newMap, 0, oldLen);
        return newMap;
    }

    private static void set(int codePoint, int[] map) {
        int chunk = codePoint >>> 10;
        int offset = codePoint & 0x3FF;
        CaseInsensitiveMap.caseInsensitiveMap[chunk][offset] = map;
    }

    private static int[] updateMap(int codePoint, int[] codePointMap, int ciCodePoint, int[] ciCodePointMap, int matchType) {
        for (int i = 0; i < ciCodePointMap.length; i += 2) {
            int c = ciCodePointMap[i];
            int[] cMap = CaseInsensitiveMap.getMapping(c);
            if (cMap == null || !CaseInsensitiveMap.contains(cMap, ciCodePoint, matchType)) continue;
            if (!CaseInsensitiveMap.contains(cMap, codePoint)) {
                cMap = CaseInsensitiveMap.expandAndAdd(cMap, codePoint, matchType);
                CaseInsensitiveMap.set(c, cMap);
            }
            if (CaseInsensitiveMap.contains(codePointMap, c)) continue;
            codePointMap = CaseInsensitiveMap.expandAndAdd(codePointMap, c, matchType);
        }
        if (!CaseInsensitiveMap.contains(ciCodePointMap, codePoint)) {
            ciCodePointMap = CaseInsensitiveMap.expandAndAdd(ciCodePointMap, codePoint, matchType);
            CaseInsensitiveMap.set(ciCodePoint, ciCodePointMap);
        }
        return codePointMap;
    }

    private static boolean contains(int[] map, int codePoint) {
        for (int i = 0; i < map.length; i += 2) {
            if (map[i] != codePoint) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(int[] map, int codePoint, int matchType) {
        for (int i = 0; i < map.length; i += 2) {
            if (map[i] != codePoint || map[i + 1] != matchType) continue;
            return true;
        }
        return false;
    }

    private static int[] expandAndAdd(int[] srcMap, int codePoint, int matchType) {
        int oldLen = srcMap.length;
        int[] newMap = new int[oldLen + 2];
        System.arraycopy(srcMap, 0, newMap, 0, oldLen);
        newMap[oldLen] = codePoint;
        newMap[oldLen + 1] = matchType;
        return newMap;
    }

    static {
        CaseInsensitiveMap.buildCaseInsensitiveMap();
    }
}

