/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.util;

import com.sun.org.apache.xerces.internal.xs.XSException;
import com.sun.org.apache.xerces.internal.xs.datatypes.ByteList;
import java.util.AbstractList;

public class ByteListImpl
extends AbstractList<Byte>
implements ByteList {
    protected final byte[] data;
    protected String canonical;

    public ByteListImpl(byte[] data) {
        this.data = data;
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public boolean contains(byte item) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte item(int index) throws XSException {
        if (index < 0 || index > this.data.length - 1) {
            throw new XSException(2, null);
        }
        return this.data[index];
    }

    @Override
    public Byte get(int index) {
        if (index >= 0 && index < this.data.length) {
            return this.data[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public byte[] toByteArray() {
        byte[] ret = new byte[this.data.length];
        System.arraycopy(this.data, 0, ret, 0, this.data.length);
        return ret;
    }
}

