/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.DeferredDocumentImpl;
import com.sun.org.apache.xerces.internal.dom.DeferredNode;
import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import com.sun.org.apache.xerces.internal.dom.DocumentTypeImpl;
import com.sun.org.apache.xerces.internal.dom.NamedNodeMapImpl;

public class DeferredDocumentTypeImpl
extends DocumentTypeImpl
implements DeferredNode {
    static final long serialVersionUID = -2172579663227313509L;
    protected transient int fNodeIndex;

    DeferredDocumentTypeImpl(DeferredDocumentImpl ownerDocument, int nodeIndex) {
        super(ownerDocument, null);
        this.fNodeIndex = nodeIndex;
        this.needsSyncData(true);
        this.needsSyncChildren(true);
    }

    @Override
    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    @Override
    protected void synchronizeData() {
        this.needsSyncData(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument;
        this.name = ownerDocument.getNodeName(this.fNodeIndex);
        this.publicID = ownerDocument.getNodeValue(this.fNodeIndex);
        this.systemID = ownerDocument.getNodeURI(this.fNodeIndex);
        int extraDataIndex = ownerDocument.getNodeExtra(this.fNodeIndex);
        this.internalSubset = ownerDocument.getNodeValue(extraDataIndex);
    }

    @Override
    protected void synchronizeChildren() {
        boolean orig = this.ownerDocument().getMutationEvents();
        this.ownerDocument().setMutationEvents(false);
        this.needsSyncChildren(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument;
        this.entities = new NamedNodeMapImpl(this);
        this.notations = new NamedNodeMapImpl(this);
        this.elements = new NamedNodeMapImpl(this);
        DeferredNode last = null;
        int index = ownerDocument.getLastChild(this.fNodeIndex);
        while (index != -1) {
            DeferredNode node = ownerDocument.getNodeObject(index);
            short type = node.getNodeType();
            switch (type) {
                case 6: {
                    this.entities.setNamedItem(node);
                    break;
                }
                case 12: {
                    this.notations.setNamedItem(node);
                    break;
                }
                case 21: {
                    this.elements.setNamedItem(node);
                    break;
                }
                case 1: {
                    if (!((DocumentImpl)this.getOwnerDocument()).allowGrammarAccess) break;
                    this.insertBefore(node, last);
                    last = node;
                    break;
                }
                default: {
                    System.out.println("DeferredDocumentTypeImpl#synchronizeInfo: node.getNodeType() = " + node.getNodeType() + ", class = " + node.getClass().getName());
                }
            }
            index = ownerDocument.getPrevSibling(index);
        }
        this.ownerDocument().setMutationEvents(orig);
        this.setReadOnly(true, false);
    }
}

