/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.trax;

import com.sun.org.apache.xalan.internal.utils.FeaturePropertyBase;
import com.sun.org.apache.xalan.internal.utils.ObjectFactory;
import com.sun.org.apache.xalan.internal.utils.XMLSecurityPropertyManager;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SourceLoader;
import com.sun.org.apache.xalan.internal.xsltc.compiler.XSLTC;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager;
import com.sun.org.apache.xalan.internal.xsltc.trax.DOM2SAX;
import com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesHandlerImpl;
import com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl;
import com.sun.org.apache.xalan.internal.xsltc.trax.TrAXFilter;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerHandlerImpl;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerImpl;
import com.sun.org.apache.xalan.internal.xsltc.trax.Util;
import com.sun.org.apache.xml.internal.utils.StopParseException;
import com.sun.org.apache.xml.internal.utils.StylesheetPIHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.catalog.CatalogException;
import javax.xml.catalog.CatalogFeatures;
import javax.xml.catalog.CatalogManager;
import javax.xml.catalog.CatalogResolver;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import jdk.xml.internal.JdkConstants;
import jdk.xml.internal.JdkProperty;
import jdk.xml.internal.JdkXmlFeatures;
import jdk.xml.internal.JdkXmlUtils;
import jdk.xml.internal.SecuritySupport;
import jdk.xml.internal.TransformErrorListener;
import jdk.xml.internal.XMLSecurityManager;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class TransformerFactoryImpl
extends SAXTransformerFactory
implements SourceLoader {
    public static final String TRANSLET_NAME = "translet-name";
    public static final String DESTINATION_DIRECTORY = "destination-directory";
    public static final String PACKAGE_NAME = "package-name";
    public static final String JAR_NAME = "jar-name";
    public static final String GENERATE_TRANSLET = "generate-translet";
    public static final String AUTO_TRANSLET = "auto-translet";
    public static final String USE_CLASSPATH = "use-classpath";
    public static final String DEBUG = "debug";
    public static final String ENABLE_INLINING = "enable-inlining";
    public static final String INDENT_NUMBER = "indent-number";
    private final ErrorListener _defaultListener;
    private ErrorListener _errorListener;
    private boolean _hasUserErrListener;
    private URIResolver _uriResolver;
    protected static final String DEFAULT_TRANSLET_NAME = "GregorSamsa";
    private String _transletName;
    private String _destinationDirectory;
    private static final String DEFAULT_TRANSLATE_PACKAGE = "die.verwandlung";
    private String _packageName;
    private String _jarFileName;
    private Map<Source, PIParamWrapper> _piParams;
    private boolean _debug;
    private boolean _enableInlining;
    private boolean _generateTranslet;
    private boolean _autoTranslet;
    private boolean _useClasspath;
    private int _indentNumber;
    private boolean _isNotSecureProcessing;
    private boolean _isSecureMode;
    private boolean _overrideDefaultParser;
    private String _accessExternalStylesheet;
    private String _accessExternalDTD;
    private XMLSecurityPropertyManager _xmlSecurityPropertyMgr;
    private XMLSecurityManager _xmlSecurityManager;
    private final JdkXmlFeatures _xmlFeatures;
    private JdkProperty<ClassLoader> _extensionClassLoader;
    private Map<String, Class<?>> _xsltcExtensionFunctions;
    CatalogResolver _catalogUriResolver;
    CatalogFeatures _catalogFeatures;
    CatalogFeatures.Builder cfBuilder;
    String _catalogFiles;
    String _catalogDefer;
    String _catalogPrefer;
    String _catalogResolve;
    int _cdataChunkSize;

    public TransformerFactoryImpl() {
        this._errorListener = this._defaultListener = new TransformErrorListener();
        this._uriResolver = null;
        this._transletName = DEFAULT_TRANSLET_NAME;
        this._destinationDirectory = null;
        this._packageName = DEFAULT_TRANSLATE_PACKAGE;
        this._jarFileName = null;
        this._piParams = null;
        this._debug = false;
        this._enableInlining = false;
        this._generateTranslet = false;
        this._autoTranslet = false;
        this._useClasspath = false;
        this._indentNumber = -1;
        this._isNotSecureProcessing = true;
        this._isSecureMode = false;
        this._accessExternalStylesheet = "all";
        this._accessExternalDTD = "all";
        this._extensionClassLoader = null;
        this.cfBuilder = CatalogFeatures.builder();
        this._catalogFiles = null;
        this._catalogDefer = null;
        this._catalogPrefer = null;
        this._catalogResolve = null;
        this._cdataChunkSize = JdkConstants.CDATA_CHUNK_SIZE_DEFAULT;
        if (System.getSecurityManager() != null) {
            this._isSecureMode = true;
            this._isNotSecureProcessing = false;
        }
        this._xmlFeatures = new JdkXmlFeatures(!this._isNotSecureProcessing);
        this._overrideDefaultParser = this._xmlFeatures.getFeature(JdkXmlFeatures.XmlFeature.JDK_OVERRIDE_PARSER);
        this._xmlSecurityPropertyMgr = new XMLSecurityPropertyManager();
        this._accessExternalDTD = this._xmlSecurityPropertyMgr.getValue(XMLSecurityPropertyManager.Property.ACCESS_EXTERNAL_DTD);
        this._accessExternalStylesheet = this._xmlSecurityPropertyMgr.getValue(XMLSecurityPropertyManager.Property.ACCESS_EXTERNAL_STYLESHEET);
        this._xmlSecurityManager = new XMLSecurityManager(true);
        this._xsltcExtensionFunctions = null;
        this._extensionClassLoader = new JdkProperty<Object>(JdkProperty.ImplPropMap.EXTCLSLOADER, ClassLoader.class, null, JdkProperty.State.DEFAULT);
    }

    public Map<String, Class<?>> getExternalExtensionsMap() {
        return this._xsltcExtensionFunctions;
    }

    @Override
    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            ErrorMsg err = new ErrorMsg("ERROR_LISTENER_NULL_ERR", "TransformerFactory");
            throw new IllegalArgumentException(err.toString());
        }
        this._hasUserErrListener = true;
        this._errorListener = listener;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    String getPackageName() {
        return this._packageName;
    }

    @Override
    public Object getAttribute(String name) throws IllegalArgumentException {
        String propertyValue;
        if (name.equals(TRANSLET_NAME)) {
            return this._transletName;
        }
        if (name.equals(GENERATE_TRANSLET)) {
            return this._generateTranslet;
        }
        if (name.equals(AUTO_TRANSLET)) {
            return this._autoTranslet;
        }
        if (name.equals(ENABLE_INLINING)) {
            if (this._enableInlining) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("http://apache.org/xml/properties/security-manager")) {
            return this._xmlSecurityManager;
        }
        if (JdkProperty.ImplPropMap.EXTCLSLOADER.is(name)) {
            return this._extensionClassLoader == null ? null : this._extensionClassLoader.getValue();
        }
        if (JdkXmlUtils.CATALOG_FILES.equals(name)) {
            return this._catalogFiles;
        }
        if (JdkXmlUtils.CATALOG_DEFER.equals(name)) {
            return this._catalogDefer;
        }
        if (JdkXmlUtils.CATALOG_PREFER.equals(name)) {
            return this._catalogPrefer;
        }
        if (JdkXmlUtils.CATALOG_RESOLVE.equals(name)) {
            return this._catalogResolve;
        }
        if ("javax.xml.catalog.catalogFeatures".equals(name)) {
            return this.buildCatalogFeatures();
        }
        if (JdkProperty.ImplPropMap.CDATACHUNKSIZE.is(name)) {
            return this._cdataChunkSize;
        }
        String string = propertyValue = this._xmlSecurityManager != null ? this._xmlSecurityManager.getLimitAsString(name) : null;
        if (propertyValue != null) {
            return propertyValue;
        }
        String string2 = propertyValue = this._xmlSecurityPropertyMgr != null ? this._xmlSecurityPropertyMgr.getValue(name) : null;
        if (propertyValue != null) {
            return propertyValue;
        }
        ErrorMsg err = new ErrorMsg("JAXP_INVALID_ATTR_ERR", name);
        throw new IllegalArgumentException(err.toString());
    }

    @Override
    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (name.equals(TRANSLET_NAME) && value instanceof String) {
            this._transletName = (String)value;
            return;
        }
        if (name.equals(DESTINATION_DIRECTORY) && value instanceof String) {
            this._destinationDirectory = (String)value;
            return;
        }
        if (name.equals(PACKAGE_NAME) && value instanceof String) {
            this._packageName = (String)value;
            return;
        }
        if (name.equals(JAR_NAME) && value instanceof String) {
            this._jarFileName = (String)value;
            return;
        }
        if (name.equals(GENERATE_TRANSLET)) {
            if (value instanceof Boolean) {
                this._generateTranslet = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._generateTranslet = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals(AUTO_TRANSLET)) {
            if (value instanceof Boolean) {
                this._autoTranslet = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._autoTranslet = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals(USE_CLASSPATH)) {
            if (value instanceof Boolean) {
                this._useClasspath = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._useClasspath = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals(DEBUG)) {
            if (value instanceof Boolean) {
                this._debug = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._debug = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals(ENABLE_INLINING)) {
            if (value instanceof Boolean) {
                this._enableInlining = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._enableInlining = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals(INDENT_NUMBER)) {
            if (value instanceof String) {
                try {
                    this._indentNumber = Integer.parseInt((String)value);
                    return;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (value instanceof Integer) {
                this._indentNumber = (Integer)value;
                return;
            }
        } else {
            if (JdkProperty.ImplPropMap.EXTCLSLOADER.is(name)) {
                if (value instanceof ClassLoader) {
                    this._extensionClassLoader.setValue(name, (ClassLoader)value, JdkProperty.State.APIPROPERTY);
                    return;
                }
                ErrorMsg err = new ErrorMsg("JAXP_INVALID_ATTR_VALUE_ERR", "Extension Functions ClassLoader");
                throw new IllegalArgumentException(err.toString());
            }
            if (JdkXmlUtils.CATALOG_FILES.equals(name)) {
                this._catalogFiles = (String)value;
                this.cfBuilder = CatalogFeatures.builder().with(CatalogFeatures.Feature.FILES, this._catalogFiles);
                return;
            }
            if (JdkXmlUtils.CATALOG_DEFER.equals(name)) {
                this._catalogDefer = (String)value;
                this.cfBuilder = CatalogFeatures.builder().with(CatalogFeatures.Feature.DEFER, this._catalogDefer);
                return;
            }
            if (JdkXmlUtils.CATALOG_PREFER.equals(name)) {
                this._catalogPrefer = (String)value;
                this.cfBuilder = CatalogFeatures.builder().with(CatalogFeatures.Feature.PREFER, this._catalogPrefer);
                return;
            }
            if (JdkXmlUtils.CATALOG_RESOLVE.equals(name)) {
                this._catalogResolve = (String)value;
                this.cfBuilder = CatalogFeatures.builder().with(CatalogFeatures.Feature.RESOLVE, this._catalogResolve);
                return;
            }
            if (JdkProperty.ImplPropMap.CDATACHUNKSIZE.is(name)) {
                this._cdataChunkSize = JdkXmlUtils.getValue(value, this._cdataChunkSize);
                return;
            }
        }
        if (this._xmlSecurityManager != null && this._xmlSecurityManager.setLimit(name, JdkProperty.State.APIPROPERTY, value)) {
            return;
        }
        if (this._xmlSecurityPropertyMgr != null && this._xmlSecurityPropertyMgr.setValue(name, FeaturePropertyBase.State.APIPROPERTY, value)) {
            this._accessExternalDTD = this._xmlSecurityPropertyMgr.getValue(XMLSecurityPropertyManager.Property.ACCESS_EXTERNAL_DTD);
            this._accessExternalStylesheet = this._xmlSecurityPropertyMgr.getValue(XMLSecurityPropertyManager.Property.ACCESS_EXTERNAL_STYLESHEET);
            return;
        }
        ErrorMsg err = new ErrorMsg("JAXP_INVALID_ATTR_ERR", name);
        throw new IllegalArgumentException(err.toString());
    }

    @Override
    public void setFeature(String name, boolean value) throws TransformerConfigurationException {
        if (name == null) {
            ErrorMsg err = new ErrorMsg("JAXP_SET_FEATURE_NULL_NAME");
            throw new NullPointerException(err.toString());
        }
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            if (this._isSecureMode && !value) {
                ErrorMsg err = new ErrorMsg("JAXP_SECUREPROCESSING_FEATURE");
                throw new TransformerConfigurationException(err.toString());
            }
            this._isNotSecureProcessing = !value;
            this._xmlSecurityManager.setSecureProcessing(value);
            if (value) {
                this._xmlSecurityPropertyMgr.setValue(XMLSecurityPropertyManager.Property.ACCESS_EXTERNAL_DTD, FeaturePropertyBase.State.FSP, "");
                this._xmlSecurityPropertyMgr.setValue(XMLSecurityPropertyManager.Property.ACCESS_EXTERNAL_STYLESHEET, FeaturePropertyBase.State.FSP, "");
                this._accessExternalDTD = this._xmlSecurityPropertyMgr.getValue(XMLSecurityPropertyManager.Property.ACCESS_EXTERNAL_DTD);
                this._accessExternalStylesheet = this._xmlSecurityPropertyMgr.getValue(XMLSecurityPropertyManager.Property.ACCESS_EXTERNAL_STYLESHEET);
            }
            if (value && this._xmlFeatures != null) {
                this._xmlFeatures.setFeature(JdkXmlFeatures.XmlFeature.ENABLE_EXTENSION_FUNCTION, JdkProperty.State.FSP, false);
            }
        } else {
            if (name.equals("http://www.oracle.com/feature/use-service-mechanism") && this._isSecureMode) {
                return;
            }
            if (this._xmlFeatures != null && this._xmlFeatures.setFeature(name, JdkProperty.State.APIPROPERTY, (Object)value)) {
                if (JdkProperty.ImplPropMap.OVERRIDEPARSER.is(name)) {
                    this._overrideDefaultParser = this._xmlFeatures.getFeature(JdkXmlFeatures.XmlFeature.JDK_OVERRIDE_PARSER);
                }
                return;
            }
            ErrorMsg err = new ErrorMsg("JAXP_UNSUPPORTED_FEATURE", name);
            throw new TransformerConfigurationException(err.toString());
        }
    }

    @Override
    public boolean getFeature(String name) {
        String[] features = new String[]{"http://javax.xml.transform.dom.DOMSource/feature", "http://javax.xml.transform.dom.DOMResult/feature", "http://javax.xml.transform.sax.SAXSource/feature", "http://javax.xml.transform.sax.SAXResult/feature", "http://javax.xml.transform.stax.StAXSource/feature", "http://javax.xml.transform.stax.StAXResult/feature", "http://javax.xml.transform.stream.StreamSource/feature", "http://javax.xml.transform.stream.StreamResult/feature", "http://javax.xml.transform.sax.SAXTransformerFactory/feature", "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter", "http://www.oracle.com/feature/use-service-mechanism"};
        if (name == null) {
            ErrorMsg err = new ErrorMsg("JAXP_GET_FEATURE_NULL_NAME");
            throw new NullPointerException(err.toString());
        }
        for (int i = 0; i < features.length; ++i) {
            if (!name.equals(features[i])) continue;
            return true;
        }
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return !this._isNotSecureProcessing;
        }
        int index = this._xmlFeatures.getIndex(name);
        if (index > -1) {
            return this._xmlFeatures.getFeature(index);
        }
        return false;
    }

    public boolean overrideDefaultParser() {
        return this._overrideDefaultParser;
    }

    public JdkXmlFeatures getJdkXmlFeatures() {
        return this._xmlFeatures;
    }

    @Override
    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    @Override
    public void setURIResolver(URIResolver resolver) {
        this._uriResolver = resolver;
    }

    @Override
    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        XMLReader reader = null;
        StylesheetPIHandler _stylesheetPIHandler = new StylesheetPIHandler(null, media, title, charset);
        try {
            if (source instanceof DOMSource) {
                DOMSource domsrc = (DOMSource)source;
                String baseId = domsrc.getSystemId();
                Node node = domsrc.getNode();
                DOM2SAX dom2sax = new DOM2SAX(node);
                _stylesheetPIHandler.setBaseId(baseId);
                dom2sax.setContentHandler(_stylesheetPIHandler);
                dom2sax.parse();
            } else {
                if (source instanceof SAXSource) {
                    reader = ((SAXSource)source).getXMLReader();
                }
                InputSource isource = SAXSource.sourceToInputSource(source);
                String baseId = isource.getSystemId();
                if (reader == null) {
                    reader = JdkXmlUtils.getXMLReader(this._overrideDefaultParser, !this._isNotSecureProcessing);
                }
                _stylesheetPIHandler.setBaseId(baseId);
                reader.setContentHandler(_stylesheetPIHandler);
                reader.parse(isource);
            }
            if (this._uriResolver != null) {
                _stylesheetPIHandler.setURIResolver(this._uriResolver);
            }
        }
        catch (StopParseException domsrc) {
        }
        catch (IOException | SAXException e) {
            throw new TransformerConfigurationException("getAssociatedStylesheets failed", e);
        }
        return _stylesheetPIHandler.getAssociatedStylesheet();
    }

    @Override
    public Transformer newTransformer() throws TransformerConfigurationException {
        this.buildCatalogFeatures();
        TransformerImpl result = new TransformerImpl(new Properties(), this._indentNumber, this);
        if (this._uriResolver != null) {
            result.setURIResolver(this._uriResolver);
        }
        if (!this._isNotSecureProcessing) {
            result.setSecureProcessing(true);
        }
        return result;
    }

    @Override
    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        Transformer transformer = templates.newTransformer();
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return transformer;
    }

    private void passWarningsToListener(List<ErrorMsg> messages) throws TransformerException {
        if (this._errorListener == null || messages == null) {
            return;
        }
        int count = messages.size();
        for (int pos = 0; pos < count; ++pos) {
            ErrorMsg msg = messages.get(pos);
            if (msg.isWarningError()) {
                this._errorListener.error(new TransformerConfigurationException(msg.toString()));
                continue;
            }
            this._errorListener.warning(new TransformerConfigurationException(msg.toString()));
        }
    }

    private void passErrorsToListener(List<ErrorMsg> messages) {
        try {
            if (this._errorListener == null || messages == null) {
                return;
            }
            int count = messages.size();
            for (int pos = 0; pos < count; ++pos) {
                String message = messages.get(pos).toString();
                this._errorListener.error(new TransformerException(message));
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Override
    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        PIParamWrapper p;
        if (this._useClasspath) {
            String transletName = this.getTransletBaseName(source);
            if (this._packageName != null) {
                transletName = this._packageName + "." + transletName;
            }
            try {
                Class<?> clazz = ObjectFactory.findProviderClass(transletName, true);
                this.resetTransientAttributes();
                TemplatesImpl templates = new TemplatesImpl(new Class[]{clazz}, transletName, null, this._indentNumber, this);
                if (this._uriResolver != null) {
                    templates.setURIResolver(this._uriResolver);
                }
                return templates;
            }
            catch (ClassNotFoundException cnfe) {
                ErrorMsg err = new ErrorMsg("CLASS_NOT_FOUND_ERR", transletName);
                throw new TransformerConfigurationException(err.toString());
            }
            catch (Exception e) {
                ErrorMsg err = new ErrorMsg(new ErrorMsg("RUNTIME_ERROR_KEY") + e.getMessage());
                throw new TransformerConfigurationException(err.toString());
            }
        }
        if (this._autoTranslet) {
            byte[][] bytecodes;
            String transletClassName = this.getTransletBaseName(source);
            if (this._packageName != null) {
                transletClassName = this._packageName + "." + transletClassName;
            }
            if ((bytecodes = this._jarFileName != null ? this.getBytecodesFromJar(source, transletClassName) : this.getBytecodesFromClasses(source, transletClassName)) != null) {
                if (this._debug) {
                    if (this._jarFileName != null) {
                        System.err.println(new ErrorMsg("TRANSFORM_WITH_JAR_STR", (Object)transletClassName, (Object)this._jarFileName));
                    } else {
                        System.err.println(new ErrorMsg("TRANSFORM_WITH_TRANSLET_STR", transletClassName));
                    }
                }
                this.resetTransientAttributes();
                TemplatesImpl templates = new TemplatesImpl(bytecodes, transletClassName, null, this._indentNumber, this);
                if (this._uriResolver != null) {
                    templates.setURIResolver(this._uriResolver);
                }
                return templates;
            }
        }
        XSLTC xsltc = new XSLTC(this._xmlFeatures, this._hasUserErrListener);
        if (this._debug) {
            xsltc.setDebug(true);
        }
        if (this._enableInlining) {
            xsltc.setTemplateInlining(true);
        } else {
            xsltc.setTemplateInlining(false);
        }
        if (!this._isNotSecureProcessing) {
            xsltc.setSecureProcessing(true);
        }
        xsltc.setProperty("http://javax.xml.XMLConstants/property/accessExternalStylesheet", this._accessExternalStylesheet);
        xsltc.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", this._accessExternalDTD);
        xsltc.setProperty("http://apache.org/xml/properties/security-manager", this._xmlSecurityManager);
        xsltc.setProperty("jdk.xml.extensionClassLoader", this._extensionClassLoader == null ? null : this._extensionClassLoader.getValue());
        this.buildCatalogFeatures();
        xsltc.setProperty("javax.xml.catalog.catalogFeatures", this._catalogFeatures);
        xsltc.init();
        if (!this._isNotSecureProcessing) {
            this._xsltcExtensionFunctions = xsltc.getExternalExtensionFunctions();
        }
        if (this._uriResolver != null || this._catalogFiles != null && this._xmlFeatures.getFeature(JdkXmlFeatures.XmlFeature.USE_CATALOG)) {
            xsltc.setSourceLoader(this);
        }
        if (this._piParams != null && this._piParams.get(source) != null && (p = this._piParams.get(source)) != null) {
            xsltc.setPIParameters(p._media, p._title, p._charset);
        }
        int outputType = 2;
        if (this._generateTranslet || this._autoTranslet) {
            xsltc.setClassName(this.getTransletBaseName(source));
            if (this._destinationDirectory != null) {
                xsltc.setDestDirectory(this._destinationDirectory);
            } else {
                File xslFile;
                String xslDir;
                String xslName = this.getStylesheetFileName(source);
                if (xslName != null && (xslDir = (xslFile = new File(xslName)).getParent()) != null) {
                    xsltc.setDestDirectory(xslDir);
                }
            }
            if (this._packageName != null) {
                xsltc.setPackageName(this._packageName);
            }
            if (this._jarFileName != null) {
                xsltc.setJarFileName(this._jarFileName);
                outputType = 5;
            } else {
                outputType = 4;
            }
        }
        InputSource input = Util.getInputSource(xsltc, source);
        byte[][] bytecodes = xsltc.compile(null, input, outputType);
        String transletName = xsltc.getClassName();
        if ((this._generateTranslet || this._autoTranslet) && bytecodes != null && this._jarFileName != null) {
            try {
                xsltc.outputToJar();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.resetTransientAttributes();
        if (this._errorListener != this) {
            try {
                this.passWarningsToListener(xsltc.getWarnings());
            }
            catch (TransformerException e) {
                throw new TransformerConfigurationException(e);
            }
        } else {
            xsltc.printWarnings();
        }
        if (bytecodes == null) {
            List<ErrorMsg> errs = xsltc.getErrors();
            ErrorMsg err = errs != null ? errs.get(errs.size() - 1) : new ErrorMsg("JAXP_COMPILE_ERR");
            Throwable cause = err.getCause();
            TransformerConfigurationException exc = cause != null ? new TransformerConfigurationException(cause.getMessage(), cause) : new TransformerConfigurationException(err.toString());
            if (this._errorListener != null) {
                this.passErrorsToListener(xsltc.getErrors());
                try {
                    this._errorListener.fatalError(exc);
                }
                catch (TransformerException transformerException) {}
            } else {
                xsltc.printErrors();
            }
            throw exc;
        }
        TemplatesImpl templates = new TemplatesImpl(bytecodes, transletName, xsltc.getOutputProperties(), this._indentNumber, this);
        if (this._uriResolver != null) {
            templates.setURIResolver(this._uriResolver);
        }
        return templates;
    }

    @Override
    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        this.buildCatalogFeatures();
        TemplatesHandlerImpl handler = new TemplatesHandlerImpl(this._indentNumber, this, this._hasUserErrListener);
        if (this._uriResolver != null) {
            handler.setURIResolver(this._uriResolver);
        }
        return handler;
    }

    @Override
    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer();
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    @Override
    public TransformerHandler newTransformerHandler(Source src) throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer(src);
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    @Override
    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        TransformerImpl internal = (TransformerImpl)transformer;
        return new TransformerHandlerImpl(internal);
    }

    @Override
    public XMLFilter newXMLFilter(Source src) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(src);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    @Override
    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException e1) {
            if (this._errorListener != null) {
                try {
                    this._errorListener.fatalError(e1);
                    return null;
                }
                catch (TransformerException e2) {
                    throw new TransformerConfigurationException(e2);
                }
            }
            throw e1;
        }
    }

    @Override
    public InputSource loadSource(String href, String context, XSLTC xsltc) {
        try {
            Source source = null;
            if (this._uriResolver != null) {
                source = this._uriResolver.resolve(href, context);
            }
            if (source == null && this._catalogFiles != null && this._xmlFeatures.getFeature(JdkXmlFeatures.XmlFeature.USE_CATALOG)) {
                if (this._catalogUriResolver == null) {
                    this._catalogUriResolver = CatalogManager.catalogResolver(this._catalogFeatures, new URI[0]);
                }
                source = this._catalogUriResolver.resolve(href, context);
            }
            if (source != null) {
                return Util.getInputSource(xsltc, source);
            }
        }
        catch (TransformerException e) {
            ErrorMsg msg = new ErrorMsg("INVALID_URI_ERR", (Object)(href + "\n" + e.getMessage()), (Object)this);
            xsltc.getParser().reportError(2, msg);
        }
        catch (CatalogException e) {
            ErrorMsg msg = new ErrorMsg("CATALOG_EXCEPTION", (Object)(href + "\n" + e.getMessage()), (Object)this);
            xsltc.getParser().reportError(2, msg);
        }
        return null;
    }

    private CatalogFeatures buildCatalogFeatures() {
        if (this._catalogFeatures == null) {
            this._catalogFeatures = this.cfBuilder.build();
        }
        this._catalogFiles = this._catalogFeatures.get(CatalogFeatures.Feature.FILES);
        this._catalogDefer = this._catalogFeatures.get(CatalogFeatures.Feature.DEFER);
        this._catalogPrefer = this._catalogFeatures.get(CatalogFeatures.Feature.PREFER);
        this._catalogResolve = this._catalogFeatures.get(CatalogFeatures.Feature.RESOLVE);
        return this._catalogFeatures;
    }

    private void resetTransientAttributes() {
        this._transletName = DEFAULT_TRANSLET_NAME;
        this._destinationDirectory = null;
        this._packageName = DEFAULT_TRANSLATE_PACKAGE;
        this._jarFileName = null;
    }

    private byte[][] getBytecodesFromClasses(Source source, String fullClassName) {
        byte[] bytes;
        int lastDotIndex;
        if (fullClassName == null) {
            return null;
        }
        String xslFileName = this.getStylesheetFileName(source);
        File xslFile = null;
        if (xslFileName != null) {
            xslFile = new File(xslFileName);
        }
        String transletName = (lastDotIndex = fullClassName.lastIndexOf(46)) > 0 ? fullClassName.substring(lastDotIndex + 1) : fullClassName;
        String transletPath = fullClassName.replace('.', '/');
        transletPath = this._destinationDirectory != null ? this._destinationDirectory + "/" + transletPath + ".class" : (xslFile != null && xslFile.getParent() != null ? xslFile.getParent() + "/" + transletPath + ".class" : transletPath + ".class");
        File transletFile = new File(transletPath);
        if (!transletFile.exists()) {
            return null;
        }
        if (xslFile != null && xslFile.exists()) {
            long xslTimestamp = xslFile.lastModified();
            long transletTimestamp = transletFile.lastModified();
            if (transletTimestamp < xslTimestamp) {
                return null;
            }
        }
        ArrayList<byte[]> bytecodes = new ArrayList<byte[]>();
        int fileLength = (int)transletFile.length();
        if (fileLength > 0) {
            FileInputStream input;
            try {
                input = new FileInputStream(transletFile);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            bytes = new byte[fileLength];
            try {
                this.readFromInputStream(bytes, input, fileLength);
                input.close();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
        bytecodes.add(bytes);
        String transletParentDir = transletFile.getParent();
        if (transletParentDir == null) {
            transletParentDir = SecuritySupport.getSystemProperty("user.dir");
        }
        File transletParentFile = new File(transletParentDir);
        final String transletAuxPrefix = transletName + "$";
        File[] auxfiles = transletParentFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class") && name.startsWith(transletAuxPrefix);
            }
        });
        for (int i = 0; i < auxfiles.length; ++i) {
            File auxfile = auxfiles[i];
            int auxlength = (int)auxfile.length();
            if (auxlength <= 0) continue;
            FileInputStream auxinput = null;
            try {
                auxinput = new FileInputStream(auxfile);
            }
            catch (FileNotFoundException e) {
                continue;
            }
            byte[] bytes2 = new byte[auxlength];
            try {
                this.readFromInputStream(bytes2, auxinput, auxlength);
                auxinput.close();
            }
            catch (IOException e) {
                continue;
            }
            bytecodes.add(bytes2);
        }
        int count = bytecodes.size();
        if (count > 0) {
            byte[][] result = new byte[count][1];
            for (int i = 0; i < count; ++i) {
                result[i] = (byte[])bytecodes.get(i);
            }
            return result;
        }
        return null;
    }

    private byte[][] getBytecodesFromJar(Source source, String fullClassName) {
        ZipFile jarFile;
        String jarPath;
        File file;
        String xslFileName = this.getStylesheetFileName(source);
        File xslFile = null;
        if (xslFileName != null) {
            xslFile = new File(xslFileName);
        }
        if (!(file = new File(jarPath = this._destinationDirectory != null ? this._destinationDirectory + "/" + this._jarFileName : (xslFile != null && xslFile.getParent() != null ? xslFile.getParent() + "/" + this._jarFileName : this._jarFileName))).exists()) {
            return null;
        }
        if (xslFile != null && xslFile.exists()) {
            long xslTimestamp = xslFile.lastModified();
            long transletTimestamp = file.lastModified();
            if (transletTimestamp < xslTimestamp) {
                return null;
            }
        }
        try {
            jarFile = new ZipFile(file);
        }
        catch (IOException e) {
            return null;
        }
        String transletPath = fullClassName.replace('.', '/');
        String transletAuxPrefix = transletPath + "$";
        String transletFullName = transletPath + ".class";
        ArrayList<byte[]> bytecodes = new ArrayList<byte[]>();
        Enumeration<? extends ZipEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (entry.getSize() <= 0L || !entryName.equals(transletFullName) && (!entryName.endsWith(".class") || !entryName.startsWith(transletAuxPrefix))) continue;
            try {
                InputStream input = jarFile.getInputStream(entry);
                int size = (int)entry.getSize();
                byte[] bytes = new byte[size];
                this.readFromInputStream(bytes, input, size);
                input.close();
                bytecodes.add(bytes);
            }
            catch (IOException e) {
                return null;
            }
        }
        int count = bytecodes.size();
        if (count > 0) {
            byte[][] result = new byte[count][1];
            for (int i = 0; i < count; ++i) {
                result[i] = (byte[])bytecodes.get(i);
            }
            return result;
        }
        return null;
    }

    private void readFromInputStream(byte[] bytes, InputStream input, int size) throws IOException {
        int n = 0;
        int offset = 0;
        for (int length = size; length > 0 && (n = input.read(bytes, offset, length)) > 0; length -= n) {
            offset += n;
        }
    }

    private String getTransletBaseName(Source source) {
        String baseName;
        String transletBaseName = null;
        if (!this._transletName.equals(DEFAULT_TRANSLET_NAME)) {
            return this._transletName;
        }
        String systemId = source.getSystemId();
        if (systemId != null && (baseName = Util.baseName(systemId)) != null) {
            baseName = Util.noExtName(baseName);
            transletBaseName = Util.toJavaName(baseName);
        }
        return transletBaseName != null ? transletBaseName : DEFAULT_TRANSLET_NAME;
    }

    private String getStylesheetFileName(Source source) {
        String systemId = source.getSystemId();
        if (systemId != null) {
            URL url;
            File file = new File(systemId);
            if (file.exists()) {
                return systemId;
            }
            try {
                url = new URL(systemId);
            }
            catch (MalformedURLException e) {
                return null;
            }
            if ("file".equals(url.getProtocol())) {
                return url.getFile();
            }
            return null;
        }
        return null;
    }

    protected final XSLTCDTMManager createNewDTMManagerInstance() {
        return XSLTCDTMManager.createNewDTMManagerInstance();
    }

    private static class PIParamWrapper {
        public String _media = null;
        public String _title = null;
        public String _charset = null;

        public PIParamWrapper(String media, String title, String charset) {
            this._media = media;
            this._title = title;
            this._charset = charset;
        }
    }
}

