/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.trax;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAX2StAXBaseWriter
extends DefaultHandler
implements LexicalHandler {
    protected boolean isCDATA;
    protected StringBuffer CDATABuffer;
    protected List<String> namespaces;
    protected Locator docLocator;
    protected XMLReporter reporter;
    String xmlVersion = null;
    String encoding = null;

    public SAX2StAXBaseWriter() {
    }

    public SAX2StAXBaseWriter(XMLReporter reporter) {
        this.reporter = reporter;
    }

    public void setXMLReporter(XMLReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
    }

    private void updateVersionAndEncoding() {
        if (this.docLocator instanceof Locator2) {
            Locator2 l2 = (Locator2)this.docLocator;
            this.xmlVersion = l2.getXMLVersion();
            this.encoding = l2.getEncoding();
        }
    }

    public void setXmlVersion(String version) {
        this.xmlVersion = version;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    void writeStartDocument() throws SAXException {
        this.updateVersionAndEncoding();
    }

    public Location getCurrentLocation() {
        if (this.docLocator != null) {
            return new SAXLocation(this.docLocator);
        }
        return null;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.reportException("ERROR", e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.reportException("FATAL", e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.reportException("WARNING", e);
    }

    @Override
    public void startDocument() throws SAXException {
        this.namespaces = new ArrayList<String>(2);
    }

    @Override
    public void endDocument() throws SAXException {
        this.namespaces = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.namespaces = null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.namespaces = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix == null) {
            prefix = "";
        } else if (prefix.equals("xml")) {
            return;
        }
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>(2);
        }
        this.namespaces.add(prefix);
        this.namespaces.add(uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.isCDATA = true;
        if (this.CDATABuffer == null) {
            this.CDATABuffer = new StringBuffer();
        } else {
            this.CDATABuffer.setLength(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isCDATA) {
            this.CDATABuffer.append(ch, start, length);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        this.isCDATA = false;
        this.CDATABuffer.setLength(0);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    protected void reportException(String type, SAXException e) throws SAXException {
        if (this.reporter != null) {
            try {
                this.reporter.report(e.getMessage(), type, e, this.getCurrentLocation());
            }
            catch (XMLStreamException e1) {
                throw new SAXException(e1);
            }
        }
    }

    public static final void parseQName(String qName, String[] results) {
        String local;
        String prefix;
        int idx = qName.indexOf(58);
        if (idx >= 0) {
            prefix = qName.substring(0, idx);
            local = qName.substring(idx + 1);
        } else {
            prefix = "";
            local = qName;
        }
        results[0] = prefix;
        results[1] = local;
    }

    private static final class SAXLocation
    implements Location {
        private int lineNumber;
        private int columnNumber;
        private String publicId;
        private String systemId;

        private SAXLocation(Locator locator) {
            this.lineNumber = locator.getLineNumber();
            this.columnNumber = locator.getColumnNumber();
            this.publicId = locator.getPublicId();
            this.systemId = locator.getSystemId();
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getColumnNumber() {
            return this.columnNumber;
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }
    }
}

