/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler.util;

import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.BranchHandle;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.DLOAD;
import com.sun.org.apache.bcel.internal.generic.DSTORE;
import com.sun.org.apache.bcel.internal.generic.FLOAD;
import com.sun.org.apache.bcel.internal.generic.FSTORE;
import com.sun.org.apache.bcel.internal.generic.GETFIELD;
import com.sun.org.apache.bcel.internal.generic.GOTO;
import com.sun.org.apache.bcel.internal.generic.ICONST;
import com.sun.org.apache.bcel.internal.generic.ILOAD;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.INVOKESTATIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.ISTORE;
import com.sun.org.apache.bcel.internal.generic.IfInstruction;
import com.sun.org.apache.bcel.internal.generic.IndexedInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionConst;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.LLOAD;
import com.sun.org.apache.bcel.internal.generic.LSTORE;
import com.sun.org.apache.bcel.internal.generic.LocalVariableGen;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.bcel.internal.generic.PUTFIELD;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.TargetLostException;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Constants;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Pattern;
import com.sun.org.apache.xalan.internal.xsltc.compiler.XSLTC;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.InternalError;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MarkerInstruction;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ObjectType;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.OutlineableChunkEnd;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.OutlineableChunkStart;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.SlotAllocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class MethodGenerator
extends MethodGen
implements Constants {
    protected static final int INVALID_INDEX = -1;
    private static final String START_ELEMENT_SIG = "(Ljava/lang/String;)V";
    private static final String END_ELEMENT_SIG = "(Ljava/lang/String;)V";
    private static final int DOM_INDEX = 1;
    private static final int ITERATOR_INDEX = 2;
    private static final int HANDLER_INDEX = 3;
    private static final int MAX_METHOD_SIZE = 65535;
    private static final int MAX_BRANCH_TARGET_OFFSET = Short.MAX_VALUE;
    private static final int MIN_BRANCH_TARGET_OFFSET = Short.MIN_VALUE;
    private static final int TARGET_METHOD_SIZE = 60000;
    private static final int MINIMUM_OUTLINEABLE_CHUNK_SIZE = 1000;
    private Instruction _iloadCurrent;
    private Instruction _istoreCurrent;
    private final Instruction _astoreHandler;
    private final Instruction _aloadHandler;
    private final Instruction _astoreIterator;
    private final Instruction _aloadIterator;
    private final Instruction _aloadDom;
    private final Instruction _astoreDom;
    private final Instruction _startElement;
    private final Instruction _endElement;
    private final Instruction _startDocument;
    private final Instruction _endDocument;
    private final Instruction _attribute;
    private final Instruction _uniqueAttribute;
    private final Instruction _namespace;
    private final Instruction _setStartNode;
    private final Instruction _reset;
    private final Instruction _nextNode;
    private SlotAllocator _slotAllocator;
    private boolean _allocatorInit = false;
    private LocalVariableRegistry _localVariableRegistry;
    private Map<Pattern, InstructionList> _preCompiled = new HashMap<Pattern, InstructionList>();
    private int m_totalChunks = 0;
    private int m_openChunks = 0;

    public MethodGenerator(int access_flags, Type return_type, Type[] arg_types, String[] arg_names, String method_name, String class_name, InstructionList il, ConstantPoolGen cpg) {
        super(access_flags, return_type, arg_types, arg_names, method_name, class_name, il, cpg);
        this._astoreHandler = new ASTORE(3);
        this._aloadHandler = new ALOAD(3);
        this._astoreIterator = new ASTORE(2);
        this._aloadIterator = new ALOAD(2);
        this._aloadDom = new ALOAD(1);
        this._astoreDom = new ASTORE(1);
        int startElement = cpg.addInterfaceMethodref("com.sun.org.apache.xml.internal.serializer.SerializationHandler", "startElement", "(Ljava/lang/String;)V");
        this._startElement = new INVOKEINTERFACE(startElement, 2);
        int endElement = cpg.addInterfaceMethodref("com.sun.org.apache.xml.internal.serializer.SerializationHandler", "endElement", "(Ljava/lang/String;)V");
        this._endElement = new INVOKEINTERFACE(endElement, 2);
        int attribute = cpg.addInterfaceMethodref("com.sun.org.apache.xml.internal.serializer.SerializationHandler", "addAttribute", "(Ljava/lang/String;Ljava/lang/String;)V");
        this._attribute = new INVOKEINTERFACE(attribute, 3);
        int uniqueAttribute = cpg.addInterfaceMethodref("com.sun.org.apache.xml.internal.serializer.SerializationHandler", "addUniqueAttribute", "(Ljava/lang/String;Ljava/lang/String;I)V");
        this._uniqueAttribute = new INVOKEINTERFACE(uniqueAttribute, 4);
        int namespace = cpg.addInterfaceMethodref("com.sun.org.apache.xml.internal.serializer.SerializationHandler", "namespaceAfterStartElement", "(Ljava/lang/String;Ljava/lang/String;)V");
        this._namespace = new INVOKEINTERFACE(namespace, 3);
        int index = cpg.addInterfaceMethodref("com.sun.org.apache.xml.internal.serializer.SerializationHandler", "startDocument", "()V");
        this._startDocument = new INVOKEINTERFACE(index, 1);
        index = cpg.addInterfaceMethodref("com.sun.org.apache.xml.internal.serializer.SerializationHandler", "endDocument", "()V");
        this._endDocument = new INVOKEINTERFACE(index, 1);
        index = cpg.addInterfaceMethodref("com.sun.org.apache.xml.internal.dtm.DTMAxisIterator", "setStartNode", "(I)Lcom/sun/org/apache/xml/internal/dtm/DTMAxisIterator;");
        this._setStartNode = new INVOKEINTERFACE(index, 2);
        index = cpg.addInterfaceMethodref("com.sun.org.apache.xml.internal.dtm.DTMAxisIterator", "reset", "()Lcom/sun/org/apache/xml/internal/dtm/DTMAxisIterator;");
        this._reset = new INVOKEINTERFACE(index, 1);
        index = cpg.addInterfaceMethodref("com.sun.org.apache.xml.internal.dtm.DTMAxisIterator", "next", "()I");
        this._nextNode = new INVOKEINTERFACE(index, 1);
        this._slotAllocator = new SlotAllocator();
        this._slotAllocator.initialize(this.getLocalVariableRegistry().getLocals());
        this._allocatorInit = true;
    }

    @Override
    public LocalVariableGen addLocalVariable(String name, Type type, InstructionHandle start, InstructionHandle end) {
        LocalVariableGen lvg;
        if (this._allocatorInit) {
            lvg = this.addLocalVariable2(name, type, start);
        } else {
            lvg = super.addLocalVariable(name, type, start, end);
            this.getLocalVariableRegistry().registerLocalVariable(lvg);
        }
        return lvg;
    }

    public LocalVariableGen addLocalVariable2(String name, Type type, InstructionHandle start) {
        LocalVariableGen lvg = super.addLocalVariable(name, type, this._slotAllocator.allocateSlot(type), start, null);
        this.getLocalVariableRegistry().registerLocalVariable(lvg);
        return lvg;
    }

    private LocalVariableRegistry getLocalVariableRegistry() {
        if (this._localVariableRegistry == null) {
            this._localVariableRegistry = new LocalVariableRegistry();
        }
        return this._localVariableRegistry;
    }

    boolean offsetInLocalVariableGenRange(LocalVariableGen lvg, int offset) {
        InstructionHandle lvgStart = lvg.getStart();
        InstructionHandle lvgEnd = lvg.getEnd();
        if (lvgStart == null) {
            lvgStart = this.getInstructionList().getStart();
        }
        if (lvgEnd == null) {
            lvgEnd = this.getInstructionList().getEnd();
        }
        return lvgStart.getPosition() <= offset && lvgEnd.getPosition() + lvgEnd.getInstruction().getLength() >= offset;
    }

    @Override
    public void removeLocalVariable(LocalVariableGen lvg) {
        this._slotAllocator.releaseSlot(lvg);
        this.getLocalVariableRegistry().removeByNameTracking(lvg);
        super.removeLocalVariable(lvg);
    }

    public Instruction loadDOM() {
        return this._aloadDom;
    }

    public Instruction storeDOM() {
        return this._astoreDom;
    }

    public Instruction storeHandler() {
        return this._astoreHandler;
    }

    public Instruction loadHandler() {
        return this._aloadHandler;
    }

    public Instruction storeIterator() {
        return this._astoreIterator;
    }

    public Instruction loadIterator() {
        return this._aloadIterator;
    }

    public final Instruction setStartNode() {
        return this._setStartNode;
    }

    public final Instruction reset() {
        return this._reset;
    }

    public final Instruction nextNode() {
        return this._nextNode;
    }

    public final Instruction startElement() {
        return this._startElement;
    }

    public final Instruction endElement() {
        return this._endElement;
    }

    public final Instruction startDocument() {
        return this._startDocument;
    }

    public final Instruction endDocument() {
        return this._endDocument;
    }

    public final Instruction attribute() {
        return this._attribute;
    }

    public final Instruction uniqueAttribute() {
        return this._uniqueAttribute;
    }

    public final Instruction namespace() {
        return this._namespace;
    }

    public Instruction loadCurrentNode() {
        if (this._iloadCurrent == null) {
            int idx = this.getLocalIndex("current");
            this._iloadCurrent = idx > 0 ? new ILOAD(idx) : new ICONST(0);
        }
        return this._iloadCurrent;
    }

    public Instruction storeCurrentNode() {
        return this._istoreCurrent != null ? this._istoreCurrent : (this._istoreCurrent = new ISTORE(this.getLocalIndex("current")));
    }

    public Instruction loadContextNode() {
        return this.loadCurrentNode();
    }

    public Instruction storeContextNode() {
        return this.storeCurrentNode();
    }

    public int getLocalIndex(String name) {
        return this.getLocalVariable(name).getIndex();
    }

    public LocalVariableGen getLocalVariable(String name) {
        return this.getLocalVariableRegistry().lookUpByName(name);
    }

    @Override
    public void setMaxLocals() {
        int maxLocals;
        int prevLocals = maxLocals = super.getMaxLocals();
        LocalVariableGen[] localVars = super.getLocalVariables();
        if (localVars != null && localVars.length > maxLocals) {
            maxLocals = localVars.length;
        }
        if (maxLocals < 5) {
            maxLocals = 5;
        }
        super.setMaxLocals(maxLocals);
    }

    public void addInstructionList(Pattern pattern, InstructionList ilist) {
        this._preCompiled.put(pattern, ilist);
    }

    public InstructionList getInstructionList(Pattern pattern) {
        return this._preCompiled.get(pattern);
    }

    private List<Chunk> getCandidateChunks(ClassGenerator classGen, int totalMethodSize) {
        InstructionHandle currentHandle;
        Iterator<InstructionHandle> instructions = this.getInstructionList().iterator();
        ArrayList<Chunk> candidateChunks = new ArrayList<Chunk>();
        List<InstructionHandle> currLevelChunks = new ArrayList<InstructionHandle>();
        Stack<ArrayList<InstructionHandle>> subChunkStack = new Stack<ArrayList<InstructionHandle>>();
        boolean openChunkAtCurrLevel = false;
        boolean firstInstruction = true;
        if (this.m_openChunks != 0) {
            String msg = new ErrorMsg("OUTLINE_ERR_UNBALANCED_MARKERS").toString();
            throw new InternalError(msg);
        }
        do {
            InstructionHandle chunkStart;
            int chunkEndPosition;
            int chunkSize;
            Instruction inst;
            currentHandle = instructions.hasNext() ? instructions.next() : null;
            Instruction instruction = inst = currentHandle != null ? currentHandle.getInstruction() : null;
            if (firstInstruction) {
                openChunkAtCurrLevel = true;
                currLevelChunks.add(currentHandle);
                firstInstruction = false;
            }
            if (inst instanceof OutlineableChunkStart) {
                if (openChunkAtCurrLevel) {
                    subChunkStack.push((ArrayList<InstructionHandle>)currLevelChunks);
                    currLevelChunks = new ArrayList();
                }
                openChunkAtCurrLevel = true;
                currLevelChunks.add(currentHandle);
                continue;
            }
            if (currentHandle != null && !(inst instanceof OutlineableChunkEnd)) continue;
            ArrayList<InstructionHandle> nestedSubChunks = null;
            if (!openChunkAtCurrLevel) {
                nestedSubChunks = currLevelChunks;
                currLevelChunks = (List)subChunkStack.pop();
            }
            if ((chunkSize = (chunkEndPosition = currentHandle != null ? currentHandle.getPosition() : totalMethodSize) - (chunkStart = (InstructionHandle)currLevelChunks.get(currLevelChunks.size() - 1)).getPosition()) <= 60000) {
                currLevelChunks.add(currentHandle);
            } else {
                int childChunkCount;
                if (!openChunkAtCurrLevel && (childChunkCount = nestedSubChunks.size() / 2) > 0) {
                    Chunk[] childChunks = new Chunk[childChunkCount];
                    for (int i = 0; i < childChunkCount; ++i) {
                        InstructionHandle start = (InstructionHandle)nestedSubChunks.get(i * 2);
                        InstructionHandle end = (InstructionHandle)nestedSubChunks.get(i * 2 + 1);
                        childChunks[i] = new Chunk(start, end);
                    }
                    List<Chunk> mergedChildChunks = this.mergeAdjacentChunks(childChunks);
                    for (Chunk mergedChunk : mergedChildChunks) {
                        int mergedSize = mergedChunk.getChunkSize();
                        if (mergedSize < 1000 || mergedSize > 60000) continue;
                        candidateChunks.add(mergedChunk);
                    }
                }
                currLevelChunks.remove(currLevelChunks.size() - 1);
            }
            boolean bl = openChunkAtCurrLevel = (currLevelChunks.size() & 1) == 1;
        } while (currentHandle != null);
        return candidateChunks;
    }

    private List<Chunk> mergeAdjacentChunks(Chunk[] chunks) {
        int i;
        int[] adjacencyRunStart = new int[chunks.length];
        int[] adjacencyRunLength = new int[chunks.length];
        boolean[] chunkWasMerged = new boolean[chunks.length];
        int maximumRunOfChunks = 0;
        int numAdjacentRuns = 0;
        ArrayList<Chunk> mergedChunks = new ArrayList<Chunk>();
        int startOfCurrentRun = 0;
        for (i = 1; i < chunks.length; ++i) {
            if (chunks[i - 1].isAdjacentTo(chunks[i])) continue;
            int lengthOfRun = i - startOfCurrentRun;
            if (maximumRunOfChunks < lengthOfRun) {
                maximumRunOfChunks = lengthOfRun;
            }
            if (lengthOfRun > 1) {
                adjacencyRunLength[numAdjacentRuns] = lengthOfRun;
                adjacencyRunStart[numAdjacentRuns] = startOfCurrentRun;
                ++numAdjacentRuns;
            }
            startOfCurrentRun = i;
        }
        if (chunks.length - startOfCurrentRun > 1) {
            int lengthOfRun = chunks.length - startOfCurrentRun;
            if (maximumRunOfChunks < lengthOfRun) {
                maximumRunOfChunks = lengthOfRun;
            }
            adjacencyRunLength[numAdjacentRuns] = chunks.length - startOfCurrentRun;
            adjacencyRunStart[numAdjacentRuns] = startOfCurrentRun;
            ++numAdjacentRuns;
        }
        for (int numToMerge = maximumRunOfChunks; numToMerge > 1; --numToMerge) {
            for (int run = 0; run < numAdjacentRuns; ++run) {
                int runStart = adjacencyRunStart[run];
                int runEnd = runStart + adjacencyRunLength[run] - 1;
                boolean foundChunksToMerge = false;
                int mergeStart = runStart;
                while (mergeStart + numToMerge - 1 <= runEnd && !foundChunksToMerge) {
                    int j;
                    int mergeEnd = mergeStart + numToMerge - 1;
                    int mergeSize = 0;
                    for (j = mergeStart; j <= mergeEnd; ++j) {
                        mergeSize += chunks[j].getChunkSize();
                    }
                    if (mergeSize <= 60000) {
                        foundChunksToMerge = true;
                        for (j = mergeStart; j <= mergeEnd; ++j) {
                            chunkWasMerged[j] = true;
                        }
                        mergedChunks.add(new Chunk(chunks[mergeStart].getChunkStart(), chunks[mergeEnd].getChunkEnd()));
                        adjacencyRunLength[run] = adjacencyRunStart[run] - mergeStart;
                        int trailingRunLength = runEnd - mergeEnd;
                        if (trailingRunLength >= 2) {
                            adjacencyRunStart[numAdjacentRuns] = mergeEnd + 1;
                            adjacencyRunLength[numAdjacentRuns] = trailingRunLength;
                            ++numAdjacentRuns;
                        }
                    }
                    ++mergeStart;
                }
            }
        }
        for (i = 0; i < chunks.length; ++i) {
            if (chunkWasMerged[i]) continue;
            mergedChunks.add(chunks[i]);
        }
        return mergedChunks;
    }

    public Method[] outlineChunks(ClassGenerator classGen, int originalMethodSize) {
        boolean moreMethodsOutlined;
        ArrayList<Method> methodsOutlined = new ArrayList<Method>();
        int currentMethodSize = originalMethodSize;
        int outlinedCount = 0;
        String originalMethodName = this.getName();
        if (originalMethodName.equals("<init>")) {
            originalMethodName = "$lt$init$gt$";
        } else if (originalMethodName.equals("<clinit>")) {
            originalMethodName = "$lt$clinit$gt$";
        }
        do {
            List<Chunk> candidateChunks = this.getCandidateChunks(classGen, currentMethodSize);
            Collections.sort(candidateChunks);
            moreMethodsOutlined = false;
            for (int i = candidateChunks.size() - 1; i >= 0 && currentMethodSize > 60000; --i) {
                Chunk chunkToOutline = candidateChunks.get(i);
                methodsOutlined.add(this.outline(chunkToOutline.getChunkStart(), chunkToOutline.getChunkEnd(), originalMethodName + "$outline$" + outlinedCount, classGen));
                ++outlinedCount;
                moreMethodsOutlined = true;
                InstructionList il = this.getInstructionList();
                InstructionHandle lastInst = il.getEnd();
                il.setPositions();
                currentMethodSize = lastInst.getPosition() + lastInst.getInstruction().getLength();
            }
        } while (moreMethodsOutlined && currentMethodSize > 60000);
        if (currentMethodSize > 65535) {
            String msg = new ErrorMsg("OUTLINE_ERR_METHOD_TOO_BIG").toString();
            throw new InternalError(msg);
        }
        Method[] methodsArr = new Method[methodsOutlined.size() + 1];
        methodsOutlined.toArray(methodsArr);
        methodsArr[methodsOutlined.size()] = this.getThisMethod();
        return methodsArr;
    }

    private Method outline(InstructionHandle first, InstructionHandle last, String outlinedMethodName, ClassGenerator classGen) {
        String varName;
        InstructionHandle ih;
        InstructionHandle outlinedMethodRef;
        boolean isStaticMethod;
        if (this.getExceptionHandlers().length != 0) {
            String msg = new ErrorMsg("OUTLINE_ERR_TRY_CATCH").toString();
            throw new InternalError(msg);
        }
        int outlineChunkStartOffset = first.getPosition();
        int outlineChunkEndOffset = last.getPosition() + last.getInstruction().getLength();
        ConstantPoolGen cpg = this.getConstantPool();
        InstructionList newIL = new InstructionList();
        XSLTC xsltc = classGen.getParser().getXSLTC();
        String argTypeName = xsltc.getHelperClassName();
        Type[] argTypes = new Type[]{new ObjectType(argTypeName).toJCType()};
        String argName = "copyLocals";
        String[] argNames = new String[]{"copyLocals"};
        int methodAttributes = 18;
        boolean bl = isStaticMethod = (this.getAccessFlags() & 8) != 0;
        if (isStaticMethod) {
            methodAttributes |= 8;
        }
        MethodGenerator outlinedMethodGen = new MethodGenerator(methodAttributes, Type.VOID, argTypes, argNames, outlinedMethodName, this.getClassName(), newIL, cpg);
        ClassGenerator copyAreaCG = new ClassGenerator(argTypeName, "java.lang.Object", argTypeName + ".java", 49, null, classGen.getStylesheet()){

            @Override
            public boolean isExternal() {
                return true;
            }
        };
        ConstantPoolGen copyAreaCPG = copyAreaCG.getConstantPool();
        copyAreaCG.addEmptyConstructor(1);
        int copyAreaFieldCount = 0;
        InstructionHandle limit = last.getNext();
        InstructionList oldMethCopyInIL = new InstructionList();
        InstructionList oldMethCopyOutIL = new InstructionList();
        InstructionList newMethCopyInIL = new InstructionList();
        InstructionList newMethCopyOutIL = new InstructionList();
        InstructionHandle outlinedMethodCallSetup = oldMethCopyInIL.append(new NEW(cpg.addClass(argTypeName)));
        oldMethCopyInIL.append(InstructionConst.DUP);
        oldMethCopyInIL.append(InstructionConst.DUP);
        oldMethCopyInIL.append(new INVOKESPECIAL(cpg.addMethodref(argTypeName, "<init>", "()V")));
        if (isStaticMethod) {
            outlinedMethodRef = oldMethCopyOutIL.append(new INVOKESTATIC(cpg.addMethodref(classGen.getClassName(), outlinedMethodName, outlinedMethodGen.getSignature())));
        } else {
            oldMethCopyOutIL.append(InstructionConst.THIS);
            oldMethCopyOutIL.append(InstructionConst.SWAP);
            outlinedMethodRef = oldMethCopyOutIL.append(new INVOKEVIRTUAL(cpg.addMethodref(classGen.getClassName(), outlinedMethodName, outlinedMethodGen.getSignature())));
        }
        boolean chunkStartTargetMappingsPending = false;
        InstructionHandle pendingTargetMappingHandle = null;
        InstructionHandle lastCopyHandle = null;
        HashMap<InstructionHandle, InstructionHandle> targetMap = new HashMap<InstructionHandle, InstructionHandle>();
        HashMap<LocalVariableGen, LocalVariableGen> localVarMap = new HashMap<LocalVariableGen, LocalVariableGen>();
        LinkedHashMap<LocalVariableGen, InstructionHandle> revisedLocalVarStart = new LinkedHashMap<LocalVariableGen, InstructionHandle>();
        LinkedHashMap<LocalVariableGen, InstructionHandle> revisedLocalVarEnd = new LinkedHashMap<LocalVariableGen, InstructionHandle>();
        for (ih = first; ih != limit; ih = ih.getNext()) {
            Instruction inst = ih.getInstruction();
            if (inst instanceof MarkerInstruction) {
                if (!ih.hasTargeters()) continue;
                if (inst instanceof OutlineableChunkEnd) {
                    targetMap.put(ih, lastCopyHandle);
                    continue;
                }
                if (chunkStartTargetMappingsPending) continue;
                chunkStartTargetMappingsPending = true;
                pendingTargetMappingHandle = ih;
                continue;
            }
            Instruction c = inst.copy();
            lastCopyHandle = c instanceof BranchInstruction ? newIL.append((BranchInstruction)c) : newIL.append(c);
            if (c instanceof LocalVariableInstruction || c instanceof RET) {
                IndexedInstruction indexedInstruction = (IndexedInstruction)((Object)c);
                int oldLocalVarIndex = indexedInstruction.getIndex();
                LocalVariableGen oldLVG = this.getLocalVariableRegistry().lookupRegisteredLocalVariable(oldLocalVarIndex, ih.getPosition());
                LocalVariableGen newLVG = (LocalVariableGen)localVarMap.get(oldLVG);
                if (localVarMap.get(oldLVG) == null) {
                    boolean copyInLocalValue = this.offsetInLocalVariableGenRange(oldLVG, outlineChunkStartOffset != 0 ? outlineChunkStartOffset - 1 : 0);
                    boolean copyOutLocalValue = this.offsetInLocalVariableGenRange(oldLVG, outlineChunkEndOffset + 1);
                    if (copyInLocalValue || copyOutLocalValue) {
                        varName = oldLVG.getName();
                        Type varType = oldLVG.getType();
                        newLVG = outlinedMethodGen.addLocalVariable(varName, varType, null, null);
                        int newLocalVarIndex = newLVG.getIndex();
                        String varSignature = varType.getSignature();
                        localVarMap.put(oldLVG, newLVG);
                        String copyAreaFieldName = "field" + ++copyAreaFieldCount;
                        copyAreaCG.addField(new Field(1, copyAreaCPG.addUtf8(copyAreaFieldName), copyAreaCPG.addUtf8(varSignature), null, copyAreaCPG.getConstantPool()));
                        int fieldRef = cpg.addFieldref(argTypeName, copyAreaFieldName, varSignature);
                        if (copyInLocalValue) {
                            oldMethCopyInIL.append(InstructionConst.DUP);
                            InstructionHandle copyInLoad = oldMethCopyInIL.append(MethodGenerator.loadLocal(oldLocalVarIndex, varType));
                            oldMethCopyInIL.append(new PUTFIELD(fieldRef));
                            if (!copyOutLocalValue) {
                                revisedLocalVarEnd.put(oldLVG, copyInLoad);
                            }
                            newMethCopyInIL.append(InstructionConst.ALOAD_1);
                            newMethCopyInIL.append(new GETFIELD(fieldRef));
                            newMethCopyInIL.append(MethodGenerator.storeLocal(newLocalVarIndex, varType));
                        }
                        if (copyOutLocalValue) {
                            newMethCopyOutIL.append(InstructionConst.ALOAD_1);
                            newMethCopyOutIL.append(MethodGenerator.loadLocal(newLocalVarIndex, varType));
                            newMethCopyOutIL.append(new PUTFIELD(fieldRef));
                            oldMethCopyOutIL.append(InstructionConst.DUP);
                            oldMethCopyOutIL.append(new GETFIELD(fieldRef));
                            InstructionHandle copyOutStore = oldMethCopyOutIL.append(MethodGenerator.storeLocal(oldLocalVarIndex, varType));
                            if (!copyInLocalValue) {
                                revisedLocalVarStart.put(oldLVG, copyOutStore);
                            }
                        }
                    }
                }
            }
            if (ih.hasTargeters()) {
                targetMap.put(ih, lastCopyHandle);
            }
            if (!chunkStartTargetMappingsPending) continue;
            do {
                targetMap.put(pendingTargetMappingHandle, lastCopyHandle);
            } while ((pendingTargetMappingHandle = pendingTargetMappingHandle.getNext()) != ih);
            chunkStartTargetMappingsPending = false;
        }
        ih = first;
        InstructionHandle ch = newIL.getStart();
        while (ch != null) {
            Iterator i = ih.getInstruction();
            Instruction instruction = ch.getInstruction();
            if (i instanceof BranchInstruction) {
                BranchInstruction bc = (BranchInstruction)instruction;
                BranchInstruction bi = (BranchInstruction)((Object)i);
                InstructionHandle itarget = bi.getTarget();
                InstructionHandle newTarget = (InstructionHandle)targetMap.get(itarget);
                bc.setTarget(newTarget);
                if (bi instanceof Select) {
                    InstructionHandle[] itargets = ((Select)bi).getTargets();
                    InstructionHandle[] ctargets = ((Select)bc).getTargets();
                    for (int j = 0; j < itargets.length; ++j) {
                        ctargets[j] = (InstructionHandle)targetMap.get(itargets[j]);
                    }
                }
            } else if (i instanceof LocalVariableInstruction || i instanceof RET) {
                int newLocalVarIndex;
                IndexedInstruction lvi = (IndexedInstruction)((Object)instruction);
                int oldLocalVarIndex = lvi.getIndex();
                LocalVariableGen oldLVG = this.getLocalVariableRegistry().lookupRegisteredLocalVariable(oldLocalVarIndex, ih.getPosition());
                LocalVariableGen newLVG = (LocalVariableGen)localVarMap.get(oldLVG);
                if (newLVG == null) {
                    varName = oldLVG.getName();
                    Type varType = oldLVG.getType();
                    newLVG = outlinedMethodGen.addLocalVariable(varName, varType, null, null);
                    newLocalVarIndex = newLVG.getIndex();
                    localVarMap.put(oldLVG, newLVG);
                    revisedLocalVarStart.put(oldLVG, outlinedMethodRef);
                    revisedLocalVarEnd.put(oldLVG, outlinedMethodRef);
                } else {
                    newLocalVarIndex = newLVG.getIndex();
                }
                lvi.setIndex(newLocalVarIndex);
            }
            if (ih.hasTargeters()) {
                InstructionTargeter[] targeters = ih.getTargeters();
                for (int idx = 0; idx < targeters.length; ++idx) {
                    LocalVariableGen newLVG;
                    InstructionTargeter targeter = targeters[idx];
                    if (!(targeter instanceof LocalVariableGen) || ((LocalVariableGen)targeter).getEnd() != ih || (newLVG = (LocalVariableGen)localVarMap.get(targeter)) == null) continue;
                    outlinedMethodGen.removeLocalVariable(newLVG);
                }
            }
            if (!(i instanceof MarkerInstruction)) {
                ch = ch.getNext();
            }
            ih = ih.getNext();
        }
        oldMethCopyOutIL.append(InstructionConst.POP);
        for (Map.Entry entry : ((HashMap)revisedLocalVarStart).entrySet()) {
            LocalVariableGen lvg = (LocalVariableGen)entry.getKey();
            InstructionHandle startInst = (InstructionHandle)entry.getValue();
            lvg.setStart(startInst);
        }
        for (Map.Entry entry : ((HashMap)revisedLocalVarEnd).entrySet()) {
            LocalVariableGen lvg = (LocalVariableGen)entry.getKey();
            InstructionHandle endInst = (InstructionHandle)entry.getValue();
            lvg.setEnd(endInst);
        }
        xsltc.dumpClass(copyAreaCG.getJavaClass());
        InstructionList oldMethodIL = this.getInstructionList();
        oldMethodIL.insert(first, oldMethCopyInIL);
        oldMethodIL.insert(first, oldMethCopyOutIL);
        newIL.insert(newMethCopyInIL);
        newIL.append(newMethCopyOutIL);
        newIL.append(InstructionConst.RETURN);
        try {
            oldMethodIL.delete(first, last);
        }
        catch (TargetLostException targetLostException) {
            InstructionHandle[] targets = targetLostException.getTargets();
            for (int i = 0; i < targets.length; ++i) {
                InstructionHandle lostTarget = targets[i];
                InstructionTargeter[] targeters = lostTarget.getTargeters();
                for (int j = 0; j < targeters.length; ++j) {
                    if (targeters[j] instanceof LocalVariableGen) {
                        LocalVariableGen lvgTargeter = (LocalVariableGen)targeters[j];
                        if (lvgTargeter.getStart() == lostTarget) {
                            lvgTargeter.setStart(outlinedMethodRef);
                        }
                        if (lvgTargeter.getEnd() != lostTarget) continue;
                        lvgTargeter.setEnd(outlinedMethodRef);
                        continue;
                    }
                    targeters[j].updateTarget(lostTarget, outlinedMethodCallSetup);
                }
            }
        }
        String[] stringArray = this.getExceptions();
        for (int i = 0; i < stringArray.length; ++i) {
            outlinedMethodGen.addException(stringArray[i]);
        }
        return outlinedMethodGen.getThisMethod();
    }

    private static Instruction loadLocal(int index, Type type) {
        if (type == Type.BOOLEAN) {
            return new ILOAD(index);
        }
        if (type == Type.INT) {
            return new ILOAD(index);
        }
        if (type == Type.SHORT) {
            return new ILOAD(index);
        }
        if (type == Type.LONG) {
            return new LLOAD(index);
        }
        if (type == Type.BYTE) {
            return new ILOAD(index);
        }
        if (type == Type.CHAR) {
            return new ILOAD(index);
        }
        if (type == Type.FLOAT) {
            return new FLOAD(index);
        }
        if (type == Type.DOUBLE) {
            return new DLOAD(index);
        }
        return new ALOAD(index);
    }

    private static Instruction storeLocal(int index, Type type) {
        if (type == Type.BOOLEAN) {
            return new ISTORE(index);
        }
        if (type == Type.INT) {
            return new ISTORE(index);
        }
        if (type == Type.SHORT) {
            return new ISTORE(index);
        }
        if (type == Type.LONG) {
            return new LSTORE(index);
        }
        if (type == Type.BYTE) {
            return new ISTORE(index);
        }
        if (type == Type.CHAR) {
            return new ISTORE(index);
        }
        if (type == Type.FLOAT) {
            return new FSTORE(index);
        }
        if (type == Type.DOUBLE) {
            return new DSTORE(index);
        }
        return new ASTORE(index);
    }

    public void markChunkStart() {
        this.getInstructionList().append(OutlineableChunkStart.OUTLINEABLECHUNKSTART);
        ++this.m_totalChunks;
        ++this.m_openChunks;
    }

    public void markChunkEnd() {
        this.getInstructionList().append(OutlineableChunkEnd.OUTLINEABLECHUNKEND);
        --this.m_openChunks;
        if (this.m_openChunks < 0) {
            String msg = new ErrorMsg("OUTLINE_ERR_UNBALANCED_MARKERS").toString();
            throw new InternalError(msg);
        }
    }

    Method[] getGeneratedMethods(ClassGenerator classGen) {
        boolean ilChanged;
        InstructionList il = this.getInstructionList();
        InstructionHandle last = il.getEnd();
        il.setPositions();
        int instructionListSize = last.getPosition() + last.getInstruction().getLength();
        if (instructionListSize > Short.MAX_VALUE && (ilChanged = this.widenConditionalBranchTargetOffsets())) {
            il.setPositions();
            last = il.getEnd();
            instructionListSize = last.getPosition() + last.getInstruction().getLength();
        }
        Method[] generatedMethods = instructionListSize > 65535 ? this.outlineChunks(classGen, instructionListSize) : new Method[]{this.getThisMethod()};
        return generatedMethods;
    }

    protected Method getThisMethod() {
        this.stripAttributes(true);
        this.setMaxLocals();
        this.setMaxStack();
        this.removeNOPs();
        return this.getMethod();
    }

    boolean widenConditionalBranchTargetOffsets() {
        Instruction inst;
        InstructionHandle ih;
        boolean ilChanged = false;
        int maxOffsetChange = 0;
        InstructionList il = this.getInstructionList();
        block7: for (ih = il.getStart(); ih != null; ih = ih.getNext()) {
            inst = ih.getInstruction();
            switch (inst.getOpcode()) {
                case 167: 
                case 168: {
                    maxOffsetChange += 2;
                    continue block7;
                }
                case 170: 
                case 171: {
                    maxOffsetChange += 3;
                    continue block7;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    maxOffsetChange += 5;
                }
            }
        }
        for (ih = il.getStart(); ih != null; ih = ih.getNext()) {
            inst = ih.getInstruction();
            if (!(inst instanceof IfInstruction)) continue;
            IfInstruction oldIfInst = (IfInstruction)inst;
            BranchHandle oldIfHandle = (BranchHandle)ih;
            InstructionHandle target = oldIfInst.getTarget();
            int relativeTargetOffset = target.getPosition() - oldIfHandle.getPosition();
            if (relativeTargetOffset - maxOffsetChange >= Short.MIN_VALUE && relativeTargetOffset + maxOffsetChange <= Short.MAX_VALUE) continue;
            InstructionHandle nextHandle = oldIfHandle.getNext();
            IfInstruction invertedIfInst = oldIfInst.negate();
            BranchHandle invertedIfHandle = il.append((InstructionHandle)oldIfHandle, invertedIfInst);
            BranchHandle gotoHandle = il.append((InstructionHandle)invertedIfHandle, new GOTO(target));
            if (nextHandle == null) {
                nextHandle = il.append((InstructionHandle)gotoHandle, InstructionConst.NOP);
            }
            invertedIfHandle.updateTarget(target, nextHandle);
            if (oldIfHandle.hasTargeters()) {
                InstructionTargeter[] targeters = oldIfHandle.getTargeters();
                for (int i = 0; i < targeters.length; ++i) {
                    InstructionTargeter targeter = targeters[i];
                    if (targeter instanceof LocalVariableGen) {
                        LocalVariableGen lvg = (LocalVariableGen)targeter;
                        if (lvg.getStart() == oldIfHandle) {
                            lvg.setStart(invertedIfHandle);
                            continue;
                        }
                        if (lvg.getEnd() != oldIfHandle) continue;
                        lvg.setEnd(gotoHandle);
                        continue;
                    }
                    targeter.updateTarget(oldIfHandle, invertedIfHandle);
                }
            }
            try {
                il.delete(oldIfHandle);
            }
            catch (TargetLostException tle) {
                String msg = new ErrorMsg("OUTLINE_ERR_DELETED_TARGET", tle.getMessage()).toString();
                throw new InternalError(msg);
            }
            ih = gotoHandle;
            ilChanged = true;
        }
        return ilChanged;
    }

    protected class LocalVariableRegistry {
        protected List<Object> _variables = new ArrayList<Object>();
        protected Map<String, Object> _nameToLVGMap = new LinkedHashMap<String, Object>();

        protected LocalVariableRegistry() {
        }

        protected void registerLocalVariable(LocalVariableGen lvg) {
            int registrySize;
            int slot = lvg.getIndex();
            if (slot >= (registrySize = this._variables.size())) {
                for (int i = registrySize; i < slot; ++i) {
                    this._variables.add(null);
                }
                this._variables.add(lvg);
            } else {
                Object localsInSlot = this._variables.get(slot);
                if (localsInSlot != null) {
                    if (localsInSlot instanceof LocalVariableGen) {
                        ArrayList<LocalVariableGen> listOfLocalsInSlot = new ArrayList<LocalVariableGen>();
                        listOfLocalsInSlot.add((LocalVariableGen)localsInSlot);
                        listOfLocalsInSlot.add(lvg);
                        this._variables.set(slot, listOfLocalsInSlot);
                    } else {
                        ((List)localsInSlot).add(lvg);
                    }
                } else {
                    this._variables.set(slot, lvg);
                }
            }
            this.registerByName(lvg);
        }

        protected LocalVariableGen lookupRegisteredLocalVariable(int slot, int offset) {
            Object localsInSlot;
            Object object = localsInSlot = this._variables != null ? this._variables.get(slot) : null;
            if (localsInSlot != null) {
                if (localsInSlot instanceof LocalVariableGen) {
                    LocalVariableGen lvg = (LocalVariableGen)localsInSlot;
                    if (MethodGenerator.this.offsetInLocalVariableGenRange(lvg, offset)) {
                        return lvg;
                    }
                } else {
                    List listOfLocalsInSlot = (List)localsInSlot;
                    for (LocalVariableGen lvg : listOfLocalsInSlot) {
                        if (!MethodGenerator.this.offsetInLocalVariableGenRange(lvg, offset)) continue;
                        return lvg;
                    }
                }
            }
            return null;
        }

        protected void registerByName(LocalVariableGen lvg) {
            Object duplicateNameEntry = this._nameToLVGMap.get(lvg.getName());
            if (duplicateNameEntry == null) {
                this._nameToLVGMap.put(lvg.getName(), lvg);
            } else {
                ArrayList<LocalVariableGen> sameNameList;
                if (duplicateNameEntry instanceof ArrayList) {
                    sameNameList = (ArrayList<LocalVariableGen>)duplicateNameEntry;
                    sameNameList.add(lvg);
                } else {
                    sameNameList = new ArrayList<LocalVariableGen>();
                    sameNameList.add((LocalVariableGen)duplicateNameEntry);
                    sameNameList.add(lvg);
                }
                this._nameToLVGMap.put(lvg.getName(), sameNameList);
            }
        }

        protected void removeByNameTracking(LocalVariableGen lvg) {
            Object duplicateNameEntry = this._nameToLVGMap.get(lvg.getName());
            if (duplicateNameEntry instanceof ArrayList) {
                List sameNameList = (List)duplicateNameEntry;
                for (int i = 0; i < sameNameList.size(); ++i) {
                    if (sameNameList.get(i) != lvg) continue;
                    sameNameList.remove(i);
                    break;
                }
            } else {
                this._nameToLVGMap.remove(lvg.getName());
            }
        }

        protected LocalVariableGen lookUpByName(String name) {
            LocalVariableGen lvg = null;
            Object duplicateNameEntry = this._nameToLVGMap.get(name);
            if (duplicateNameEntry instanceof ArrayList) {
                List sameNameList = (List)duplicateNameEntry;
                for (int i = 0; i < sameNameList.size() && !((lvg = (LocalVariableGen)sameNameList.get(i)).getName() == null ? name == null : lvg.getName().equals(name)); ++i) {
                }
            } else {
                lvg = (LocalVariableGen)duplicateNameEntry;
            }
            return lvg;
        }

        private LocalVariableGen[] getLocals() {
            LocalVariableGen[] locals = null;
            ArrayList<LocalVariableGen> allVarsEverDeclared = new ArrayList<LocalVariableGen>();
            for (Map.Entry<String, Object> nameVarsPair : this._nameToLVGMap.entrySet()) {
                Object vars = nameVarsPair.getValue();
                if (vars == null) continue;
                if (vars instanceof ArrayList) {
                    List varsList = (List)vars;
                    for (int i = 0; i < varsList.size(); ++i) {
                        allVarsEverDeclared.add((LocalVariableGen)varsList.get(i));
                    }
                    continue;
                }
                allVarsEverDeclared.add((LocalVariableGen)vars);
            }
            locals = new LocalVariableGen[allVarsEverDeclared.size()];
            allVarsEverDeclared.toArray(locals);
            return locals;
        }
    }

    private class Chunk
    implements Comparable<Object> {
        private InstructionHandle m_start;
        private InstructionHandle m_end;
        private int m_size;

        Chunk(InstructionHandle start, InstructionHandle end) {
            this.m_start = start;
            this.m_end = end;
            this.m_size = end.getPosition() - start.getPosition();
        }

        boolean isAdjacentTo(Chunk neighbour) {
            return this.getChunkEnd().getNext() == neighbour.getChunkStart();
        }

        InstructionHandle getChunkStart() {
            return this.m_start;
        }

        InstructionHandle getChunkEnd() {
            return this.m_end;
        }

        int getChunkSize() {
            return this.m_size;
        }

        @Override
        public int compareTo(Object comparand) {
            return this.getChunkSize() - ((Chunk)comparand).getChunkSize();
        }
    }
}

