/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.BranchHandle;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPEQ;
import com.sun.org.apache.bcel.internal.generic.ILOAD;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.PUSH;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.TopLevelElement;
import com.sun.org.apache.xalan.internal.xsltc.compiler.XSLTC;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

final class Whitespace
extends TopLevelElement {
    public static final int USE_PREDICATE = 0;
    public static final int STRIP_SPACE = 1;
    public static final int PRESERVE_SPACE = 2;
    public static final int RULE_NONE = 0;
    public static final int RULE_ELEMENT = 1;
    public static final int RULE_NAMESPACE = 2;
    public static final int RULE_ALL = 3;
    private String _elementList;
    private int _action;
    private int _importPrecedence;

    Whitespace() {
    }

    @Override
    public void parseContents(Parser parser) {
        this._action = this._qname.getLocalPart().endsWith("strip-space") ? 1 : 2;
        this._importPrecedence = parser.getCurrentImportPrecedence();
        this._elementList = this.getAttribute("elements");
        if (this._elementList == null || this._elementList.length() == 0) {
            this.reportError(this, parser, "REQUIRED_ATTR_ERR", "elements");
            return;
        }
        SymbolTable stable = parser.getSymbolTable();
        StringTokenizer list = new StringTokenizer(this._elementList);
        StringBuffer elements = new StringBuffer("");
        while (list.hasMoreElements()) {
            String token = list.nextToken();
            int col = token.indexOf(58);
            if (col != -1) {
                String namespace = this.lookupNamespace(token.substring(0, col));
                if (namespace != null) {
                    elements.append(namespace).append(':').append(token.substring(col + 1));
                } else {
                    elements.append(token);
                }
            } else {
                elements.append(token);
            }
            if (!list.hasMoreElements()) continue;
            elements.append(" ");
        }
        this._elementList = elements.toString();
    }

    public List<WhitespaceRule> getRules() {
        ArrayList<WhitespaceRule> rules = new ArrayList<WhitespaceRule>();
        StringTokenizer list = new StringTokenizer(this._elementList);
        while (list.hasMoreElements()) {
            rules.add(new WhitespaceRule(this._action, list.nextToken(), this._importPrecedence));
        }
        return rules;
    }

    private static WhitespaceRule findContradictingRule(List<WhitespaceRule> rules, WhitespaceRule rule) {
        for (WhitespaceRule currentRule : rules) {
            if (currentRule == rule) {
                return null;
            }
            switch (currentRule.getStrength()) {
                case 3: {
                    return currentRule;
                }
                case 1: {
                    if (!rule.getElement().equals(currentRule.getElement())) break;
                }
                case 2: {
                    if (!rule.getNamespace().equals(currentRule.getNamespace())) break;
                    return currentRule;
                }
            }
        }
        return null;
    }

    private static int prioritizeRules(List<WhitespaceRule> rules) {
        WhitespaceRule currentRule;
        int defaultAction = 2;
        Whitespace.quicksort(rules, 0, rules.size() - 1);
        boolean strip = false;
        for (int i = 0; i < rules.size(); ++i) {
            currentRule = rules.get(i);
            if (currentRule.getAction() != 1) continue;
            strip = true;
        }
        if (!strip) {
            rules.clear();
            return 2;
        }
        int idx = 0;
        while (idx < rules.size()) {
            currentRule = rules.get(idx);
            if (Whitespace.findContradictingRule(rules, currentRule) != null) {
                rules.remove(idx);
                continue;
            }
            if (currentRule.getStrength() == 3) {
                defaultAction = currentRule.getAction();
                for (int i = idx; i < rules.size(); ++i) {
                    rules.remove(i);
                }
            }
            ++idx;
        }
        if (rules.isEmpty()) {
            return defaultAction;
        }
        while ((currentRule = rules.get(rules.size() - 1)).getAction() == defaultAction) {
            rules.remove(rules.size() - 1);
            if (rules.size() > 0) continue;
        }
        return defaultAction;
    }

    public static void compileStripSpace(BranchHandle[] strip, int sCount, InstructionList il) {
        InstructionHandle target = il.append(ICONST_1);
        il.append(IRETURN);
        for (int i = 0; i < sCount; ++i) {
            strip[i].setTarget(target);
        }
    }

    public static void compilePreserveSpace(BranchHandle[] preserve, int pCount, InstructionList il) {
        InstructionHandle target = il.append(ICONST_0);
        il.append(IRETURN);
        for (int i = 0; i < pCount; ++i) {
            preserve[i].setTarget(target);
        }
    }

    private static void compilePredicate(List<WhitespaceRule> rules, int defaultAction, ClassGenerator classGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = new InstructionList();
        XSLTC xsltc = classGen.getParser().getXSLTC();
        MethodGenerator stripSpace = new MethodGenerator(17, com.sun.org.apache.bcel.internal.generic.Type.BOOLEAN, new com.sun.org.apache.bcel.internal.generic.Type[]{Util.getJCRefType("Lcom/sun/org/apache/xalan/internal/xsltc/DOM;"), com.sun.org.apache.bcel.internal.generic.Type.INT, com.sun.org.apache.bcel.internal.generic.Type.INT}, new String[]{"dom", "node", "type"}, "stripSpace", classGen.getClassName(), il, cpg);
        classGen.addInterface("com/sun/org/apache/xalan/internal/xsltc/StripFilter");
        int paramDom = stripSpace.getLocalIndex("dom");
        int paramCurrent = stripSpace.getLocalIndex("node");
        int paramType = stripSpace.getLocalIndex("type");
        BranchHandle[] strip = new BranchHandle[rules.size()];
        BranchHandle[] preserve = new BranchHandle[rules.size()];
        int sCount = 0;
        int pCount = 0;
        for (int i = 0; i < rules.size(); ++i) {
            WhitespaceRule rule = rules.get(i);
            int gns = cpg.addInterfaceMethodref("com.sun.org.apache.xalan.internal.xsltc.DOM", "getNamespaceName", "(I)Ljava/lang/String;");
            int strcmp = cpg.addMethodref("java/lang/String", "compareTo", "(Ljava/lang/String;)I");
            if (rule.getStrength() == 2) {
                il.append(new ALOAD(paramDom));
                il.append(new ILOAD(paramCurrent));
                il.append(new INVOKEINTERFACE(gns, 2));
                il.append(new PUSH(cpg, rule.getNamespace()));
                il.append(new INVOKEVIRTUAL(strcmp));
                il.append(ICONST_0);
                if (rule.getAction() == 1) {
                    strip[sCount++] = il.append(new IF_ICMPEQ(null));
                    continue;
                }
                preserve[pCount++] = il.append(new IF_ICMPEQ(null));
                continue;
            }
            if (rule.getStrength() != 1) continue;
            Parser parser = classGen.getParser();
            QName qname = rule.getNamespace() != "" ? parser.getQName(rule.getNamespace(), null, rule.getElement()) : parser.getQName(rule.getElement());
            int elementType = xsltc.registerElement(qname);
            il.append(new ILOAD(paramType));
            il.append(new PUSH(cpg, elementType));
            if (rule.getAction() == 1) {
                strip[sCount++] = il.append(new IF_ICMPEQ(null));
                continue;
            }
            preserve[pCount++] = il.append(new IF_ICMPEQ(null));
        }
        if (defaultAction == 1) {
            Whitespace.compileStripSpace(strip, sCount, il);
            Whitespace.compilePreserveSpace(preserve, pCount, il);
        } else {
            Whitespace.compilePreserveSpace(preserve, pCount, il);
            Whitespace.compileStripSpace(strip, sCount, il);
        }
        classGen.addMethod(stripSpace);
    }

    private static void compileDefault(int defaultAction, ClassGenerator classGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = new InstructionList();
        XSLTC xsltc = classGen.getParser().getXSLTC();
        MethodGenerator stripSpace = new MethodGenerator(17, com.sun.org.apache.bcel.internal.generic.Type.BOOLEAN, new com.sun.org.apache.bcel.internal.generic.Type[]{Util.getJCRefType("Lcom/sun/org/apache/xalan/internal/xsltc/DOM;"), com.sun.org.apache.bcel.internal.generic.Type.INT, com.sun.org.apache.bcel.internal.generic.Type.INT}, new String[]{"dom", "node", "type"}, "stripSpace", classGen.getClassName(), il, cpg);
        classGen.addInterface("com/sun/org/apache/xalan/internal/xsltc/StripFilter");
        if (defaultAction == 1) {
            il.append(ICONST_1);
        } else {
            il.append(ICONST_0);
        }
        il.append(IRETURN);
        classGen.addMethod(stripSpace);
    }

    public static int translateRules(List<WhitespaceRule> rules, ClassGenerator classGen) {
        int defaultAction = Whitespace.prioritizeRules(rules);
        if (rules.size() == 0) {
            Whitespace.compileDefault(defaultAction, classGen);
            return defaultAction;
        }
        Whitespace.compilePredicate(rules, defaultAction, classGen);
        return 0;
    }

    private static void quicksort(List<WhitespaceRule> rules, int p, int r) {
        while (p < r) {
            int q = Whitespace.partition(rules, p, r);
            Whitespace.quicksort(rules, p, q);
            p = q + 1;
        }
    }

    private static int partition(List<WhitespaceRule> rules, int p, int r) {
        WhitespaceRule x = rules.get(p + r >>> 1);
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (x.compareTo(rules.get(--j)) < 0) {
                continue;
            }
            while (x.compareTo(rules.get(++i)) > 0) {
            }
            if (i >= j) break;
            WhitespaceRule tmp = rules.get(i);
            rules.set(i, rules.get(j));
            rules.set(j, tmp);
        }
        return j;
    }

    @Override
    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        return Type.Void;
    }

    @Override
    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
    }

    static final class WhitespaceRule {
        private final int _action;
        private String _namespace;
        private String _element;
        private int _type;
        private int _priority;

        public WhitespaceRule(int action, String element, int precedence) {
            this._action = action;
            int colon = element.lastIndexOf(58);
            if (colon >= 0) {
                this._namespace = element.substring(0, colon);
                this._element = element.substring(colon + 1, element.length());
            } else {
                this._namespace = "";
                this._element = element;
            }
            this._priority = precedence << 2;
            if (this._element.equals("*")) {
                if (this._namespace == "") {
                    this._type = 3;
                    this._priority += 2;
                } else {
                    this._type = 2;
                    ++this._priority;
                }
            } else {
                this._type = 1;
            }
        }

        public int compareTo(WhitespaceRule other) {
            return this._priority < other._priority ? -1 : (this._priority > other._priority ? 1 : 0);
        }

        public int getAction() {
            return this._action;
        }

        public int getStrength() {
            return this._type;
        }

        public int getPriority() {
            return this._priority;
        }

        public String getElement() {
            return this._element;
        }

        public String getNamespace() {
            return this._namespace;
        }
    }
}

