/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.xalan.internal.xsltc.compiler.AttributeSet;
import com.sun.org.apache.xalan.internal.xsltc.compiler.DecimalFormatting;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Key;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Param;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Stylesheet;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SyntaxTreeNode;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Template;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Variable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.VariableBase;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

final class SymbolTable {
    private final Map<String, Stylesheet> _stylesheets = new HashMap<String, Stylesheet>();
    private final Map<String, List<MethodType>> _primops = new HashMap<String, List<MethodType>>();
    private Map<String, VariableBase> _variables = null;
    private Map<String, Template> _templates = null;
    private Map<String, AttributeSet> _attributeSets = null;
    private Map<String, String> _aliases = null;
    private Map<String, Integer> _excludedURI = null;
    private Stack<Map<String, Integer>> _excludedURIStack = null;
    private Map<String, DecimalFormatting> _decimalFormats = null;
    private Map<String, Key> _keys = null;
    private int _nsCounter = 0;
    private SyntaxTreeNode _current = null;

    SymbolTable() {
    }

    public DecimalFormatting getDecimalFormatting(QName name) {
        if (this._decimalFormats == null) {
            return null;
        }
        return this._decimalFormats.get(name.getStringRep());
    }

    public void addDecimalFormatting(QName name, DecimalFormatting symbols) {
        if (this._decimalFormats == null) {
            this._decimalFormats = new HashMap<String, DecimalFormatting>();
        }
        this._decimalFormats.put(name.getStringRep(), symbols);
    }

    public Key getKey(QName name) {
        if (this._keys == null) {
            return null;
        }
        return this._keys.get(name.getStringRep());
    }

    public void addKey(QName name, Key key) {
        if (this._keys == null) {
            this._keys = new HashMap<String, Key>();
        }
        this._keys.put(name.getStringRep(), key);
    }

    public Stylesheet addStylesheet(QName name, Stylesheet node) {
        return this._stylesheets.put(name.getStringRep(), node);
    }

    public Stylesheet lookupStylesheet(QName name) {
        return this._stylesheets.get(name.getStringRep());
    }

    public Template addTemplate(Template template) {
        QName name = template.getName();
        if (this._templates == null) {
            this._templates = new HashMap<String, Template>();
        }
        return this._templates.put(name.getStringRep(), template);
    }

    public Template lookupTemplate(QName name) {
        if (this._templates == null) {
            return null;
        }
        return this._templates.get(name.getStringRep());
    }

    public Variable addVariable(Variable variable) {
        VariableBase v;
        if (this._variables == null) {
            this._variables = new HashMap<String, VariableBase>();
        }
        return (v = this._variables.put(variable.getName().getStringRep(), variable)) instanceof Variable ? (Variable)v : null;
    }

    public Param addParam(Param parameter) {
        VariableBase v;
        if (this._variables == null) {
            this._variables = new HashMap<String, VariableBase>();
        }
        return (v = this._variables.put(parameter.getName().getStringRep(), parameter)) instanceof Param ? (Param)v : null;
    }

    public Variable lookupVariable(QName qname) {
        if (this._variables == null) {
            return null;
        }
        String name = qname.getStringRep();
        VariableBase obj = this._variables.get(name);
        return obj instanceof Variable ? (Variable)obj : null;
    }

    public Param lookupParam(QName qname) {
        if (this._variables == null) {
            return null;
        }
        String name = qname.getStringRep();
        VariableBase obj = this._variables.get(name);
        return obj instanceof Param ? (Param)obj : null;
    }

    public SyntaxTreeNode lookupName(QName qname) {
        if (this._variables == null) {
            return null;
        }
        String name = qname.getStringRep();
        return this._variables.get(name);
    }

    public AttributeSet addAttributeSet(AttributeSet atts) {
        if (this._attributeSets == null) {
            this._attributeSets = new HashMap<String, AttributeSet>();
        }
        return this._attributeSets.put(atts.getName().getStringRep(), atts);
    }

    public AttributeSet lookupAttributeSet(QName name) {
        if (this._attributeSets == null) {
            return null;
        }
        return this._attributeSets.get(name.getStringRep());
    }

    public void addPrimop(String name, MethodType mtype) {
        List<MethodType> methods = this._primops.get(name);
        if (methods == null) {
            methods = new ArrayList<MethodType>();
            this._primops.put(name, methods);
        }
        methods.add(mtype);
    }

    public List<MethodType> lookupPrimop(String name) {
        return this._primops.get(name);
    }

    public String generateNamespacePrefix() {
        return "ns" + this._nsCounter++;
    }

    public void setCurrentNode(SyntaxTreeNode node) {
        this._current = node;
    }

    public String lookupNamespace(String prefix) {
        if (this._current == null) {
            return "";
        }
        return this._current.lookupNamespace(prefix);
    }

    public void addPrefixAlias(String prefix, String alias) {
        if (this._aliases == null) {
            this._aliases = new HashMap<String, String>();
        }
        this._aliases.put(prefix, alias);
    }

    public String lookupPrefixAlias(String prefix) {
        if (this._aliases == null) {
            return null;
        }
        return this._aliases.get(prefix);
    }

    public void excludeURI(String uri) {
        Integer refcnt;
        if (uri == null) {
            return;
        }
        if (this._excludedURI == null) {
            this._excludedURI = new HashMap<String, Integer>();
        }
        refcnt = (refcnt = this._excludedURI.get(uri)) == null ? Integer.valueOf(1) : Integer.valueOf(refcnt + 1);
        this._excludedURI.put(uri, refcnt);
    }

    public void excludeNamespaces(String prefixes) {
        if (prefixes != null) {
            StringTokenizer tokens = new StringTokenizer(prefixes);
            while (tokens.hasMoreTokens()) {
                String prefix = tokens.nextToken();
                String uri = prefix.equals("#default") ? this.lookupNamespace("") : this.lookupNamespace(prefix);
                if (uri == null) continue;
                this.excludeURI(uri);
            }
        }
    }

    public boolean isExcludedNamespace(String uri) {
        if (uri != null && this._excludedURI != null) {
            Integer refcnt = this._excludedURI.get(uri);
            return refcnt != null && refcnt > 0;
        }
        return false;
    }

    public void unExcludeNamespaces(String prefixes) {
        if (this._excludedURI == null) {
            return;
        }
        if (prefixes != null) {
            StringTokenizer tokens = new StringTokenizer(prefixes);
            while (tokens.hasMoreTokens()) {
                String prefix = tokens.nextToken();
                String uri = prefix.equals("#default") ? this.lookupNamespace("") : this.lookupNamespace(prefix);
                Integer refcnt = this._excludedURI.get(uri);
                if (refcnt == null) continue;
                this._excludedURI.put(uri, refcnt - 1);
            }
        }
    }

    public void pushExcludedNamespacesContext() {
        if (this._excludedURIStack == null) {
            this._excludedURIStack = new Stack();
        }
        this._excludedURIStack.push(this._excludedURI);
        this._excludedURI = null;
    }

    public void popExcludedNamespacesContext() {
        this._excludedURI = this._excludedURIStack.pop();
        if (this._excludedURIStack.isEmpty()) {
            this._excludedURIStack = null;
        }
    }
}

