/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SyntheticRepository
implements Repository {
    private final Map<String, SoftReference<JavaClass>> loadedClasses = new HashMap<String, SoftReference<JavaClass>>();

    private SyntheticRepository() {
    }

    public static SyntheticRepository getInstance() {
        return new SyntheticRepository();
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }

    @Override
    public JavaClass findClass(String className) {
        SoftReference<JavaClass> ref = this.loadedClasses.get(className);
        return ref == null ? null : ref.get();
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), new SoftReference<JavaClass>(clazz));
        clazz.setRepository(this);
    }

    @Override
    public JavaClass loadClass(Class<?> clazz) throws ClassNotFoundException {
        JavaClass javaClass;
        block10: {
            String className = clazz.getName();
            JavaClass repositoryClass = this.findClass(className);
            if (repositoryClass != null) {
                return repositoryClass;
            }
            String name = className;
            int i = name.lastIndexOf(46);
            if (i > 0) {
                name = name.substring(i + 1);
            }
            InputStream clsStream = clazz.getResourceAsStream(name + ".class");
            try {
                javaClass = this.loadClass(clsStream, className);
                if (clsStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (clsStream != null) {
                        try {
                            clsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            clsStream.close();
        }
        return javaClass;
    }

    private JavaClass loadClass(InputStream inputStream, String className) throws ClassNotFoundException {
        try {
            if (inputStream != null) {
                ClassParser parser = new ClassParser(inputStream, className);
                JavaClass clazz = parser.parse();
                this.storeClass(clazz);
                return clazz;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
        throw new ClassNotFoundException("ClassRepository could not load " + className);
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        if (className == null || className.isEmpty()) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        JavaClass clazz = this.findClass(className = Utility.pathToPackage(className));
        if (clazz != null) {
            return clazz;
        }
        IOException e = new IOException("Couldn't find: " + className + ".class");
        throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
    }
}

