/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class ConstantUtf8
extends Constant {
    private static final String SYS_PROP_CACHE_MAX_ENTRIES = "bcel.maxcached";
    private static final String SYS_PROP_CACHE_MAX_ENTRY_SIZE = "bcel.maxcached.size";
    private static final String SYS_PROP_STATISTICS = "bcel.statistics";
    private static volatile int considered;
    private static volatile int created;
    private static volatile int hits;
    private static volatile int skipped;
    private final String value;

    public ConstantUtf8(ConstantUtf8 constantUtf8) {
        this(constantUtf8.getBytes());
    }

    ConstantUtf8(DataInput dataInput) throws IOException {
        super((byte)1);
        this.value = dataInput.readUTF();
        ++created;
    }

    public ConstantUtf8(String value) {
        super((byte)1);
        this.value = Objects.requireNonNull(value, "value");
        ++created;
    }

    public static synchronized void clearCache() {
        Cache.CACHE.clear();
    }

    static synchronized void clearStats() {
        created = 0;
        skipped = 0;
        considered = 0;
        hits = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantUtf8 getCachedInstance(String value) {
        if (value.length() > 200) {
            ++skipped;
            return new ConstantUtf8(value);
        }
        ++considered;
        Class<ConstantUtf8> clazz = ConstantUtf8.class;
        synchronized (ConstantUtf8.class) {
            ConstantUtf8 result = (ConstantUtf8)Cache.CACHE.get(value);
            if (result != null) {
                ++hits;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
            result = new ConstantUtf8(value);
            Cache.CACHE.put(value, result);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static ConstantUtf8 getInstance(DataInput dataInput) throws IOException {
        return ConstantUtf8.getInstance(dataInput.readUTF());
    }

    public static ConstantUtf8 getInstance(String value) {
        return Cache.isEnabled() ? ConstantUtf8.getCachedInstance(value) : new ConstantUtf8(value);
    }

    static void printStats() {
        String prefix = "[Apache Commons BCEL]";
        System.err.printf("%s Cache hit %,d/%,d, %d skipped.%n", "[Apache Commons BCEL]", hits, considered, skipped);
        System.err.printf("%s Total of %,d ConstantUtf8 objects created.%n", "[Apache Commons BCEL]", created);
        System.err.printf("%s Configuration: %s=%,d, %s=%,d.%n", "[Apache Commons BCEL]", SYS_PROP_CACHE_MAX_ENTRIES, 20000, SYS_PROP_CACHE_MAX_ENTRY_SIZE, 200);
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantUtf8(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        file.writeByte(super.getTag());
        file.writeUTF(this.value);
    }

    public String getBytes() {
        return this.value;
    }

    @Deprecated
    public void setBytes(String bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return super.toString() + "(\"" + Utility.replace(this.value, "\n", "\\n") + "\")";
    }

    private static class Cache {
        private static final boolean BCEL_STATISTICS = false;
        private static final int MAX_ENTRIES = 20000;
        private static final int INITIAL_CAPACITY = 26666;
        private static final HashMap<String, ConstantUtf8> CACHE = new LinkedHashMap<String, ConstantUtf8>(26666, 0.75f, true){
            private static final long serialVersionUID = -8506975356158971766L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ConstantUtf8> eldest) {
                return this.size() > 20000;
            }
        };
        private static final int MAX_ENTRY_SIZE = 200;

        private Cache() {
        }

        static boolean isEnabled() {
            return true;
        }
    }
}

