/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class CodeException
implements Cloneable,
Node {
    static final CodeException[] EMPTY_CODE_EXCEPTION_ARRAY = new CodeException[0];
    private int startPc;
    private int endPc;
    private int handlerPc;
    private int catchType;

    public CodeException(CodeException c) {
        this(c.getStartPC(), c.getEndPC(), c.getHandlerPC(), c.getCatchType());
    }

    CodeException(DataInput file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort());
    }

    public CodeException(int startPc, int endPc, int handlerPc, int catchType) {
        this.startPc = Args.requireU2(startPc, "startPc");
        this.endPc = Args.requireU2(endPc, "endPc");
        this.handlerPc = Args.requireU2(handlerPc, "handlerPc");
        this.catchType = Args.requireU2(catchType, "catchType");
    }

    @Override
    public void accept(Visitor v) {
        v.visitCodeException(this);
    }

    public CodeException copy() {
        try {
            return (CodeException)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.startPc);
        file.writeShort(this.endPc);
        file.writeShort(this.handlerPc);
        file.writeShort(this.catchType);
    }

    public int getCatchType() {
        return this.catchType;
    }

    public void setCatchType(int catchType) {
        this.catchType = catchType;
    }

    public int getEndPC() {
        return this.endPc;
    }

    public void setEndPC(int endPc) {
        this.endPc = endPc;
    }

    public int getHandlerPC() {
        return this.handlerPc;
    }

    public void setHandlerPC(int handlerPc) {
        this.handlerPc = handlerPc;
    }

    public int getStartPC() {
        return this.startPc;
    }

    public void setStartPC(int startPc) {
        this.startPc = startPc;
    }

    public String toString() {
        return "CodeException(startPc = " + this.startPc + ", endPc = " + this.endPc + ", handlerPc = " + this.handlerPc + ", catchType = " + this.catchType + ")";
    }

    public String toString(ConstantPool cp) {
        return this.toString(cp, true);
    }

    public String toString(ConstantPool cp, boolean verbose) {
        String str = this.catchType == 0 ? "<Any exception>(0)" : Utility.compactClassName(cp.getConstantString(this.catchType, (byte)7), false) + (verbose ? "(" + this.catchType + ")" : "");
        return this.startPc + "\t" + this.endPc + "\t" + this.handlerPc + "\t" + str;
    }
}

