/*
 * Decompiled with CFR 0.152.
 */
package org.consensusj.jsonrpc.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.regex.Pattern;

public class NumberStringSerializer
extends JsonSerializer<String> {
    private static Pattern numberRegEx = Pattern.compile("^-?\\d+$");

    public void serialize(String numberOrString, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        if (numberRegEx.matcher(numberOrString).matches()) {
            try {
                jsonGenerator.writeNumber(Long.valueOf(numberOrString).longValue());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        jsonGenerator.writeString(numberOrString);
    }
}

