/*
 * Decompiled with CFR 0.152.
 */
package org.consensusj.jsonrpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.consensusj.jsonrpc.AbstractRpcClient;
import org.consensusj.jsonrpc.JsonRpcError;
import org.consensusj.jsonrpc.JsonRpcMessage;
import org.consensusj.jsonrpc.JsonRpcRequest;
import org.consensusj.jsonrpc.JsonRpcResponse;
import org.consensusj.jsonrpc.JsonRpcStatusException;
import org.consensusj.jsonrpc.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient
extends AbstractRpcClient {
    private static final Logger log = LoggerFactory.getLogger(RpcClient.class);
    private final URI serverURI;
    private final String username;
    private final String password;
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    private final SSLSocketFactory sslSocketFactory;

    public RpcClient(SSLSocketFactory socketFactory, JsonRpcMessage.Version jsonRpcVersion, URI server, String rpcUser, String rpcPassword) {
        super(jsonRpcVersion);
        this.sslSocketFactory = socketFactory;
        log.debug("Constructing JSON-RPC client for: {}", (Object)server);
        this.serverURI = server;
        this.username = rpcUser;
        this.password = rpcPassword;
    }

    public RpcClient(JsonRpcMessage.Version jsonRpcVersion, URI server, String rpcUser, String rpcPassword) {
        this((SSLSocketFactory)SSLSocketFactory.getDefault(), jsonRpcVersion, server, rpcUser, rpcPassword);
    }

    @Deprecated
    public RpcClient(URI server, String rpcUser, String rpcPassword) {
        this(JsonRpcMessage.Version.V1, server, rpcUser, rpcPassword);
    }

    @Override
    public URI getServerURI() {
        return this.serverURI;
    }

    @Override
    public <R> JsonRpcResponse<R> sendRequestForResponse(JsonRpcRequest request, JavaType responseType) throws IOException, JsonRpcStatusException {
        HttpURLConnection connection = this.openConnection();
        if (log.isDebugEnabled()) {
            log.debug("JsonRpcRequest: {}", (Object)this.mapper.writeValueAsString((Object)request));
        }
        try (OutputStream requestStream = connection.getOutputStream();){
            this.mapper.writeValue(requestStream, (Object)request);
        }
        int responseCode = connection.getResponseCode();
        log.debug("HTTP Response code: {}", (Object)responseCode);
        if (responseCode != 200) {
            this.handleBadResponseCode(responseCode, connection);
        }
        JsonRpcResponse<R> responseJson = this.responseFromStream(connection.getInputStream(), responseType);
        connection.disconnect();
        return responseJson;
    }

    private <R> JsonRpcResponse<R> responseFromStream(InputStream inputStream, JavaType responseType) throws IOException {
        JsonRpcResponse responseJson;
        try {
            if (log.isDebugEnabled()) {
                String responseBody = RpcClient.convertStreamToString(inputStream);
                log.debug("Response Body: {}", (Object)responseBody);
                responseJson = (JsonRpcResponse)this.mapper.readValue(responseBody, responseType);
            } else {
                responseJson = (JsonRpcResponse)this.mapper.readValue(inputStream, responseType);
            }
        }
        catch (JsonProcessingException e) {
            log.error("JsonProcessingException: {}", (Throwable)e);
            throw e;
        }
        return responseJson;
    }

    private void handleBadResponseCode(int responseCode, HttpURLConnection connection) throws IOException, JsonRpcStatusException {
        String responseMessage;
        String exceptionMessage = responseMessage = connection.getResponseMessage();
        int jsonRpcCode = 0;
        JsonRpcResponse bodyJson = null;
        String bodyString = null;
        InputStream errorStream = connection.getErrorStream();
        if (errorStream != null) {
            if (connection.getContentType().equals("application/json")) {
                JavaType genericResponseType = this.mapper.getTypeFactory().constructParametricType(JsonRpcResponse.class, new Class[]{JsonNode.class});
                bodyJson = this.responseFromStream(errorStream, genericResponseType);
                JsonRpcError error = bodyJson.getError();
                if (error != null) {
                    exceptionMessage = error.getMessage();
                    jsonRpcCode = error.getCode();
                    log.info("json error code: {}, message: {}", (Object)jsonRpcCode, (Object)exceptionMessage);
                }
            } else {
                bodyString = RpcClient.convertStreamToString(errorStream);
                log.error("error string: {}", (Object)bodyString);
                errorStream.close();
            }
        }
        throw new JsonRpcStatusException(exceptionMessage, responseCode, responseMessage, jsonRpcCode, bodyString, bodyJson);
    }

    private static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is, UTF8).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private HttpURLConnection openConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.serverURI.toURL().openConnection();
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
        }
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept-Charset", UTF8);
        connection.setRequestProperty("Content-Type", "application/json;charset=" + UTF8);
        connection.setRequestProperty("Connection", "close");
        String auth = this.username + ":" + this.password;
        String basicAuth = "Basic " + RpcClient.base64Encode(auth);
        connection.setRequestProperty("Authorization", basicAuth);
        return connection;
    }

    protected static String base64Encode(String authString) {
        return Base64.encodeToString(authString.getBytes(), 2).trim();
    }
}

