/*
 * Decompiled with CFR 0.152.
 */
package org.consensusj.jsonrpc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.consensusj.jsonrpc.JsonRpcError;
import org.consensusj.jsonrpc.JsonRpcRequest;
import org.consensusj.jsonrpc.internal.NumberStringSerializer;

public class JsonRpcResponse<R> {
    private final String jsonrpc;
    private final String id;
    private final R result;
    private final JsonRpcError error;

    @JsonCreator
    public JsonRpcResponse(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="id") String id, @JsonProperty(value="result") R result, @JsonProperty(value="error") JsonRpcError error) {
        this.jsonrpc = jsonrpc;
        this.id = id;
        this.result = result;
        this.error = error;
    }

    @Deprecated
    public JsonRpcResponse(R result, JsonRpcError error, String jsonrpc, String id) {
        this.jsonrpc = jsonrpc;
        this.result = result;
        this.error = error;
        this.id = id;
    }

    public JsonRpcResponse(JsonRpcRequest request, R result) {
        this.jsonrpc = request.getJsonrpc();
        this.id = request.getId();
        this.result = result;
        this.error = null;
    }

    public JsonRpcResponse(JsonRpcRequest request, JsonRpcError error) {
        this.jsonrpc = request.getJsonrpc();
        this.id = request.getId();
        this.error = error;
        this.result = null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getJsonrpc() {
        return this.jsonrpc;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public R getResult() {
        return this.result;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonRpcError getError() {
        return this.error;
    }

    @JsonSerialize(using=NumberStringSerializer.class)
    public String getId() {
        return this.id;
    }
}

