/*
 * Decompiled with CFR 0.152.
 */
package org.consensusj.jsonrpc;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.consensusj.jsonrpc.JacksonRpcClient;
import org.consensusj.jsonrpc.JsonRpcClient;
import org.consensusj.jsonrpc.JsonRpcMessage;
import org.consensusj.jsonrpc.JsonRpcRequest;
import org.consensusj.jsonrpc.JsonRpcResponse;
import org.consensusj.jsonrpc.JsonRpcStatusException;

public abstract class AbstractRpcClient
implements JsonRpcClient,
JacksonRpcClient {
    private static final JsonRpcMessage.Version DEFAULT_JSON_RPC_VERSION = JsonRpcMessage.Version.V1;
    protected final JsonRpcMessage.Version jsonRpcVersion;
    protected final ObjectMapper mapper;
    private final JavaType defaultType;

    @Deprecated
    public AbstractRpcClient() {
        this(DEFAULT_JSON_RPC_VERSION);
    }

    public AbstractRpcClient(JsonRpcMessage.Version jsonRpcVersion) {
        this.jsonRpcVersion = jsonRpcVersion;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.defaultType = this.mapper.getTypeFactory().constructType(Object.class);
    }

    @Override
    public JsonRpcMessage.Version getJsonRpcVersion() {
        return this.jsonRpcVersion;
    }

    @Override
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public abstract <R> JsonRpcResponse<R> sendRequestForResponse(JsonRpcRequest var1, JavaType var2) throws IOException, JsonRpcStatusException;

    private <R> R sendRequestForResult(JsonRpcRequest request, JavaType responseType) throws IOException, JsonRpcStatusException {
        JsonRpcResponse<R> response = this.sendRequestForResponse(request, responseType);
        if (response.getError() != null && response.getError().getCode() != 0) {
            throw new JsonRpcStatusException(response.getError().getMessage(), 200, null, response.getError().getCode(), null, response);
        }
        return response.getResult();
    }

    @Override
    public <R> R send(String method, Class<R> resultType, List<Object> params) throws IOException, JsonRpcStatusException {
        return this.sendRequestForResult(this.buildJsonRequest(method, params), this.responseTypeFor(resultType));
    }

    protected <R> R send(String method, JavaType resultType, List<Object> params) throws IOException, JsonRpcStatusException {
        return this.sendRequestForResult(this.buildJsonRequest(method, params), this.responseTypeFor(resultType));
    }

    protected <R> R send(String method, JavaType resultType, Object ... params) throws IOException, JsonRpcStatusException {
        return this.sendRequestForResult(this.buildJsonRequest(method, params), this.responseTypeFor(resultType));
    }

    @Override
    public <R> R send(String method, List<Object> params) throws IOException, JsonRpcStatusException {
        return this.send(method, this.defaultType, params);
    }
}

