/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.test;

import com.msgilligan.bitcoinj.json.pojo.Outpoint;
import com.msgilligan.bitcoinj.json.pojo.SignedRawTransaction;
import com.msgilligan.bitcoinj.json.pojo.UnspentOutput;
import com.msgilligan.bitcoinj.rpc.BitcoinExtendedClient;
import com.msgilligan.bitcoinj.test.FundingSource;
import com.msgilligan.bitcoinj.test.TransactionIngredients;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.consensusj.jsonrpc.JsonRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegTestFundingSource
implements FundingSource {
    private final Coin txFee = Coin.valueOf((long)200000L);
    private final Integer defaultMaxConf = 9999999;
    private static final Logger log = LoggerFactory.getLogger(RegTestFundingSource.class);
    protected final BitcoinExtendedClient client;
    protected final int bitcoinCoreVersion;

    public RegTestFundingSource(BitcoinExtendedClient client) {
        this.client = client;
        try {
            this.bitcoinCoreVersion = client.getNetworkInfo().getVersion();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (this.bitcoinCoreVersion >= 210000) {
            try {
                List<String> walletList = client.listWallets();
                if (!walletList.contains("")) {
                    Map<String, String> result = client.createWallet("", false, false);
                    log.warn("Created default wallet: {}", result);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    @Override
    public Sha256Hash requestBitcoin(Address toAddress, Coin requestAmount) throws JsonRpcException, IOException {
        Coin availableToSpend;
        Map<Address, Coin> outputs;
        log.info("requestBitcoin requesting {} for {}", (Object)requestAmount.toPlainString(), (Object)toAddress);
        if (requestAmount.value > NetworkParameters.MAX_MONEY.value) {
            throw new IllegalArgumentException("request exceeds MAX_MONEY");
        }
        List<UnspentOutput> unspent = this.mineEnoughFunds(requestAmount);
        List<Outpoint> inputs = this.unspentOutputsToOutpoints(unspent);
        String unsignedTxHex = this.client.createRawTransaction(inputs, outputs = this.calcChange(availableToSpend = this.sumUnspentOutputs(unspent), requestAmount, toAddress, this.client.getRegTestMiningAddress()));
        SignedRawTransaction signingResult = this.client.signRawTransactionWithWallet(unsignedTxHex);
        if (!signingResult.isComplete()) {
            log.error("Unable to complete signing!");
            log.error("SigningResult: {}", (Object)this.toJson(signingResult));
        }
        assert (signingResult.isComplete());
        Sha256Hash txid = this.sendRawTransactionUnlimitedFees(signingResult.getHex());
        log.info("Funding transaction sent: {}", (Object)txid);
        return txid;
    }

    private List<UnspentOutput> mineEnoughFunds(Coin requestAmount) throws IOException {
        List<UnspentOutput> unspent = this.availableFunds();
        Coin availableAmount = this.sumUnspentOutputs(unspent);
        log.info("mineEnoughFunds: Available: {} Requested: {}", (Object)availableAmount.toPlainString(), (Object)requestAmount.toPlainString());
        while (availableAmount.isLessThan(requestAmount.plus(this.txFee))) {
            this.client.generateToAddress(1, this.client.getRegTestMiningAddress());
            unspent = this.availableFunds();
            availableAmount = this.sumUnspentOutputs(unspent);
            int height = this.client.getBlockCount();
            log.warn("\u26cf\u26cf\u26cf\u26cf\u26cf Mined {} (blk#{}): Available: {} Requested: {} \u26cf\u26cf\u26cf\u26cf\u26cf", new Object[]{this.rewardFromRegTestHeight(height).toPlainString(), height, availableAmount.toPlainString(), requestAmount.toPlainString()});
        }
        return unspent;
    }

    private Coin rewardFromRegTestHeight(int height) {
        int halvings = height / 150;
        return Coin.valueOf((long)(Coin.FIFTY_COINS.value >> halvings));
    }

    private Map<Address, Coin> calcChange(Coin availableFunds, Coin amountToSend, Address destAddress, Address changeAddress) {
        Coin change = availableFunds.value - (amountToSend.value + this.txFee.value) > 0L ? Coin.valueOf((long)(availableFunds.value - (amountToSend.value + this.txFee.value))) : Coin.ZERO;
        Map<Address, Coin> outputs = change.value > 0L ? this.mapOf(destAddress, amountToSend, this.client.getRegTestMiningAddress(), change) : Collections.singletonMap(destAddress, amountToSend);
        return outputs;
    }

    private <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        HashMap<K, V> outputs = new HashMap<K, V>();
        outputs.put(k1, v1);
        outputs.put(k2, v2);
        return outputs;
    }

    @Override
    public Address createFundedAddress(Coin amount) throws Exception {
        Address address = this.client.getNewAddress();
        this.requestBitcoin(address, amount);
        return address;
    }

    public TransactionIngredients createIngredients(Coin amount) throws JsonRpcException, IOException {
        TransactionIngredients ingredients = new TransactionIngredients();
        Address address = this.client.getNewAddress();
        this.requestBitcoin(address, amount);
        ingredients.address = address;
        ingredients.privateKey = this.client.dumpPrivKey(address);
        ingredients.outPoints = this.client.listUnspentOutPoints(address);
        return ingredients;
    }

    @Override
    public void fundingSourceMaintenance() {
        try {
            this.consolidateCoins();
        }
        catch (JsonRpcException e) {
            log.error("exception: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.error("exception: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    void consolidateCoins() throws JsonRpcException, IOException {
        Map<Address, Coin> outputs;
        List<UnspentOutput> unspentOutputs = this.getSpendable();
        Coin amountIn = this.sumUnspentOutputs(unspentOutputs);
        log.info("We have {} in {} utxos.", (Object)amountIn.toPlainString(), (Object)unspentOutputs.size());
        if (unspentOutputs.size() < 10 || amountIn.value <= 10L * this.txFee.value) {
            log.info("Not consolidating.");
            return;
        }
        List<Outpoint> inputs = this.unspentOutputsToOutpoints(unspentOutputs);
        String unsignedTxHex = this.client.createRawTransaction(inputs, outputs = Collections.singletonMap(this.client.getRegTestMiningAddress(), amountIn.subtract(this.txFee)));
        SignedRawTransaction signingResult = this.client.signRawTransactionWithWallet(unsignedTxHex);
        boolean complete = signingResult.isComplete();
        if (!complete) {
            log.error("Unable to complete signing on consolidate coins transaction.");
            log.error("SigningResult: {}", (Object)this.toJson(signingResult));
        }
        assert (complete);
        String signedTxHex = signingResult.getHex();
        Sha256Hash txid = this.sendRawTransactionUnlimitedFees(signedTxHex);
        log.warn("\u2b44\u2b44\u2b44\u2b44\u2b44\u2b44\u2b44 Consolidating transaction sent, txid = {}", (Object)txid);
    }

    private String toJson(SignedRawTransaction signingResult) {
        return this.client.getMapper().valueToTree((Object)signingResult).toPrettyString();
    }

    private List<UnspentOutput> availableFunds() throws IOException {
        return this.getSpendable(this.client.getRegTestMiningAddress());
    }

    private List<UnspentOutput> getSpendable() throws JsonRpcException, IOException {
        return this.client.listUnspent(1, this.defaultMaxConf, null);
    }

    private List<UnspentOutput> getSpendable(Address address) throws JsonRpcException, IOException {
        return this.client.listUnspent(1, this.defaultMaxConf, Collections.singletonList(address)).stream().filter(out -> out.isSpendable() && out.isSafe()).collect(Collectors.toList());
    }

    private List<Outpoint> unspentOutputsToOutpoints(List<UnspentOutput> unspentOutputs) {
        return unspentOutputs.stream().map(output -> new Outpoint(output.getTxid(), output.getVout())).collect(Collectors.toList());
    }

    private Coin sumUnspentOutputs(List<UnspentOutput> unspentOutputs) {
        return Coin.valueOf((long)unspentOutputs.stream().mapToLong(output -> output.getAmount().value).sum());
    }

    private Sha256Hash sendRawTransactionUnlimitedFees(String hexTx) throws IOException {
        return this.client.sendRawTransaction(hexTx, Coin.ZERO);
    }
}

