/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.rpc.internal;

import java.util.concurrent.ThreadFactory;
import org.bitcoinj.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinClientThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(BitcoinClientThreadFactory.class);
    private final Context context;
    private final String name;
    private final int priority;

    public BitcoinClientThreadFactory(Context context, String name, int priority) {
        this.context = context;
        this.name = name;
        this.priority = priority;
    }

    public BitcoinClientThreadFactory(Context context, String name) {
        this(context, name, 5);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(() -> {
            try {
                Context.propagate((Context)this.context);
                r.run();
            }
            catch (Throwable e) {
                log.error("Exception in thread", e);
                throw e;
            }
        }, this.name);
        thread.setPriority(this.priority);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(BitcoinClientThreadFactory::uncaughtException);
        return thread;
    }

    private static void uncaughtException(Thread t, Throwable e) {
        log.error("Uncaught exception in thread: ", e);
    }
}

