/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.rpc.bitcoind;

import com.msgilligan.bitcoinj.rpc.RpcConfig;
import com.msgilligan.bitcoinj.rpc.RpcURI;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

public class BitcoinConf
extends HashMap<String, String> {
    public final String rpcconnect = "rpconnect";
    public final String rpcport = "rpcport";
    public final String RPCCONNECT_DEFAULT = "localhost";
    public final String RPCPORT_DEFAULT = Integer.toString(8332);

    public BitcoinConf() {
        this.put("rpconnect", "localhost");
        this.put("rpcport", this.RPCPORT_DEFAULT);
    }

    public RpcConfig getRPCConfig() {
        URI uri;
        try {
            uri = new URI("http://" + (String)this.get("rpconnect") + ":" + (String)this.get("rpcport"));
        }
        catch (URISyntaxException e) {
            uri = RpcURI.getDefaultMainNetURI();
        }
        String netWorkId = this.getNetworkId();
        RpcConfig config = new RpcConfig(netWorkId, uri, (String)this.get("rpcuser"), (String)this.get("rpcpassword"));
        return config;
    }

    private String getNetworkId() {
        boolean isRegTest;
        String isTestNetString = (String)this.get("testnet");
        String isRegTestString = (String)this.get("regtest");
        boolean isTestNet = isTestNetString != null && isTestNetString.equals("1");
        boolean bl = isRegTest = isRegTestString != null && isRegTestString.equals("1");
        if (isRegTest && isTestNet) {
            throw new RuntimeException("Invalid config file, both 'testnet' and 'regtest' are set!");
        }
        if (isRegTest) {
            return "org.bitcoin.regtest";
        }
        if (isTestNet) {
            return "org.bitcoin.test";
        }
        return "org.bitcoin.production";
    }
}

