/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.rpc;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.msgilligan.bitcoinj.json.pojo.AddressInfo;
import com.msgilligan.bitcoinj.json.pojo.Outpoint;
import com.msgilligan.bitcoinj.json.pojo.SignedRawTransaction;
import com.msgilligan.bitcoinj.json.pojo.UnspentOutput;
import com.msgilligan.bitcoinj.rpc.BitcoinClient;
import com.msgilligan.bitcoinj.rpc.RpcConfig;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSocketFactory;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.script.Script;
import org.bouncycastle.util.encoders.Hex;
import org.consensusj.jsonrpc.JsonRpcStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinExtendedClient
extends BitcoinClient {
    private static final Logger log = LoggerFactory.getLogger(BitcoinExtendedClient.class);
    private static final BigInteger NotSoPrivatePrivateInt = new BigInteger(1, Hex.decode((String)"180cb41c7c600be951b5d3d0a7334acc7506173875834f7a6c4c786a28fcbb19"));
    private static final String RegTestMiningAddressLabel = "RegTestMiningAddress";
    private Address regTestMiningAddress;
    public final Coin stdTxFee = Coin.valueOf((long)10000L);
    public final Coin stdRelayTxFee = Coin.valueOf((long)1000L);
    public final Integer defaultMaxConf = 9999999;
    public final long stdTxFeeSatoshis = this.stdTxFee.getValue();

    public Coin getStdTxFee() {
        return this.stdTxFee;
    }

    public Coin getStdRelayTxFee() {
        return this.stdRelayTxFee;
    }

    public Integer getDefaultMaxConf() {
        return this.defaultMaxConf;
    }

    public BitcoinExtendedClient(SSLSocketFactory sslSocketFactory, NetworkParameters netParams, URI server, String rpcuser, String rpcpassword) {
        super(sslSocketFactory, netParams, server, rpcuser, rpcpassword);
    }

    public BitcoinExtendedClient(NetworkParameters netParams, URI server, String rpcuser, String rpcpassword) {
        this((SSLSocketFactory)SSLSocketFactory.getDefault(), netParams, server, rpcuser, rpcpassword);
    }

    public BitcoinExtendedClient(RpcConfig config) {
        this(config.getNetParams(), config.getURI(), config.getUsername(), config.getPassword());
    }

    public synchronized Address getRegTestMiningAddress() {
        if (!this.context.getParams().getId().equals("org.bitcoin.regtest")) {
            throw new UnsupportedOperationException("Operation only supported in RegTest context");
        }
        if (this.regTestMiningAddress == null) {
            try {
                ECKey notSoPrivatePrivateKey = ECKey.fromPrivate((BigInteger)NotSoPrivatePrivateInt, (boolean)false);
                Address address = Address.fromKey((NetworkParameters)RegTestParams.get(), (ECKey)notSoPrivatePrivateKey, (Script.ScriptType)Script.ScriptType.P2PKH);
                AddressInfo addressInfo = this.getAddressInfo(address);
                if (addressInfo.getIsmine() && !addressInfo.getIswatchonly() && addressInfo.getSolvable()) {
                    log.warn("Address with label {} is present in server-side wallet", (Object)RegTestMiningAddressLabel);
                    this.regTestMiningAddress = address;
                } else {
                    log.warn("Adding private key for {} and rescanning chain", (Object)RegTestMiningAddressLabel);
                    this.importPrivKey(notSoPrivatePrivateKey, RegTestMiningAddressLabel, true);
                    this.regTestMiningAddress = address;
                }
                log.warn("Retrieved regTestMiningAddress = {}", (Object)this.regTestMiningAddress);
            }
            catch (IOException e) {
                log.error("Exception while checking/importing regTestMiningAddress", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.regTestMiningAddress;
    }

    public List<Sha256Hash> generateBlocks(int numBlocks) throws JsonRpcStatusException, IOException {
        return this.generateToAddress(numBlocks, this.getRegTestMiningAddress());
    }

    public Block getBlock(int index) throws JsonRpcStatusException, IOException {
        Sha256Hash blockHash = this.getBlockHash(index);
        return this.getBlock(blockHash);
    }

    public List<Sha256Hash> clearMemPool() throws JsonRpcStatusException, IOException {
        CollectionType resultType = this.mapper.getTypeFactory().constructCollectionType(List.class, Sha256Hash.class);
        return (List)this.send("clearmempool", (JavaType)resultType, new Object[0]);
    }

    public String createRawTransaction(Address fromAddress, Map<Address, Coin> outputs) throws JsonRpcStatusException, IOException {
        long amountOut;
        HashMap<Address, Coin> outputsWithChange = new HashMap<Address, Coin>(outputs);
        List<UnspentOutput> unspentOutputs = this.listUnspent(0, this.defaultMaxConf, Collections.singletonList(fromAddress));
        List<Outpoint> inputs = unspentOutputs.stream().map(this::unspentToOutpoint).collect(Collectors.toList());
        long amountIn = unspentOutputs.stream().map(UnspentOutput::getAmount).mapToLong(Coin::getValue).sum();
        long amountChange = amountIn - (amountOut = outputs.values().stream().mapToLong(Coin::getValue).sum()) - this.stdTxFeeSatoshis;
        if (amountChange < 0L) {
            System.out.println("Insufficient funds");
        }
        if (amountChange > 0L) {
            outputsWithChange.put(fromAddress, Coin.valueOf((long)amountChange));
        }
        return this.createRawTransaction(inputs, outputsWithChange);
    }

    public String createRawTransaction(Address fromAddress, Address toAddress, Coin amount) throws JsonRpcStatusException, IOException {
        return this.createRawTransaction(fromAddress, Collections.singletonMap(toAddress, amount));
    }

    public Coin getBitcoinBalance(Address address) throws JsonRpcStatusException, IOException {
        return this.getBitcoinBalance(address, 1, this.defaultMaxConf);
    }

    public Coin getBitcoinBalance(Address address, Integer minConf) throws JsonRpcStatusException, IOException {
        return this.getBitcoinBalance(address, minConf, this.defaultMaxConf);
    }

    public Coin getBitcoinBalance(Address address, Integer minConf, Integer maxConf) throws JsonRpcStatusException, IOException {
        long btcBalance = 0L;
        List<UnspentOutput> unspentOutputs = this.listUnspent(minConf, maxConf, Collections.singletonList(address));
        for (UnspentOutput unspentOutput : unspentOutputs) {
            btcBalance += unspentOutput.getAmount().value;
        }
        return Coin.valueOf((long)btcBalance);
    }

    public Sha256Hash sendBitcoin(Address fromAddress, Address toAddress, Coin amount) throws JsonRpcStatusException, IOException {
        Map<Address, Coin> outputs = Collections.singletonMap(toAddress, amount);
        return this.sendBitcoin(fromAddress, outputs);
    }

    public Sha256Hash sendBitcoin(Address fromAddress, Map<Address, Coin> outputs) throws JsonRpcStatusException, IOException {
        String unsignedTxHex = this.createRawTransaction(fromAddress, outputs);
        SignedRawTransaction signingResult = this.signRawTransactionWithWallet(unsignedTxHex);
        Boolean complete = signingResult.isComplete();
        assert (complete.booleanValue());
        String signedTxHex = signingResult.getHex();
        Sha256Hash txid = this.sendRawTransaction(signedTxHex);
        return txid;
    }

    public Transaction createSignedTransaction(ECKey fromKey, List<TransactionOutput> outputs) throws JsonRpcStatusException, IOException {
        Address fromAddress = Address.fromKey((NetworkParameters)this.getNetParams(), (ECKey)fromKey, (Script.ScriptType)Script.ScriptType.P2PKH);
        Transaction tx = new Transaction(this.getNetParams());
        outputs.forEach(arg_0 -> ((Transaction)tx).addOutput(arg_0));
        List<TransactionOutput> unspentOutputs = this.listUnspentJ(fromAddress);
        long amountIn = unspentOutputs.stream().map(TransactionOutput::getValue).mapToLong(Coin::getValue).sum();
        long amountOut = outputs.stream().map(TransactionOutput::getValue).mapToLong(Coin::getValue).sum();
        long amountChange = amountIn - amountOut - this.stdTxFeeSatoshis;
        if (amountChange < 0L) {
            System.out.println("Insufficient funds");
        }
        if (amountChange > 0L) {
            tx.addOutput(Coin.valueOf((long)amountChange), fromAddress);
        }
        unspentOutputs.forEach(unspent -> tx.addSignedInput(unspent, fromKey));
        return tx;
    }

    public Transaction createSignedTransaction(ECKey fromKey, Address toAddress, Coin amount) throws JsonRpcStatusException, IOException {
        List<TransactionOutput> outputs = Collections.singletonList(new TransactionOutput(this.getNetParams(), null, amount, toAddress));
        return this.createSignedTransaction(fromKey, outputs);
    }

    public List<TransactionOutput> listUnspentJ(Address fromAddress) throws JsonRpcStatusException, IOException {
        List<Address> addresses = Collections.singletonList(fromAddress);
        List<UnspentOutput> unspentOutputs = this.listUnspent(0, this.defaultMaxConf, addresses);
        return unspentOutputs.stream().map(this::unspentToTransactionOutput).collect(Collectors.toList());
    }

    public List<TransactionOutPoint> listUnspentOutPoints(Address fromAddress) throws JsonRpcStatusException, IOException {
        List<Address> addresses = Collections.singletonList(fromAddress);
        List<UnspentOutput> unspentOutputsRPC = this.listUnspent(0, this.defaultMaxConf, addresses);
        return unspentOutputsRPC.stream().map(this::unspentToTransactionOutpoint).collect(Collectors.toList());
    }

    private TransactionOutput unspentToTransactionOutput(UnspentOutput unspentOutput) {
        try {
            return this.getRawTransaction(unspentOutput.getTxid()).getOutput((long)unspentOutput.getVout());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TransactionOutPoint unspentToTransactionOutpoint(UnspentOutput unspentOutput) {
        return new TransactionOutPoint(this.getNetParams(), (long)unspentOutput.getVout(), unspentOutput.getTxid());
    }

    private Outpoint unspentToOutpoint(UnspentOutput unspentOutput) {
        return new Outpoint(unspentOutput.getTxid(), unspentOutput.getVout());
    }
}

