/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.rpc;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.msgilligan.bitcoinj.json.conversion.HexUtil;
import com.msgilligan.bitcoinj.json.conversion.RpcClientModule;
import com.msgilligan.bitcoinj.json.pojo.AddressGroupingItem;
import com.msgilligan.bitcoinj.json.pojo.AddressInfo;
import com.msgilligan.bitcoinj.json.pojo.BlockChainInfo;
import com.msgilligan.bitcoinj.json.pojo.BlockInfo;
import com.msgilligan.bitcoinj.json.pojo.ChainTip;
import com.msgilligan.bitcoinj.json.pojo.NetworkInfo;
import com.msgilligan.bitcoinj.json.pojo.Outpoint;
import com.msgilligan.bitcoinj.json.pojo.RawTransactionInfo;
import com.msgilligan.bitcoinj.json.pojo.ReceivedByAddressInfo;
import com.msgilligan.bitcoinj.json.pojo.SignedRawTransaction;
import com.msgilligan.bitcoinj.json.pojo.TxOutInfo;
import com.msgilligan.bitcoinj.json.pojo.TxOutSetInfo;
import com.msgilligan.bitcoinj.json.pojo.UnspentOutput;
import com.msgilligan.bitcoinj.json.pojo.WalletTransactionInfo;
import com.msgilligan.bitcoinj.json.pojo.ZmqNotification;
import com.msgilligan.bitcoinj.rpc.NetworkParametersProperty;
import com.msgilligan.bitcoinj.rpc.RpcConfig;
import com.msgilligan.bitcoinj.rpc.internal.BitcoinClientThreadFactory;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.consensusj.jsonrpc.JsonRpcException;
import org.consensusj.jsonrpc.JsonRpcMessage;
import org.consensusj.jsonrpc.JsonRpcStatusException;
import org.consensusj.jsonrpc.RpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinClient
extends RpcClient
implements NetworkParametersProperty {
    private static final Logger log = LoggerFactory.getLogger(BitcoinClient.class);
    private static final int THREAD_POOL_SIZE = 5;
    private static final int SECOND_IN_MSEC = 1000;
    private static final int RETRY_SECONDS = 5;
    private static final int MESSAGE_SECONDS = 30;
    protected final Context context;
    protected final ThreadFactory threadFactory;
    protected final ExecutorService executorService;
    private int serverVersion = 0;

    public BitcoinClient(SSLSocketFactory sslSocketFactory, NetworkParameters netParams, URI server, String rpcuser, String rpcpassword) {
        super(sslSocketFactory, JsonRpcMessage.Version.V2, server, rpcuser, rpcpassword);
        this.context = new Context(netParams);
        this.mapper.registerModule((Module)new RpcClientModule(this.context.getParams()));
        this.threadFactory = new BitcoinClientThreadFactory(this.context, "Bitcoin RPC Client");
        this.executorService = Executors.newFixedThreadPool(5, this.threadFactory);
    }

    public BitcoinClient(NetworkParameters netParams, URI server, String rpcuser, String rpcpassword) {
        this((SSLSocketFactory)SSLSocketFactory.getDefault(), netParams, server, rpcuser, rpcpassword);
    }

    public BitcoinClient(RpcConfig config) {
        this(config.getNetParams(), config.getURI(), config.getUsername(), config.getPassword());
    }

    @Override
    public NetworkParameters getNetParams() {
        return this.context.getParams();
    }

    public ExecutorService getDefaultAsyncExecutor() {
        return this.executorService;
    }

    public void close() throws InterruptedException {
        this.executorService.shutdown();
        boolean successfullyTerminated = this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        if (!successfullyTerminated) {
            log.warn("timeout while closing");
        }
    }

    private synchronized int getServerVersion() throws IOException, JsonRpcStatusException {
        if (this.serverVersion == 0) {
            this.serverVersion = this.getNetworkInfo().getVersion();
        }
        return this.serverVersion;
    }

    public Boolean waitForServer(int timeout) throws JsonRpcException {
        log.debug("Waiting for server RPC ready...");
        String statusLast = null;
        for (int seconds = 0; seconds < timeout; seconds += 5) {
            String status;
            try {
                Integer block = this.getBlockCount();
                if (block != null) {
                    log.debug("RPC Ready.");
                    return true;
                }
                status = "getBlock returned null";
            }
            catch (SocketException se) {
                if (se.getMessage().equals("Unexpected end of file from server") || se.getMessage().equals("Connection reset") || se.getMessage().contains("Connection refused") || se.getMessage().equals("recvfrom failed: ECONNRESET (Connection reset by peer)")) {
                    status = se.getMessage();
                }
                throw new JsonRpcException("Unexpected exception in waitForServer", (Throwable)se);
            }
            catch (EOFException ignored) {
                status = ignored.getMessage();
            }
            catch (JsonRpcStatusException e) {
                if (e.jsonRpcCode == -28) {
                    status = e.getMessage();
                }
                log.error("Rethrowing JsonRpcStatusException: ", (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                status = e.getMessage();
            }
            try {
                if (!status.equals(statusLast)) {
                    log.info("Waiting for server: RPC Status: " + status);
                    statusLast = status;
                }
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                log.error(e.toString());
                Thread.currentThread().interrupt();
                return false;
            }
        }
        log.error("waitForServer() timed out after {} seconds.", (Object)timeout);
        return false;
    }

    public Boolean waitForBlock(int blockHeight, int timeout) throws JsonRpcStatusException, IOException {
        log.info("Waiting for server to reach block " + blockHeight);
        for (int seconds = 0; seconds < timeout; seconds += 5) {
            Integer block = this.getBlockCount();
            if (block >= blockHeight) {
                log.info("Server is at block " + block + " returning 'true'.");
                return true;
            }
            try {
                if (seconds % 30 == 0) {
                    log.debug("Server at block " + block);
                }
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                log.error(e.toString());
                Thread.currentThread().interrupt();
                return false;
            }
        }
        log.error("Timeout waiting for block " + blockHeight);
        return false;
    }

    public Integer getBlockCount() throws JsonRpcStatusException, IOException {
        return (Integer)this.send("getblockcount", new Object[0]);
    }

    public Sha256Hash getBlockHash(Integer index) throws JsonRpcStatusException, IOException {
        return (Sha256Hash)this.send("getblockhash", Sha256Hash.class, new Object[]{index});
    }

    public BlockInfo getBlockInfo(Sha256Hash hash) throws JsonRpcStatusException, IOException {
        return (BlockInfo)this.send("getblock", BlockInfo.class, new Object[]{hash, true});
    }

    public Block getBlock(Sha256Hash hash) throws JsonRpcStatusException, IOException {
        return (Block)this.send("getblock", Block.class, new Object[]{hash, false});
    }

    public List<Sha256Hash> generateToAddress(int numBlocks, Address address, Integer maxtries) throws IOException {
        CollectionType resultType = this.mapper.getTypeFactory().constructCollectionType(List.class, Sha256Hash.class);
        return (List)this.send("generatetoaddress", (JavaType)resultType, new Object[]{(long)numBlocks, address, maxtries});
    }

    public List<Sha256Hash> generateToAddress(int numBlocks, Address address) throws IOException {
        return this.generateToAddress(numBlocks, address, null);
    }

    public List<String> listWallets() throws JsonRpcStatusException, IOException {
        CollectionType resultType = this.mapper.getTypeFactory().constructCollectionType(List.class, String.class);
        return (List)this.send("listwallets", (JavaType)resultType, new Object[0]);
    }

    public Map<String, String> createWallet(String name, Boolean disablePrivateKeys, Boolean blank) throws JsonRpcStatusException, IOException {
        return (Map)this.send("createwallet", new Object[]{name, disablePrivateKeys, blank});
    }

    public Address getNewAddress() throws JsonRpcStatusException, IOException {
        return this.getNewAddress(null);
    }

    public Address getNewAddress(String label) throws JsonRpcStatusException, IOException {
        return (Address)this.send("getnewaddress", Address.class, new Object[]{label});
    }

    public ECKey dumpPrivKey(Address address) throws JsonRpcStatusException, IOException {
        return (ECKey)this.send("dumpprivkey", ECKey.class, new Object[]{address});
    }

    public void importPrivKey(ECKey privateKey, String label, boolean rescan) throws JsonRpcStatusException, IOException {
        this.send("importprivkey", Void.class, new Object[]{privateKey.getPrivateKeyEncoded(this.getNetParams()).toBase58(), label, rescan});
    }

    public String createRawTransaction(List<Outpoint> inputs, Map<Address, Coin> outputs) throws JsonRpcStatusException, IOException {
        return (String)this.send("createrawtransaction", new Object[]{inputs, outputs});
    }

    public SignedRawTransaction signRawTransactionWithWallet(String unsignedTransaction) throws JsonRpcStatusException, IOException {
        return (SignedRawTransaction)this.send("signrawtransactionwithwallet", SignedRawTransaction.class, new Object[]{unsignedTransaction});
    }

    public Transaction getRawTransaction(Sha256Hash txid) throws JsonRpcStatusException, IOException {
        String hexEncoded = (String)this.send("getrawtransaction", new Object[]{txid});
        byte[] raw = HexUtil.hexStringToByteArray((String)hexEncoded);
        return new Transaction(this.context.getParams(), raw);
    }

    public RawTransactionInfo getRawTransactionInfo(Sha256Hash txid) throws JsonRpcStatusException, IOException {
        return (RawTransactionInfo)this.send("getrawtransaction", RawTransactionInfo.class, new Object[]{txid, 1});
    }

    public Sha256Hash sendRawTransaction(Transaction tx, Coin maxFeeRate) throws JsonRpcStatusException, IOException {
        return (Sha256Hash)this.send("sendrawtransaction", Sha256Hash.class, new Object[]{tx, maxFeeRate});
    }

    public Sha256Hash sendRawTransaction(String hexTx, Coin maxFeeRate) throws JsonRpcStatusException, IOException {
        return (Sha256Hash)this.send("sendrawtransaction", Sha256Hash.class, new Object[]{hexTx, maxFeeRate});
    }

    public Sha256Hash sendRawTransaction(Transaction tx) throws JsonRpcStatusException, IOException {
        return this.sendRawTransaction(tx, (Coin)null);
    }

    public Sha256Hash sendRawTransaction(String hexTx) throws JsonRpcStatusException, IOException {
        return this.sendRawTransaction(hexTx, (Coin)null);
    }

    @Deprecated
    public Sha256Hash sendRawTransaction(Transaction tx, Boolean allowHighFees) throws JsonRpcStatusException, IOException {
        return (Sha256Hash)this.send("sendrawtransaction", Sha256Hash.class, new Object[]{tx, allowHighFees});
    }

    @Deprecated
    public Sha256Hash sendRawTransaction(String hexTx, Boolean allowHighFees) throws JsonRpcStatusException, IOException {
        return (Sha256Hash)this.send("sendrawtransaction", Sha256Hash.class, new Object[]{hexTx, allowHighFees});
    }

    public AddressInfo getAddressInfo(Address address) throws JsonRpcStatusException, IOException {
        return (AddressInfo)this.send("getaddressinfo", AddressInfo.class, new Object[]{address});
    }

    public Coin getReceivedByAddress(Address address) throws JsonRpcStatusException, IOException {
        return this.getReceivedByAddress(address, 1);
    }

    public Coin getReceivedByAddress(Address address, Integer minConf) throws JsonRpcStatusException, IOException {
        return (Coin)this.send("getreceivedbyaddress", Coin.class, new Object[]{address, minConf});
    }

    public List<ReceivedByAddressInfo> listReceivedByAddress(Integer minConf, Boolean includeEmpty) throws JsonRpcStatusException, IOException {
        CollectionType resultType = this.mapper.getTypeFactory().constructCollectionType(List.class, ReceivedByAddressInfo.class);
        return (List)this.send("listreceivedbyaddress", (JavaType)resultType, new Object[]{minConf, includeEmpty});
    }

    public List<UnspentOutput> listUnspent() throws JsonRpcStatusException, IOException {
        return this.listUnspent(null, null, null);
    }

    public List<UnspentOutput> listUnspent(Integer minConf, Integer maxConf) throws JsonRpcStatusException, IOException {
        return this.listUnspent(minConf, maxConf, null);
    }

    public List<UnspentOutput> listUnspent(Integer minConf, Integer maxConf, Iterable<Address> filter) throws JsonRpcStatusException, IOException {
        return this.listUnspent(minConf, maxConf, filter, true);
    }

    public List<UnspentOutput> listUnspent(Integer minConf, Integer maxConf, Iterable<Address> filter, boolean includeUnsafe) throws JsonRpcStatusException, IOException {
        CollectionType resultType = this.mapper.getTypeFactory().constructCollectionType(List.class, UnspentOutput.class);
        return (List)this.send("listunspent", (JavaType)resultType, new Object[]{minConf, maxConf, filter, includeUnsafe});
    }

    public TxOutInfo getTxOut(Sha256Hash txid, Integer vout) throws JsonRpcStatusException, IOException {
        return this.getTxOut(txid, vout, null);
    }

    public TxOutInfo getTxOut(Sha256Hash txid, Integer vout, Boolean includeMemoryPool) throws JsonRpcStatusException, IOException {
        return (TxOutInfo)this.send("gettxout", TxOutInfo.class, new Object[]{txid, vout, includeMemoryPool});
    }

    public TxOutSetInfo getTxOutSetInfo() throws JsonRpcStatusException, IOException {
        return (TxOutSetInfo)this.send("gettxoutsetinfo", TxOutSetInfo.class, new Object[0]);
    }

    public Coin getBalance() throws JsonRpcStatusException, IOException {
        return this.getBalance(null, null);
    }

    public Coin getBalance(String account) throws JsonRpcStatusException, IOException {
        return this.getBalance(account, null);
    }

    public Coin getBalance(String account, Integer minConf) throws JsonRpcStatusException, IOException {
        return (Coin)this.send("getbalance", Coin.class, new Object[]{account, minConf});
    }

    public Sha256Hash sendToAddress(Address address, Coin amount) throws JsonRpcStatusException, IOException {
        return this.sendToAddress(address, amount, null, null);
    }

    public Sha256Hash sendToAddress(Address address, Coin amount, String comment, String commentTo) throws JsonRpcStatusException, IOException {
        return (Sha256Hash)this.send("sendtoaddress", Sha256Hash.class, new Object[]{address, amount, comment, commentTo});
    }

    public Sha256Hash sendFrom(String account, Address address, Coin amount) throws JsonRpcStatusException, IOException {
        return (Sha256Hash)this.send("sendfrom", Sha256Hash.class, new Object[]{account, address, amount});
    }

    public Sha256Hash sendMany(String account, Map<Address, Coin> amounts) throws JsonRpcStatusException, IOException {
        return (Sha256Hash)this.send("sendmany", Sha256Hash.class, new Object[]{account, amounts});
    }

    public Boolean setTxFee(Coin amount) throws JsonRpcStatusException, IOException {
        return (Boolean)this.send("settxfee", new Object[]{amount});
    }

    public WalletTransactionInfo getTransaction(Sha256Hash txid) throws JsonRpcStatusException, IOException {
        return (WalletTransactionInfo)this.send("gettransaction", WalletTransactionInfo.class, new Object[]{txid});
    }

    public BlockChainInfo getBlockChainInfo() throws JsonRpcStatusException, IOException {
        return (BlockChainInfo)this.send("getblockchaininfo", BlockChainInfo.class, new Object[0]);
    }

    public NetworkInfo getNetworkInfo() throws JsonRpcStatusException, IOException {
        return (NetworkInfo)this.send("getnetworkinfo", NetworkInfo.class, new Object[0]);
    }

    public List<ZmqNotification> getZmqNotifications() throws JsonRpcStatusException, IOException {
        CollectionType resultType = this.mapper.getTypeFactory().constructCollectionType(List.class, ZmqNotification.class);
        return (List)this.send("getzmqnotifications", (JavaType)resultType, new Object[0]);
    }

    public List<List<AddressGroupingItem>> listAddressGroupings() throws JsonRpcStatusException, IOException {
        List raw = (List)this.send("listaddressgroupings", new Object[0]);
        ArrayList<List<AddressGroupingItem>> result = new ArrayList<List<AddressGroupingItem>>();
        for (List rawGrouping : raw) {
            ArrayList<AddressGroupingItem> grouping = new ArrayList<AddressGroupingItem>();
            for (List addressItem : rawGrouping) {
                AddressGroupingItem item = new AddressGroupingItem(addressItem, this.getNetParams());
                grouping.add(item);
            }
            result.add(grouping);
        }
        return result;
    }

    public String help() throws JsonRpcStatusException, IOException {
        return this.help(null);
    }

    public String help(String command) throws JsonRpcStatusException, IOException {
        return (String)this.send("help", new Object[]{command});
    }

    public List<String> getCommands() throws JsonRpcStatusException, IOException {
        ArrayList<String> commands = new ArrayList<String>();
        for (String entry : this.help().split("\n")) {
            if (entry.isEmpty() || entry.matches("== (.+) ==")) continue;
            String command = entry.split(" ")[0];
            commands.add(command);
        }
        return commands;
    }

    public Boolean commandExists(String command) throws JsonRpcStatusException, IOException {
        return !this.help(command).contains("help: unknown command");
    }

    public void invalidateBlock(Sha256Hash hash) throws JsonRpcStatusException, IOException {
        this.send("invalidateblock", new Object[]{hash});
    }

    public void reconsiderBlock(Sha256Hash hash) throws JsonRpcStatusException, IOException {
        this.send("reconsiderblock", new Object[]{hash});
    }

    public List<ChainTip> getChainTips() throws JsonRpcStatusException, IOException {
        CollectionType resultType = this.mapper.getTypeFactory().constructCollectionType(List.class, ChainTip.class);
        return (List)this.send("getchaintips", (JavaType)resultType, new Object[0]);
    }

    public void addNode(String node, String command) throws JsonRpcStatusException, IOException {
        this.send("addnode", new Object[]{node, command});
    }

    public JsonNode getAddedNodeInfo(boolean details, String node) throws JsonRpcStatusException, IOException {
        return (JsonNode)this.send("getaddednodeinfo", JsonNode.class, new Object[]{details, node});
    }

    public JsonNode getAddedNodeInfo(boolean details) throws JsonRpcStatusException, IOException {
        return this.getAddedNodeInfo(details, null);
    }
}

