/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.json.conversion;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.NetworkParameters;

public class AddressDeserializer
extends JsonDeserializer<Address> {
    private final NetworkParameters netParams;

    public AddressDeserializer() {
        this(null);
    }

    public AddressDeserializer(NetworkParameters netParams) {
        this.netParams = netParams;
    }

    public Address deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken token = p.getCurrentToken();
        switch (token) {
            case VALUE_STRING: {
                try {
                    return Address.fromString((NetworkParameters)this.netParams, (String)p.getValueAsString());
                }
                catch (AddressFormatException e) {
                    throw new InvalidFormatException(p, "Invalid Address", (Object)p.getValueAsString(), Address.class);
                }
            }
        }
        return (Address)ctxt.handleUnexpectedToken(Address.class, p);
    }
}

