/*
 * Decompiled with CFR 0.152.
 */
package com.enrique.stackblur;

import android.graphics.Bitmap;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NativeBlurProcess {
    private static final int EXECUTOR_THREADS = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(EXECUTOR_THREADS);

    private static native void functionToBlur(Bitmap var0, int var1, int var2, int var3, int var4);

    public Bitmap blur(Bitmap original, float radius) {
        Bitmap bitmapOut = original.copy(Bitmap.Config.ARGB_8888, true);
        int cores = EXECUTOR_THREADS;
        ArrayList<NativeTask> horizontal = new ArrayList<NativeTask>(cores);
        ArrayList<NativeTask> vertical = new ArrayList<NativeTask>(cores);
        for (int i = 0; i < cores; ++i) {
            horizontal.add(new NativeTask(bitmapOut, (int)radius, cores, i, 1));
            vertical.add(new NativeTask(bitmapOut, (int)radius, cores, i, 2));
        }
        try {
            EXECUTOR.invokeAll(horizontal);
        }
        catch (InterruptedException e) {
            return bitmapOut;
        }
        try {
            EXECUTOR.invokeAll(vertical);
        }
        catch (InterruptedException e) {
            return bitmapOut;
        }
        return bitmapOut;
    }

    static {
        System.loadLibrary("blur");
    }

    private static class NativeTask
    implements Callable<Void> {
        private final Bitmap _bitmapOut;
        private final int _radius;
        private final int _totalCores;
        private final int _coreIndex;
        private final int _round;

        public NativeTask(Bitmap bitmapOut, int radius, int totalCores, int coreIndex, int round) {
            this._bitmapOut = bitmapOut;
            this._radius = radius;
            this._totalCores = totalCores;
            this._coreIndex = coreIndex;
            this._round = round;
        }

        @Override
        public Void call() throws Exception {
            NativeBlurProcess.functionToBlur(this._bitmapOut, this._radius, this._totalCores, this._coreIndex, this._round);
            return null;
        }
    }
}

