/*
 * Decompiled with CFR 0.152.
 */
package com.commit451.foregroundviews;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import com.commit451.foregroundviews.ForegroundDelegate;

public class ForegroundRelativeLayout
extends RelativeLayout {
    ForegroundDelegate mForegroundDelegate;

    public ForegroundRelativeLayout(Context context) {
        this(context, null);
    }

    public ForegroundRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ForegroundRelativeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle, 0);
    }

    @TargetApi(value=21)
    public ForegroundRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (Build.VERSION.SDK_INT < 23 || this.getContext().getApplicationInfo().targetSdkVersion < 23) {
            this.mForegroundDelegate = new ForegroundDelegate((View)this);
            this.mForegroundDelegate.init(context, attrs, defStyleAttr, defStyleRes);
        }
    }

    public int getForegroundGravity() {
        if (this.mForegroundDelegate != null) {
            return this.mForegroundDelegate.getForegroundGravity();
        }
        return super.getForegroundGravity();
    }

    public void setForegroundGravity(int foregroundGravity) {
        if (this.mForegroundDelegate != null) {
            this.mForegroundDelegate.setForegroundGravity(foregroundGravity);
        } else {
            super.setForegroundGravity(foregroundGravity);
        }
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        if (this.mForegroundDelegate != null) {
            return super.verifyDrawable(who) || who == this.mForegroundDelegate.getForeground();
        }
        return super.verifyDrawable(who);
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mForegroundDelegate != null) {
            this.mForegroundDelegate.jumpDrawablesToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mForegroundDelegate != null) {
            this.mForegroundDelegate.drawableStateChanged();
        }
    }

    public void setForeground(Drawable foreground) {
        if (this.mForegroundDelegate != null) {
            this.mForegroundDelegate.setForeground(foreground);
        } else {
            super.setForeground(foreground);
        }
    }

    public Drawable getForeground() {
        if (this.mForegroundDelegate != null) {
            return this.mForegroundDelegate.getForeground();
        }
        return super.getForeground();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mForegroundDelegate != null) {
            this.mForegroundDelegate.onLayout(changed, left, top, right, bottom);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mForegroundDelegate != null) {
            this.mForegroundDelegate.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mForegroundDelegate != null) {
            this.mForegroundDelegate.draw(canvas);
        }
    }

    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mForegroundDelegate != null) {
            this.mForegroundDelegate.drawableHotspotChanged(x, y);
        }
    }
}

